# -*- coding: utf-8 -*-

"""
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterFolderDestination)
from qgis import processing
import gdal
import numpy as np
from datetime import datetime
import os

class SE_BeneficiSociali(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    INPUTRP = 'INPUTRP'
    INPUTPRE = 'INPUTPRE'
    INPUTRF = 'INPUTRF'
    INPUTFUT = 'INPUTFUT'
    PIXEL_RES = 'PIXEL_RES'
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        """
        Returns a translatable string with the self.tr() function.
        """
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return SE_BeneficiSociali()

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return '06 SE Benefici culturali'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('06 SE Benefici culturali')

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("Algoritmo per il calcolo dei benefici culturali, nell'ambito del calcolo dei Servizi Ecosistemici per la Città di Torino")

    def initAlgorithm(self, config=None):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        
        self.addParameter(
            QgsProcessingParameterRasterLayer(
                self.INPUTRP,
                self.tr('Raster Uso suolo Stato attuale'),
                [QgsProcessing.TypeRaster]
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
            self.INPUTPRE,
            self.tr('Anno attuale'),
            QgsProcessingParameterNumber.Integer,
            2021
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterLayer(
                self.INPUTRF,
                self.tr('Raster Uso suolo Stato di progetto'),
                [QgsProcessing.TypeRaster]
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
            self.INPUTFUT,
            self.tr('Anno progetto'),
            QgsProcessingParameterNumber.Integer,
            2030
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
            self.PIXEL_RES,
            self.tr('Risoluzione spaziale raster (m)'),
            QgsProcessingParameterNumber.Integer,
            2
            )
        )

        self.addParameter(
            QgsProcessingParameterFolderDestination(
                self.OUTPUT,
                self.tr('Salva nella cartella')
            )
        )
        
    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        # Load present raster
        present_raster = self.parameterAsRasterLayer(parameters, self.INPUTRP, context)
        ds_present = gdal.Open(present_raster.dataProvider().dataSourceUri())
        arr_present = ds_present.GetRasterBand(1).ReadAsArray()
        # Clean negative values
        arr_present[arr_present < 0] = 0


        # Load future raster
        future_raster = self.parameterAsRasterLayer(parameters, self.INPUTRF, context)
        ds_future = gdal.Open(future_raster.dataProvider().dataSourceUri())
        arr_future = ds_future.GetRasterBand(1).ReadAsArray()
        # Clean negative values
        arr_future[arr_future < 0] = 0

        # Pixel area
        area_pixel = self.parameterAsInt(parameters, self.PIXEL_RES, context) * self.parameterAsInt(
            parameters, self.PIXEL_RES, context)

        # Scores of single lucode
        ROS_lucode = {}
        ROS_lucode[1] = 0.4
        ROS_lucode[2] = 0.4
        ROS_lucode[3] = 0.1
        ROS_lucode[4] = 0.1
        ROS_lucode[5] = 0.4
        ROS_lucode[6] = 0.4
        ROS_lucode[7] = 0.1
        ROS_lucode[8] = 0
        ROS_lucode[9] = 0.2
        ROS_lucode[10] = 0.2
        ROS_lucode[11] = 0.2
        ROS_lucode[12] = 0.2
        ROS_lucode[13] = 0.2
        ROS_lucode[14] = 0.2
        ROS_lucode[15] = 0.1
        ROS_lucode[16] = 0.1
        ROS_lucode[17] = 0.3
        ROS_lucode[18] = 0.2
        ROS_lucode[19] = 0.3
        ROS_lucode[20] = 0
        ROS_lucode[21] = 0.9
        ROS_lucode[22] = 0.8
        ROS_lucode[23] = 0.7
        ROS_lucode[24] = 0.5
        ROS_lucode[25] = 0.2
        ROS_lucode[26] = 0.6
        ROS_lucode[27] = 0.5
        ROS_lucode[28] = 0.6
        ROS_lucode[29] = 0.5
        ROS_lucode[30] = 0.4
        ROS_lucode[31] = 0.9
        ROS_lucode[32] = 0
        ROS_lucode[33] = 0
        ROS_lucode[34] = 0.1
        ROS_lucode[35] = 0
        ROS_lucode[36] = 0
        ROS_lucode[37] = 0.4
        ROS_lucode[38] = 0.6
        ROS_lucode[39] = 0.5
        ROS_lucode[40] = 0.4
        ROS_lucode[41] = 0.4
        ROS_lucode[42] = 0.4
        ROS_lucode[43] = 0.3
        ROS_lucode[44] = 0.2
        ROS_lucode[45] = 0.7
        ROS_lucode[46] = 0
        ROS_lucode[47] = 0
        ROS_lucode[48] = 0.1
        ROS_lucode[49] = 0.1
        ROS_lucode[50] = 0
        ROS_lucode[51] = 0
        ROS_lucode[52] = 0
        ROS_lucode[53] = 0.2
        ROS_lucode[54] = 0.1
        ROS_lucode[55] = 0
        ROS_lucode[56] = 0.1
        ROS_lucode[57] = 0.4
        ROS_lucode[58] = 0.3
        ROS_lucode[59] = 0.4
        ROS_lucode[60] = 0
        ROS_lucode[61] = 0.7
        ROS_lucode[62] = 0.8
        ROS_lucode[63] = 0.7
        ROS_lucode[64] = 0.4
        ROS_lucode[65] = 0.4
        ROS_lucode[66] = 0
        ROS_lucode[67] = 0
        ROS_lucode[68] = 0.6
        ROS_lucode[69] = 0.8
        ROS_lucode[70] = 0.6
        ROS_lucode[71] = 0.1
        ROS_lucode[72] = 0
        ROS_lucode[73] = 0.4
        ROS_lucode[74] = 0.4
        ROS_lucode[75] = 0.4
        ROS_lucode[76] = 0.4
        ROS_lucode[77] = 0
        ROS_lucode[78] = 0.8
        ROS_lucode[79] = 0.4
        ROS_lucode[80] = 0
        ROS_lucode[81] = 0
        ROS_lucode[82] = 0.8
        ROS_lucode[83] = 0.9
        ROS_lucode[84] = 0.9
        ROS_lucode[85] = 0.75
        ROS_lucode[86] = 0.6
        ROS_lucode[87] = 0.9

        # Economic values of each lucode
        value_lucode = {}
        value_lucode[1] = 1.44
        value_lucode[2] = 1.44
        value_lucode[3] = 0
        value_lucode[4] = 1.44
        value_lucode[5] = 1.44
        value_lucode[6] = 1.44
        value_lucode[7] = 1.44
        value_lucode[8] = 0
        value_lucode[9] = 2.36
        value_lucode[10] = 2.36
        value_lucode[11] = 0
        value_lucode[12] = 0
        value_lucode[13] = 0
        value_lucode[14] = 0
        value_lucode[15] = 0
        value_lucode[16] = 0
        value_lucode[17] = 2.36
        value_lucode[18] = 0
        value_lucode[19] = 1.44
        value_lucode[20] = 0
        value_lucode[21] = 2.36
        value_lucode[22] = 2.36
        value_lucode[23] = 2.36
        value_lucode[24] = 2.36
        value_lucode[25] = 0
        value_lucode[26] = 2.36
        value_lucode[27] = 2.36
        value_lucode[28] = 0
        value_lucode[29] = 1.44
        value_lucode[30] = 1.44
        value_lucode[31] = 0
        value_lucode[32] = 0
        value_lucode[33] = 0
        value_lucode[34] = 0
        value_lucode[35] = 0
        value_lucode[36] = 0
        value_lucode[37] = 1.44
        value_lucode[38] = 1.44
        value_lucode[39] = 1.44
        value_lucode[40] = 1.44
        value_lucode[41] = 1.44
        value_lucode[42] = 1.44
        value_lucode[43] = 1.44
        value_lucode[44] = 1.44
        value_lucode[45] = 0
        value_lucode[46] = 0
        value_lucode[47] = 0
        value_lucode[48] = 0
        value_lucode[49] = 0
        value_lucode[50] = 0
        value_lucode[51] = 0
        value_lucode[52] = 0
        value_lucode[53] = 0
        value_lucode[54] = 0
        value_lucode[55] = 0
        value_lucode[56] = 0
        value_lucode[57] = 1.44
        value_lucode[58] = 1.44
        value_lucode[59] = 1.44
        value_lucode[60] = 0
        value_lucode[61] = 1.44
        value_lucode[62] = 1.44
        value_lucode[63] = 1.44
        value_lucode[64] = 1.44
        value_lucode[65] = 1.44
        value_lucode[66] = 0
        value_lucode[67] = 0
        value_lucode[68] = 1.44
        value_lucode[69] = 1.44
        value_lucode[70] = 1.44
        value_lucode[71] = 0
        value_lucode[72] = 0
        value_lucode[73] = 1.44
        value_lucode[74] = 1.44
        value_lucode[75] = 1.44
        value_lucode[76] = 1.44
        value_lucode[77] = 0
        value_lucode[78] = 0
        value_lucode[79] = 1.44
        value_lucode[80] = 0
        value_lucode[81] = 0
        value_lucode[82] = 1.49
        value_lucode[83] = 1.49
        value_lucode[84] = 1.49
        value_lucode[85] = 1.49
        value_lucode[86] = 1.49
        value_lucode[87] = 1.49

        [rows, cols] = arr_present.shape

        # Value euro per squared meter
        ROS_present_array = np.zeros((rows, cols))
        value_present_array = np.zeros((rows, cols))
        n_lucode_present_lucode = {}
        n_pixel_valid_present = 0
        n_valid_lucode_present = 0
        # Summing scores for each distinct lucode
        for lucode in np.unique(arr_present):
            if lucode in ROS_lucode.keys():
                n_lucode = np.sum(arr_present == lucode)
                ROS_present_array[np.where(arr_present == lucode)] = ROS_lucode[lucode] * area_pixel
                n_valid_lucode_present += 1
                n_lucode_present_lucode[lucode] = n_lucode
                n_pixel_valid_present += np.sum(arr_present == lucode)
                value_present_array[np.where(arr_present == lucode)] = value_lucode[lucode] * ROS_lucode[lucode] * area_pixel

        # Value euro per squared meter
        ROS_future_array = np.zeros((rows, cols))
        value_future_array = np.zeros((rows, cols))
        n_lucode_future_lucode = {}
        n_pixel_valid_future = 0
        n_valid_lucode_future = 0
        # Summing scores for each distinct lucode
        for lucode in np.unique(arr_future):
            if lucode in ROS_lucode.keys():
                n_lucode = np.sum(arr_future == lucode)
                ROS_future_array[np.where(arr_future == lucode)] = ROS_lucode[lucode] * area_pixel
                n_valid_lucode_future += 1
                n_lucode_future_lucode[lucode] = n_lucode
                n_pixel_valid_future += np.sum(arr_future == lucode)
                value_future_array[np.where(arr_future == lucode)] = value_lucode[lucode] * ROS_lucode[lucode] * area_pixel
        # Years
        present = self.parameterAsInt(parameters, self.INPUTPRE, context)
        future = self.parameterAsInt(parameters, self.INPUTFUT, context)
        # Initialize and write on output raster present
        path_output = self.parameterAsString(parameters, self.OUTPUT, context)
        print(self.OUTPUT)
        print(path_output)
        file_output = path_output + '/06_benefici_culturali_presente_ROS.tiff'
        try:
            driver = gdal.GetDriverByName("GTiff")
            outdata = driver.Create(file_output, cols, rows,  1, gdal.GDT_Float64)
            print(file_output)
            print(outdata)
            outdata.SetGeoTransform(ds_present.GetGeoTransform())  ##sets same geotransform as input
            outdata.SetProjection(ds_present.GetProjection())  ##sets same projection as input
            outdata.GetRasterBand(1).WriteArray(ROS_present_array)
            outdata.FlushCache()
        except AttributeError:
            path_output = os.path.join(os.path.expanduser("~"), 'Desktop')
            if not os.path.exists(path_output):
                path_output = os.path.join(os.path.expanduser("~"))
            file_output = path_output + '/06_benefici_culturali_presente_ROS.tiff'
            outdata = driver.Create(file_output, cols, rows,  1, gdal.GDT_Float64)
            print(file_output)
            print(outdata)
            outdata.SetGeoTransform(ds_present.GetGeoTransform())  ##sets same geotransform as input
            outdata.SetProjection(ds_present.GetProjection())  ##sets same projection as input
            outdata.GetRasterBand(1).WriteArray(ROS_present_array)
            outdata.FlushCache()
        # Initialize and write on output raster future
        file_output = path_output + '/06_benefici_culturali_futuro_ROS.tiff'
        driver = gdal.GetDriverByName("GTiff")
        outdata = driver.Create(file_output, cols, rows,  1, gdal.GDT_Float64)
        outdata.SetGeoTransform(ds_present.GetGeoTransform())  ##sets same geotransform as input
        outdata.SetProjection(ds_present.GetProjection())  ##sets same projection as input
        outdata.GetRasterBand(1).WriteArray(ROS_future_array)
        outdata.FlushCache()
        file_output = path_output + '/SE_06_benefici_culturali_delta_euro.tiff'
        driver = gdal.GetDriverByName("GTiff")

        arr_output = value_future_array - value_present_array
        outdata = driver.Create(file_output, cols, rows,  1, gdal.GDT_Float64)
        outdata.SetGeoTransform(ds_present.GetGeoTransform())  ##sets same geotransform as input
        outdata.SetProjection(ds_present.GetProjection())  ##sets same projection as input
        outdata.GetRasterBand(1).WriteArray(arr_output)
        print(np.max(outdata.GetRasterBand(1).ReadAsArray()))
        outdata.FlushCache()  ##saves to disk!!
        outdata = None
        band = None
        ds = None
        report_output = path_output + '/SE_benefici_culturali.txt'
        f = open(report_output, "w+")
        today = datetime.today().strftime('%Y-%m-%d-%H:%M:%S')
        f.write("Sommario dell'analisi dei benefici_sociali\n")
        f.write("Data: " + today + "\n\n\n")
        f.write("Analisi stato di fatto\n\n")
        f.write("Anno corrente: %i \n" % present)
        f.write(
            "Valore ROS - Stato attuale : %f \n" % (
                np.mean(ROS_present_array)))
        f.write("Valore totale dei SE culturali (€): %f \n\n\n" % (np.sum(value_present_array)))
        f.write("Analisi stato di progetto\n\n")
        f.write("Anno progetto: %i \n" % future)
        f.write(
            "Valore ROS - Stato progetto : %f \n" % (
                np.mean(ROS_future_array)))
        f.write("Valore totale del dei benefici_culturali (€): %f \n\n\n" % np.sum(value_future_array))
        f.write("Differenze tra stato di progetto e stato attuale\n\n")
        f.write("Anno progetto: %i - %i\n" % (present, future))
        f.write(
            "Differenza in termini economici dei benefici culturali (stato di progetto – stato attuale) (€):%d \n" % (
                ((np.sum(value_future_array) - np.sum(value_present_array)))))
        return {self.OUTPUT: path_output}

        
        # -----------------------------------------------------------------------------------  
        # Copyright (c) 2021 Città di Torino.
        # 
        # This material is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program. If not, see http://www.gnu.org/licenses.
        # -----------------------------------------------------------------------------------  

