# -*- coding: utf-8 -*-
"""
/***************************************************************************
    Quick VRT Imagery Loader
    A QGIS plugin
 Loads satellite imagery from Microsoft's Planetary Computer STAC API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2026-02-01
        git sha              : $Format:%H$
        copyright            : (C) 2026 by Vagner Teixeira
        email                : junior.vagner@live.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import Qgis, QgsMessageLog
from .dependency_manager import DependencyManager
from . import resources

class SentinelSTAC:
    """QGIS plugin implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        
        self.deps = {
            'pystac-client': 'pystac_client',
            'planetary-computer': 'planetary_computer',
            'shapely': 'shapely'
        }
        
        self.dep_manager = DependencyManager(self.iface, "Quick VRT Imagery Loader", self.deps)
        self.plugin_dir = os.path.dirname(__file__)
        self.dlg = None 
        
        user_locale = QSettings().value('locale/userLocale') or 'en'
        locale = str(user_locale)[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            '{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            if self.translator.load(locale_path):
                QCoreApplication.installTranslator(self.translator)
                QgsMessageLog.logMessage(
                    'Quick VRT Imagery Loader: loaded translation {}'.format(locale_path),
                    'Quick VRT Imagery Loader', Qgis.Info)
        else:
            QgsMessageLog.logMessage(
                'Quick VRT Imagery Loader: no translation for locale "{}", tried {}'.format(locale, locale_path),
                'Quick VRT Imagery Loader', Qgis.Info)
            
        self.actions = []
        self.menu = self.tr(u'&Quick VRT Imagery Loader')

    def tr(self, message):
        """Qt translation API"""
        return QCoreApplication.translate('SentinelSTAC', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        parent=None):
        """Menu and toolbar action"""

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip:
            action.setStatusTip(status_tip)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Starts the plugin GUI."""
        # Verify dependencies at startup
        self.dependencies_ok = self.dep_manager.check_and_install()
        
        icon_path = ":/plugins/sentinel_stac_loader/icon.png"
        
        self.main_action = self.add_action(
            icon_path,
            text=self.tr(u'Loads satellite images quickly'),
            callback=self.run,
            enabled_flag=self.dependencies_ok,
            parent=self.iface.mainWindow())

        if not self.dependencies_ok:
            self.iface.messageBar().pushMessage(
                "Attention", 
                "Missing dependencies. Click on the plugin icon to try again.", 
                level=Qgis.Warning,
                duration=5
            )

    def unload(self):
        """Removes the plugin from QGIS."""
        for action in self.actions:
            self.iface.removePluginMenu(self.menu, action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Executes the plugin logic."""
        
    
        if not self.dep_manager.check_and_install():
            return

        # Lazy import the dialog to avoid import errors when QGIS loads.
        from .sentinel_stac_loader_dialog import SentinelSTACDialog
        
        if self.dlg is None:
            self.dlg = SentinelSTACDialog()
            if hasattr(self.dlg, 'btn_carregar'):
                self.dlg.btn_carregar.clicked.connect(self.dlg.process_stac_load)
            if hasattr(self.dlg, 'btn_listar'):
                self.dlg.btn_listar.clicked.connect(self.dlg.popular_tabela)

        self.dlg.show()
        self.dlg.exec_()