# -*- coding: utf-8 -*-
"""
/***************************************************************************
    Quick VRT Imagery Loader
    A QGIS plugin
 Loads satellite imagery from Microsoft's Planetary Computer STAC API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2026-02-01
        git sha              : $Format:%H$
        copyright            : (C) 2026 by Vagner Teixeira
        email                : junior.vagner@live.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from .resources import *
from .sentinel_stac_loader_dialog import SentinelSTACDialog
import os.path

class SentinelSTAC:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.dlg = None 
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SentinelSTAC_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)
        self.actions = []
        self.menu = self.tr(u'&Quick VRT Imagery Loader')
        self.first_start = None

    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('SentinelSTAC', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar."""

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        icon_path = ':/plugins/sentinel_stac_loader/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Abrir Sentinel STAC Loader'),
            callback=self.run,
            parent=self.iface.mainWindow())

        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&Quick VRT Imagery Loader'), action)
            self.iface.removeToolBarIcon(action)
#Executes plugin
    def run(self):
        if self.dlg is None:
            from .sentinel_stac_loader_dialog import SentinelSTACDialog
            self.dlg = SentinelSTACDialog()
            
            self.dlg.btn_carregar.clicked.connect(self.dlg.process_stac_load)
            self.dlg.btn_listar.clicked.connect(self.dlg.popular_tabela)

        self.dlg.show()
        self.dlg.exec_()