# -*- coding: utf-8 -*-
"""
/***************************************************************************
 S2_vn_rectangle
                                 A QGIS plugin
 Sentinel 2 removed cloud
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-07-11
        git sha              : $Format:%H$
        copyright            : (C) 2020 by GFD
        email                : hoa.lq@gfd.com.vn
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from __future__ import absolute_import
from builtins import object
from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from qgis.PyQt.QtWidgets import QAction,QApplication
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsMessageLog,Qgis,QgsProject,QgsRasterLayer
from PyQt5.QtCore import QDate, QTime, QDateTime, Qt
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Sentinel2_removed_cloud_rec_dialog import S2_vn_rectangleDialog
from .Search_Download_S2_dialog import search_download_s2Dialog
from .services.administrative_service import *
from itertools import groupby
from datetime import date
import os.path
import ee
from ee_plugin import Map
from .rectangleAreaTool import RectangleAreaTool

try:
    import ptvsd
    ptvsd.enable_attach(secret='my_secret', address = ('localhost', 5679))
except:
    pass


class S2_vn_rectangle(object):
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Sentinel2_removed_cloud_rec{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Search & Download S2 removed cloud Images')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'sentinel2_removed_cloud_rec')
        self.toolbar.setObjectName(u'sentinel2_removed_cloud_rec')

        self.provinces = []
        self.districts = []
        self.communes = []

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Sentinel2_removed_cloud_rec', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
        checkable=True):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        action.setCheckable(checkable)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        self.add_action(
            ':/plugins/sentinel2_removed_cloud_rec/icon.png',
            text=QApplication.translate('searchdownload', u'Tìm và tải ảnh S2 lọc mây của Việt Nam/ Search images by VietNam administrative boundary'),
            callback=self.s2Vietnam,
            parent=self.iface.mainWindow(),
            add_to_menu=False,
            checkable=True,            
            status_tip=QApplication.translate('searchdownload', 'Tìm và tải ảnh S2 lọc mây của Việt Nam'))

        self.rectangleAction = self.add_action(
                                    ':/plugins/sentinel2_removed_cloud_rec/rectangle.png',
                                    text=QApplication.translate('searchdownload', u'Tìm và tải ảnh theo tọa độ vẽ bound/ Find & Download S2 images removed cloud by draw canvas'),
                                    callback=self.runRectangle,
                                    parent=self.iface.mainWindow(),
                                    add_to_menu=False,
                                    checkable=True,                                    
                                    status_tip=QApplication.translate('searchdownload', 'Find & Download S2 images removed cloud by draw canvas'))

        self.rectangleAreaTool = RectangleAreaTool(self.iface.mapCanvas(), self.rectangleAction)
        self.rectangleAreaTool.rectangleCreated.connect(self.s2world)
        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&OSM Downloader'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    # Source getDate(): Anh Thị - VST Rừng
    def getDate(self, chuoingay):
        input_date = chuoingay
        str_Input = [int(''.join(i)) for is_digit, i in groupby(
            input_date, str.isdigit) if is_digit]

        str_Output = date(int(str_Input[1]), int(
            str_Input[2]), int(str_Input[3]))

        self.ketqua = str(str_Output)
        return self.ketqua

    #Add Basemap function
    def getBasemap(self):
        basemap = QgsProject.instance().mapLayersByName('Google Maps')
        
        if len(basemap)== 0:
            urlWithParams = 'type=xyz&url=https://mt1.google.com/vt?lyrs%3Dm%26x%3D%7Bx%7D%26y%3D%7By%7D%26z%3D%7Bz%7D&zmax=19&zmin=0'
            rlayer = QgsRasterLayer(urlWithParams, 'Google Maps', 'wms')  
            if rlayer.isValid():
                QgsProject.instance().addMapLayer(rlayer)
            else:
                self.iface.messageBar().pushMessage("Do not open Google Maps",level=Qgis.Success, duration=5)   

    def s2world(self, startX, startY, endX, endY):
        """Run method that performs all the real work"""
        # Create the dialog (after translation) and keep reference
        if startX == endX and startY == endY:
            return

        self.dlg = S2_vn_rectangleDialog(self.iface, startX, startY, endX, endY)
        
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        #PRefix file name
        
        QgsMessageLog.logMessage(self.dlg.pre.text(),'Hello Hoa LE')
        #Bound to clip
        bound = ee.Geometry.Rectangle(startX,startY,endX,endY)
        self.bound = bound


        # See if OK was pressed
        if result:
            if self.dlg.check.isChecked():
                self.getBasemap()
                self.getS2_w()
                self.downloadS2_w()
            elif self.dlg.check_ndvi.isChecked():
                self.getBasemap()
                self.getS2_w()
                self.downloadNDVI_w()
            elif self.dlg.check_nbr.isChecked():
                self.getBasemap()
                self.getS2_w()
                self.downloadNBR_w()

            elif self.dlg.check.isChecked() or self.dlg.check_ndvi.isChecked():
                self.getBasemap()
                self.getS2_w()
                self.downloadS2_w()
                self.downloadNDVI_w()
            elif self.dlg.check.isChecked() or self.dlg.check_nbr.isChecked():
                self.getBasemap()
                self.getS2_w()
                self.downloadS2_w()
                self.downloadNBR_w() 
            elif self.dlg.check_nbr.isChecked() or self.dlg.check_ndvi.isChecked():
                self.getBasemap()
                self.getS2_w()
                self.downloadNDVI_w()
                self.downloadNBR_w()                          
            else:
                self.getBasemap()                
                self.getS2_w()

            # self.getS2()
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass   
      

    def getS2_w(self):
        startDate_dlg = str(self.dlg.time0.date())
        endDate_dlg = str(self.dlg.time1.date())

        startDate = str(self.getDate(startDate_dlg))
        endDate = str(self.getDate(endDate_dlg))
        bands = ['B4', 'B3', 'B2']
        cloudy = 20
              
        # /cloud function to remove clouds

        def S2_SR_CLOUD_PROBABILITY():
            primaryFeatures = ee.ImageCollection("COPERNICUS/S2_SR_HARMONIZED")
            secondaryFeatures = ee.ImageCollection(
                "COPERNICUS/S2_CLOUD_PROBABILITY")
            toyFilter = ee.Filter.equals(
                leftField='system:index', rightField='system:index')

            innerJoined = ee.Join.inner().apply(primary=primaryFeatures,
                                                secondary=secondaryFeatures, condition=toyFilter)

            def joinResult(img):
                return ee.Image(img.get('primary')).addBands(img.get('secondary'))
            newCollection = innerJoined.map(joinResult)
            return ee.ImageCollection(newCollection)

        # Filter date
        S2_removed_cloud = S2_SR_CLOUD_PROBABILITY().filterDate(startDate, endDate).filterBounds(self.bound)
        numberImg = S2_removed_cloud.size().getInfo()
        if numberImg >0:
            def maskClouds(image):
                cloudProbabilityThreshold = cloudy  # Threshold cloudy
                cloudMask = image.select('probability').lt(
                    cloudProbabilityThreshold)
                return image.updateMask(cloudMask)

            # Apply cloud mask
            S2_removed_cloud_mean = S2_removed_cloud.map(maskClouds).mean()
            #Visual
            visParams = {'bands': bands, 'max': 2000,'forceRgbOutput':True}
            ndvi_palette = 'd7191c, fdae61, ffffbf, a6d96a,1a9641'
            nbr_palette = '1a9850, ffffbf, f46d43, d73027'

            S2_removed_cloud_mean_exp = S2_removed_cloud_mean.visualize(**visParams)

            #NDVI calculate
            ndvi = S2_removed_cloud_mean.normalizedDifference(['B8', 'B4'])
            #NBR index
            nbr = S2_removed_cloud_mean.normalizedDifference(['B8', 'B11'])
            #Type file name
            dateStr = ee.String(startDate.format('YYYY_MM_dd')).getInfo() + '_to_' + ee.String(endDate.format('YYYY_MM_dd')).getInfo()
            export_filename = self.dlg.pre.text() + "_S2_RGB_" + dateStr

            self.ndvi_filename = self.dlg.pre.text() + "_NDVI_" + dateStr
            self.nbr_filename = self.dlg.pre.text() + "_NBR_" + dateStr

            #Zoom layer
            # Map.centerObject(self.bound.centroid().coordinates().getInfo(),9)
            #Add Map
            Map.addLayer(ndvi.clip(self.bound), {'min': -1,'max': 1.0, 'palette': ndvi_palette},self.ndvi_filename)
            Map.addLayer(nbr.clip(self.bound), {'min': -1,'max': 1.0, 'palette': nbr_palette},self.nbr_filename)
            Map.addLayer(S2_removed_cloud_mean.select(bands).clip(self.bound), {'min': 0, 'max': 2000}, export_filename)
            #Message log
            self.iface.messageBar().pushMessage( "Add Sentinel 2 removed clouded Successfull: " +  self.dlg.pre.text()  +" from " + dateStr,level=Qgis.Success, duration=5)       
            self.export_filename = export_filename
            self.S2_removed_cloud_mean_exp = S2_removed_cloud_mean_exp
            self.ndvi = ndvi
            self.nbr = nbr
            self.ndvi_filename = self.ndvi_filename
            self.nbr_filename = self.nbr_filename
        else:
            self.iface.messageBar().pushMessage("No image in date range!",level=Qgis.Success, duration=10)  
   


    def downloadS2_w(self):
        task = ee.batch.Export.image.toDrive(image=self.S2_removed_cloud_mean_exp.clip(self.bound),
                                             description=self.export_filename,
                                             folder="SENTINEL2_VN",
                                             region=self.bound.getInfo()[
            'coordinates'],
            scale=10,
            fileFormat='GeoTIFF',
            skipEmptyTiles=True)
        task.start()

    def downloadNDVI_w(self):
        task = ee.batch.Export.image.toDrive(image=self.ndvi.clip(self.bound),
                                             description=self.ndvi_filename,
                                             folder="SENTINEL2_VN",
                                             region=self.bound.getInfo()[
            'coordinates'],
            scale=10,
            fileFormat='GeoTIFF',
            skipEmptyTiles=True)
        task.start()

    def downloadNBR_w(self):
        task = ee.batch.Export.image.toDrive(image=self.nbr.clip(self.bound),
                                             description=self.nbr_filename,
                                             folder="SENTINEL2_VN",
                                             region=self.bound.getInfo()[
            'coordinates'],
            scale=10,
            fileFormat='GeoTIFF',
            skipEmptyTiles=True)
        task.start()

    def runRectangle(self, b):
        if b:
            self.iface.mapCanvas().setMapTool(self.rectangleAreaTool)
        else:
            self.iface.mapCanvas().unsetMapTool(self.rectangleAreaTool)
# --------------------------------------VIET NAM----------------------------------------------------------------           
    # Vietnam boundary
        # Import list province

    def getProvince(self):
      
        self.provinces = fetch_provinces().json()
        for province in self.provinces:
            self.dlg.slt_province.addItem(province['name_1'])
    # Import list district

    def getDistrict(self):
        self.dlg.slt_district.clear()
        province_current_index = self.dlg.slt_province.currentIndex()
        selected_province = self.provinces[province_current_index]
        gid_1 = selected_province["gid_1"]

        self.districts = fetch_districts(gid_1).json()
        for district in self.districts:
            self.dlg.slt_district.addItem(district["name_2"])

    # Import list commues
    def getCommune(self):
        self.dlg.slt_commune.clear()
        district_current_index = self.dlg.slt_district.currentIndex()
        selected_district = self.districts[district_current_index]
        gid_2 = selected_district["gid_2"]

        self.communes = fetch_communes(gid_2).json()
        for commune in self.communes:
            self.dlg.slt_commune.addItem(commune["varname_3"])

    def s2Vietnam(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == False:
            self.first_start = True
        
        self.getBasemap()
        # show the dialog
        self.dlg = search_download_s2Dialog()

        self.getProvince()
        self.dlg.slt_province.currentIndexChanged.connect(self.getDistrict)
        self.dlg.slt_district.currentIndexChanged.connect(self.getCommune)
        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()

        # See if OK was pressed
        if result:
            if self.dlg.check.isChecked():
                self.getBasemap()
                self.getS2_vn()
                self.downloadS2_vn()
            elif self.dlg.check_ndvi.isChecked():
                self.getBasemap()
                self.getS2_vn()
                self.downloadNDVI_vn()
            elif self.dlg.check_nbr.isChecked():
                self.getBasemap()
                self.getS2_vn()
                self.downloadNBR_vn()

            elif self.dlg.check.isChecked() or self.dlg.check_ndvi.isChecked():
                self.getBasemap()
                self.getS2_vn()
                self.downloadS2_vn()
                self.downloadNDVI_vn()
            elif self.dlg.check.isChecked() or self.dlg.check_nbr.isChecked():
                self.getBasemap()
                self.getS2_vn()
                self.downloadS2_vn()
                self.downloadNBR_vn() 
            elif self.dlg.check_nbr.isChecked() or self.dlg.check_ndvi.isChecked():
                self.getBasemap()
                self.getS2_vn()
                self.downloadNDVI_vn()
                self.downloadNBR_vn()                          
            else:
                self.getBasemap()                
                self.getS2_vn()
            pass


    def getS2_vn(self):
        provinceName_box = self.dlg.slt_province.currentText()
        district_box = self.dlg.slt_district.currentText()
        commune_box = self.dlg.slt_commune.currentText()
        # commune_json = QgsVectorLayer(os.path.join(os.path.dirname(__file__),"data\gadm36_communes.geojson"), "boundaries", "ogr")
        # communes = commune_json.getFeatures(QgsFeatureRequest().setFilterExpression(f'"NAME_1" = \'{provinceName_box}\'').setFilterExpression(f'"NAME_2" = \'{district_box}\'')).geometry()
        xa = ee.FeatureCollection(
            'users/lethiquynhhoa/vietnam/gadm_commune_vn')
        # // Filter bound
        communes = xa.filter(ee.Filter.eq('name_1', provinceName_box))\
            .filter(ee.Filter.eq('name_2', district_box))\
            .filter(ee.Filter.eq('varname_3', commune_box))

        startDate_dlg = str(self.dlg.time0.date())
        endDate_dlg = str(self.dlg.time1.date())

        startDate = str(self.getDate(startDate_dlg))
        endDate = str(self.getDate(endDate_dlg))

        bands = ['B4', 'B3', 'B2']
        cloudy = 20
        # /cloud function to remove clouds

        def S2_SR_CLOUD_PROBABILITY():
            primaryFeatures = ee.ImageCollection("COPERNICUS/S2_SR_HARMONIZED")
            secondaryFeatures = ee.ImageCollection(
                "COPERNICUS/S2_CLOUD_PROBABILITY")
            toyFilter = ee.Filter.equals(
                leftField='system:index', rightField='system:index')

            innerJoined = ee.Join.inner().apply(primary=primaryFeatures,
                                                secondary=secondaryFeatures, condition=toyFilter)

            def joinResult(img):
                return ee.Image(img.get('primary')).addBands(img.get('secondary'))
            newCollection = innerJoined.map(joinResult)
            return ee.ImageCollection(newCollection)

        # Filter date
        S2_removed_cloud = S2_SR_CLOUD_PROBABILITY().filterDate(
            startDate, endDate).filterBounds(communes)
        numberImg = S2_removed_cloud.size().getInfo()
        if numberImg >0:
            def maskClouds(image):
                cloudProbabilityThreshold = cloudy  # Threshold cloudy
                cloudMask = image.select('probability').lt(
                    cloudProbabilityThreshold)
                return image.updateMask(cloudMask)

            # Apply cloud mask
            S2_removed_cloud_mean = S2_removed_cloud.map(maskClouds).mean()
            #Vizual
            visParams = {'bands': bands, 'max': 2000,'forceRgbOutput':True}
            ndvi_palette = 'd7191c, fdae61, ffffbf, a6d96a,1a9641'
            nbr_palette = '1a9850, ffffbf, f46d43, d73027'

            S2_removed_cloud_mean_vn = S2_removed_cloud_mean.visualize(**visParams)

            
            #NDVI calculate
            ndvi_vn = S2_removed_cloud_mean.normalizedDifference(['B8', 'B4'])
            #NBR index
            nbr_vn = S2_removed_cloud_mean.normalizedDifference(['B8', 'B11'])
            #Type file name
            dateStr = ee.String(startDate.format('YYYY_MM_dd')).getInfo() + '_to_' + ee.String(endDate.format('YYYY_MM_dd')).getInfo()
            export_filename = commune_box + "_S2_RGB_" + dateStr
            self.ndvi_filename = commune_box + "_NDVI_" + dateStr
            self.nbr_filename = commune_box + "_NBR_" + dateStr

            #Zoom layer
            Map.centerObject(communes, 15)
            #Add Map
            Map.addLayer(ndvi_vn.clip(communes), {'min': -1,'max': 1.0, 'palette': ndvi_palette},self.ndvi_filename)
            Map.addLayer(nbr_vn.clip(communes), {'min': -1,'max': 1.0, 'palette': nbr_palette},self.nbr_filename)             
            Map.addLayer(S2_removed_cloud_mean.select(bands).clip(communes), {'min': 0, 'max': 2000}, export_filename)
            #Message log
            self.iface.messageBar().pushMessage( "Add Sentinel 2 removed clouded Successfull: " + commune_box + " from " + ee.String(startDate.format('YYYY_MM_dd')).getInfo() + " to " + ee.String(endDate.format('YYYY_MM_dd')).getInfo(),level=Qgis.Success, duration=5)       
            self.export_filename = export_filename
            self.commues = communes
            self.S2_removed_cloud_mean_vn = S2_removed_cloud_mean_vn
            self.ndvi_vn = ndvi_vn
            self.nbr_vn = nbr_vn

        else:
            self.iface.messageBar().pushMessage("No image in date range!",level=Qgis.Success, duration=10)           

    def downloadS2_vn(self):
        task = ee.batch.Export.image.toDrive(image=self.S2_removed_cloud_mean_vn.clip(self.commues),
                                             description=self.export_filename,
                                             folder="SENTINEL2_VN",
                                             region=self.commues.geometry().getInfo()[
            'coordinates'],
            scale=10,
            fileFormat='GeoTIFF',
            skipEmptyTiles=True)
        task.start()

    def downloadNDVI_vn(self):
        task = ee.batch.Export.image.toDrive(image=self.ndvi_vn.clip(self.commues),
                                             description=self.ndvi_filename,
                                             folder="SENTINEL2_VN",
                                             region=self.bound.getInfo()[
            'coordinates'],
            scale=10,
            fileFormat='GeoTIFF',
            skipEmptyTiles=True)
        task.start()

    def downloadNBR_vn(self):
        task = ee.batch.Export.image.toDrive(image=self.nbr_vn.clip(self.commues),
                                             description=self.nbr_filename,
                                             folder="SENTINEL2_VN",
                                             region=self.bound.getInfo()[
            'coordinates'],
            scale=10,
            fileFormat='GeoTIFF',
            skipEmptyTiles=True)
        task.start()