#!/usr/bin/python
import config
import os,sys
import shutil
import time
import tempfile
import osgeo.gdal
import osgeo.ogr
from osgeo.gdalconst import *
import numpy as np
import math
import argparse
import warnings
from utils import Bar

sys.path.append(os.path.split(os.path.dirname(os.path.abspath(__file__)))[0])

from sensum_library.preprocess import *
from sensum_library.classification import *
from sensum_library.segmentation import *
from sensum_library.conversion import *
from sensum_library.segmentation_opt import *
from sensum_library.features import *
from sensum_library.secondary_indicators import *

def main():
    warnings.filterwarnings("ignore")
    arg = args()
    input_file = str(arg.input_file)
    blocks_folder = str(arg.blocks_folder)
    output_folder = str(arg.output_folder)
    field = str(arg.field)
    spectrals = ["max_br", "mean", "min_br", "mode", "ndvi_std", "ndvi_mean", "std", "weigh_br"]
    indexes_list_spectral = [spectral for spectral in spectrals if getattr(arg, spectral)]
    textures = ["ASM", "contrast", "correlation", "dissimilarity", "energy", "homogeneity"]
    indexes_list_texture = [texture for texture in textures if getattr(arg, texture)]
    #if os.path.isfile(output_shape): os.remove(output_shape)
    if arg.multi:
        test_features_multi(input_file, blocks_folder, output_folder, indexes_list_spectral, indexes_list_texture,field)
    else:
        test_features(input_file, blocks_folder, output_folder, indexes_list_spectral, indexes_list_texture,field)

def args():
    parser = argparse.ArgumentParser(description='Calculate Features')
    parser.add_argument("input_file", help="????")
    parser.add_argument("blocks_folder", help="????")
    parser.add_argument("output_folder", help="????")
    parser.add_argument('field', help="????")
    parser.add_argument("--max_br", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--mean", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--min_br", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--mode", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--ndvi_std", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--ndvi_mean", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--std", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--weigh_br", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--ASM", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--contrast", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--correlation", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--dissimilarity", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--energy", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--homogeneity", default=False, const=True, nargs='?', help="????")
    parser.add_argument("--multi", default=False, const=True, nargs='?', help="????")
    args = parser.parse_args()
    return args

def test_features(input_file,blocks_folder,output_folder,indexes_list_spectral,indexes_list_texture,field):
    start_time = time.time()
    ndvi_comp = []
    wb_comp = []
    for i in range(0,124):
        segmentation_shape = blocks_folder + 'Blocks_mod_buf5_ID__'+str(i)+'.shp'
        output_shape = output_folder + 'Blocks_21_3_buf5_ID__'+str(i)+'.shp'
        print segmentation_shape
        print output_shape
        #Read original image - base layer
        input_list = read_image(input_file,np.uint16,0)
        #input_list_tf = read_image(input_file,np.uint8,0) #different data type necessary for texture features
        rows,cols,nbands,geo_transform,projection = read_image_parameters(input_file)
        input_list_tf = linear_quantization(input_list,64)
        print indexes_list_spectral
        #Conversion of the provided segmentation shapefile to raster for further processing
        shp2rast(segmentation_shape, segmentation_shape[:-4]+'.TIF', rows, cols, field)
        seg_list = read_image(segmentation_shape[:-4]+'.TIF',np.int32,0)
        if (('ndvi_mean' in indexes_list_spectral) or ('ndvi_std' in indexes_list_spectral)) and nbands > 3:
            ndvi = (input_list[3].astype(float)-input_list[2].astype(float)) / (input_list[3].astype(float)+input_list[2].astype(float))
            ndvi_comp = [s for s in indexes_list_spectral if 'ndvi_mean' in s or 'ndvi_std' in s]
        if 'weigh_br' in indexes_list_spectral:
            band_sum = np.zeros((rows,cols))
            for b in range(0,nbands):
                band_sum = band_sum + input_list[b]
            wb_comp = [s for s in indexes_list_spectral if 'weigh_br' in s]
        ind_list_spectral = [s for s in indexes_list_spectral if 'ndvi_mean' not in s and 'ndvi_std' not in s and 'weigh_br' not in s]

        #print ind_list_spectral
        #read input shapefile
        driver_shape=osgeo.ogr.GetDriverByName('ESRI Shapefile')
        infile=driver_shape.Open(segmentation_shape,0)
        inlayer=infile.GetLayer()
        #create output shapefile
        if os.path.isfile(output_shape):
            os.remove(output_shape)
        outfile=driver_shape.CreateDataSource(output_shape)
        outlayer=outfile.CreateLayer('Features',geom_type=osgeo.ogr.wkbPolygon)

        layer_defn = inlayer.GetLayerDefn()
        infeature = inlayer.GetNextFeature()
        dn_def = osgeo.ogr.FieldDefn(field, osgeo.ogr.OFTInteger)
        outlayer.CreateField(dn_def)
        #max_brightness, min_brightness, ndvi_mean, ndvi_standard_deviation, weighted_brightness
        for b in range(1,nbands+1):
            for si in range(0,len(ind_list_spectral)):
                field_def = osgeo.ogr.FieldDefn(ind_list_spectral[si] + str(b), osgeo.ogr.OFTReal)
                outlayer.CreateField(field_def)
                
            for sp in range(0,len(indexes_list_texture)):
                if len(indexes_list_texture[sp]+str(b)) > 10:
                    cut = len(indexes_list_texture[sp]+str(b)) - 10 
                    field_def = osgeo.ogr.FieldDefn(indexes_list_texture[sp][:-cut] + str(b), osgeo.ogr.OFTReal)
                else:
                    field_def = osgeo.ogr.FieldDefn(indexes_list_texture[sp] + str(b), osgeo.ogr.OFTReal)
                outlayer.CreateField(field_def)
            
        if ndvi_comp:
            for nd in range(0,len(ndvi_comp)):
                field_def = osgeo.ogr.FieldDefn(ndvi_comp[nd], osgeo.ogr.OFTReal)
                outlayer.CreateField(field_def)
        if wb_comp:
            field_def = osgeo.ogr.FieldDefn(wb_comp[0], osgeo.ogr.OFTReal)
            outlayer.CreateField(field_def)
              
        feature_def = outlayer.GetLayerDefn()
        n_feature = inlayer.GetFeatureCount()
        i = 1
        #loop through segments
        status = Bar(n_feature, "Computing Features...")
        while infeature:
            status(i+1)
            i = i+1
            # get the input geometry
            geom = infeature.GetGeometryRef()
            # create a new feature
            outfeature = osgeo.ogr.Feature(feature_def)
            # set the geometry and attribute
            outfeature.SetGeometry(geom)
            #field_names = [layer_defn.GetFieldDefn(i).GetName() for i in range(layer_defn.GetFieldCount())]
            dn = infeature.GetField(field)
            outfeature.SetField(field,dn)
            if len(ind_list_spectral) > 0 or len(indexes_list_texture)>0:
                for b in range(1,nbands+1):
                    if len(ind_list_spectral) > 0:
                        spectral_list = spectral_segments(input_list[b-1], dn, seg_list[0], ind_list_spectral, nbands)
                        for si in range(0,len(ind_list_spectral)):
                            outfeature.SetField(ind_list_spectral[si] + str(b),float(spectral_list[si]))
                
                    if len(indexes_list_texture)>0:
                        texture_list = texture_segments(input_list_tf[b-1],dn,seg_list[0],indexes_list_texture)
                        for sp in range(0,len(indexes_list_texture)):
                            if len(indexes_list_texture[sp]+str(b)) > 10:
                                cut = len(indexes_list_texture[sp]+str(b)) - 10
                                outfeature.SetField(indexes_list_texture[sp][:-cut] + str(b),float(texture_list[sp]))
                            else:
                                outfeature.SetField(indexes_list_texture[sp] + str(b),float(texture_list[sp]))
            if ndvi_comp:
                ndvi_list = spectral_segments(ndvi, dn, seg_list[0], ndvi_comp, nbands)
                if len(ndvi_list) > 0:
                    for nd in range(0,len(ndvi_comp)):
                        outfeature.SetField(ndvi_comp[nd],ndvi_list[nd])
            if wb_comp:
                wb = spectral_segments(band_sum, dn, seg_list[0], wb_comp, nbands)
                if len(wb) > 0:
                    outfeature.SetField(wb_comp[0],wb[0])

            outlayer.CreateFeature(outfeature)
            outfeature.Destroy()
            infeature = inlayer.GetNextFeature()
        shutil.copyfile(segmentation_shape[:-4]+'.prj', output_shape[:-4]+'.prj')
        print 'Output created: ' + output_shape
        # close the shapefiles
        infile.Destroy()
        outfile.Destroy()
    end_time = time.time()
    print 'Total time = ' + str(end_time-start_time)


if __name__ == "__main__":
    main()
