# -*- coding: utf-8 -*-
# """
# /***************************************************************************
#  Login
#                                  A QGIS plugin
#  This window can be used to login to SenseHawk platform.
#  Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
#                              -------------------
#         begin                : 2022-08-25
#         git sha              : $Format:%H$
#         copyright            : (C) 2022 by SenseHawk
#         email                : kiranh@sensehawk.com
#  ***************************************************************************/
#
# /***************************************************************************
#  *                                                                         *
#  *   This program is free software; you can redistribute it and/or modify  *
#  *   it under the terms of the GNU General Public License as published by  *
#  *   the Free Software Foundation; either version 2 of the License, or     *
#  *   (at your option) any later version.                                   *
#  *                                                                         *
#  ***************************************************************************/
# """

from ..sensehawk_apis.core_apis import core_login
from ..windows.load import LoadWindow

from qgis.PyQt import QtWidgets, uic
from qgis.core import QgsMessageLog, Qgis, QgsTask, QgsApplication
from qgis.PyQt.QtCore import Qt

from ..tasks import loginTask

import os

LOGIN_UI, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'login.ui'))


class LoginWindow(QtWidgets.QDockWidget, LOGIN_UI):

    def __init__(self, iface):
        """Constructor."""
        super(LoginWindow, self).__init__()
        self.setupUi(self)
        self.loginButton.clicked.connect(self.start_login_task)
        self.user_email = None
        self.user_password = None
        self.core_token = None
        self.iface = iface
        # Add to the left docking area by default
        self.iface.addDockWidget(Qt.LeftDockWidgetArea, self)
        self.load_window = None

    def logger(self, message, level=Qgis.Info):
        QgsMessageLog.logMessage(message, 'SenseHawk QC', level=level)

    def login_callback(self, login_task_status, login_task):
        if login_task_status != 3:
            return None
        if not login_task.returned_values:
            self.logger("Login task returned None...", level=Qgis.Warning)
            return None
        self.show_load_window()

    def start_login_task(self):
        login_task = QgsTask.fromFunction("Login", loginTask, login_window=self)
        QgsApplication.taskManager().addTask(login_task)
        login_task.statusChanged.connect(lambda login_task_status: self.login_callback(login_task_status, login_task))

    def show_load_window(self):
        # Initialize load save window (next window post login)
        self.load_window = LoadWindow(self.user_email, self.core_token, self.iface)
        self.load_window.show()
        self.hide()
