# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SeisPosImportDialog
                                 A QGIS plugin
 This plugin imports Seismic Positioning or Navigation data from various formats such as P1/11 (P111), P1/90 (P190), SPS.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-06-30
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Gurpreet Singh
        email                : gurpreet.s.singh@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtCore import QUrl
from PyQt5.QtGui import QDesktopServices

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'seismic_importer_dialog_base.ui'))


class SeisPosImportDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(SeisPosImportDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # Set up company logo
        logo_path = os.path.join(os.path.dirname(__file__), 'company_logo.png')
        if os.path.exists(logo_path):
            self.companyLogo.setText(
                f'<div style="text-align: center;">'
                f'<div style="display: inline-block; background-color: white; padding: 5px; border-radius: 3px;">'
                f'<a href="https://www.toplevelview.com">'
                f'<img src="{logo_path}" style="max-width: 150px; height: auto; object-fit: contain;" alt="Top Level View">'
                f'</a>'
                f'<br>'
                f'<a href="https://www.toplevelview.com" style="text-decoration: none; color: #666666; font-size: 10px;">'
                f'Built by Top Level View'
                f'</a>'
                f'</div>'
                f'</div>'
            )
        else:
            self.companyLogo.setText(
                '<div style="text-align: center;">'
                '<div style="display: inline-block; background-color: white; padding: 5px; border-radius: 3px;">'
                '<a href="https://www.toplevelview.com">'
                '<span style="font-size: 14px; color: #0066cc;">Top Level View</span>'
                '</a>'
                '<br>'
                '<a href="https://www.toplevelview.com" style="text-decoration: none; color: #666666; font-size: 10px;">'
                'Built by Top Level View'
                '</a>'
                '</div>'
                '</div>'
            )
