# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sections
                                 A QGIS plugin
 Creates a section polygon layer from a point layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Marek Zygadło
        email                : m.zygadlo@gis4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QLabel
from qgis.core import QgsProject
from qgis.core import QgsMapLayerProxyModel
from qgis.gui import QgsFileWidget
from qgis.utils import iface
from qgis.core import QgsVectorLayer, QgsField
from qgis.core import QgsWkbTypes
from qgis.core import QgsRectangle
from qgis.core import QgsGeometry
from qgis.core import QgsFeature, edit, QgsVectorFileWriter
from PyQt5.QtCore import QVariant

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .sections_dialog import SectionsDialog
import os.path
import os


class Sections:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Sections_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Sections')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Sections', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/sections/img/icon.svg'
        self.add_action(
            icon_path,
            text=self.tr(u'Sections from points'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Sections'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = SectionsDialog()
            
            #początek comboBox1
            global formaty
            formaty = [
            ('A0',841,1189),
            ('A1',594,841),
            ('A2',420,594),
            ('A3',297,420),
            ('A4',210,297),
            ('A5',148,210),
            ('A6',105,148),
            ('A7',74,105),
            ('A8',52,74),
            ('A9',37,52),
            ('A10',26,37),
            ('B0',1000,1414),
            ('B1',707,1000),
            ('B2',500,707),
            ('B3',353,500),
            ('B4',250,353),
            ('B5',176,250),
            ('B6',125,176),
            ('B7',88,125),
            ('B8',62,88),
            ('B9',44,62),
            ('B10',31,44)
            ]
            
            # początek dopisywania
            self.dlg.pointLayer.setFilters(QgsMapLayerProxyModel.PointLayer)
            self.dlg.pointLayer.setShowCrs(True)
            
            # wypełniam combo box format            
            self.dlg.comboBoxFormat.addItems([format[0]+" "+str(format[2])+"x"+str(format[1])+" "+"mm" for format in formaty])
            self.dlg.comboBoxFormat.setCurrentIndex(4)
            
            def currentIndexChanged(self, f):
            	 print(formaty[f][0])
            
            # wypełnim como box orientacja i ustawiam na landscape
            self.dlg.comboBoxOrientacja.addItems(['Landscape', 'Portrait'])
            self.dlg.comboBoxOrientacja.setCurrentIndex(0)
            
            # Dodaję scale
            self.dlg.spinBoxScale.setValue(500)
            
            # Dodaje marginesy   
            self.dlg.doubleSpinBoxLeftMargin.setValue(25.00)
            self.dlg.doubleSpinBoxRightMargin.setValue(10.00)
            self.dlg.doubleSpinBoxTopMargin.setValue(10.00)
            self.dlg.doubleSpinBoxBottomMargin.setValue(10.00)

            # dodaje ścieżkę zapisu
            #self.dlg.outputDir.setFilePath(QgsProject.instance().homePath())

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            
            layer = self.dlg.pointLayer.currentLayer()
            
            # pobieram wybraną warstwę
            selectedlayer = self.dlg.pointLayer.currentLayer()
            
            # pobieram i wyświetlam nazwę wybranej warstwy
            selectedlayername = selectedlayer.name()
            #self.dlg.label_layer_name.setText(str(selectedlayername))
            
            # wyświetlam Orientację
            orientacja = self.dlg.comboBoxOrientacja.currentText()
            #self.dlg.label_orientacja.setText(orientacja)
            
            # pobieranie i wyświetlanie print size
            selectedformat = self.dlg.comboBoxFormat.currentIndex()
            #self.dlg.label_print_size.setText(str(selectedformat))
            #self.dlg.label_print_size.setText(formaty[selectedformat][0])
            
            # wyświetlanie szerokości i wysokości
            str_h = 0
            str_w = 0
            if orientacja=='Landscape':
                #self.dlg.label_print_width.setText(str(formaty[selectedformat][2]))
                str_w = formaty[selectedformat][2]
                #self.dlg.label_print_height.setText(str(formaty[selectedformat][1]))
                str_h = formaty[selectedformat][1]
            if orientacja=='Portrait':
                #self.dlg.label_print_width.setText(str(formaty[selectedformat][1]))
                str_w = formaty[selectedformat][1]
                #self.dlg.label_print_height.setText(str(formaty[selectedformat][2]))
                str_h = formaty[selectedformat][2]
            
            # pobieram i wyświetlam CSR wybranej warstwy
            lyrCRS = selectedlayer.crs().authid()
            crs = 'crs='+lyrCRS
            #self.dlg.label_csr.setText(str(crs))
            
            # pobieram i wyświetlam ścieżkę wybranej warstwy
            #writePath = self.dlg.outputDir.filePath()
            writePath = QgsProject.instance().homePath() 
            #self.dlg.label_layer_path.setText(str(writePath))
            
            # pobieram i wyświetlam scale
            scale = self.dlg.spinBoxScale.value()
            #self.dlg.label_scale.setText(str(scale))
            
            # pobieram i wyświetlam marginesy
            left_margin = self.dlg.doubleSpinBoxLeftMargin.value()
            right_margin = self.dlg.doubleSpinBoxRightMargin.value()
            top_margin = self.dlg.doubleSpinBoxTopMargin.value()
            bottom_margin = self.dlg.doubleSpinBoxBottomMargin.value()
            
            #self.dlg.label_left_margin.setText(str(left_margin))
            #self.dlg.label_right_margin.setText(str(right_margin))
            #self.dlg.label_top_margin.setText(str(top_margin))
            #self.dlg.label_bottom_margin.setText(str(bottom_margin))
            
            # tworzę nazwę i ścieżkę pliku wynikowego BEZ TEGO DZIAŁA
            result_name = 'sekcje_'+formaty[selectedformat][0]+'_'+orientacja+'_'+lyrCRS+'_'+selectedlayername+'.gpkg'
            #self.dlg.label_result_name.setText(result_name)

        
            # tu zaczyna się skrypt
            features = layer.getFeatures()
        
            project = QgsProject().instance()
            crs = 'crs='+lyrCRS
            lyr = QgsVectorLayer('Polygon?{}'.format(crs), 'sekcje_'+selectedlayername,'memory')
            pr = lyr.dataProvider()
            
            # add fields
            pr.addAttributes([QgsField("fid",  QVariant.Int)])
            lyr.updateFields() # tell the vector layer to fetch changes from the provider

            map_h = str_h - top_margin - bottom_margin
            map_w = str_w - left_margin - right_margin
            sekcja_h = (map_h * scale) / 1000
            sekcja_w = (map_w * scale) / 1000
            sekcja_h_2 = sekcja_h/2
            sekcja_w_2 = sekcja_w/2
            for feature in features:
                geom = feature.geometry()
                # to działa jedynie na warstwie punktowej
                #geomSingleType = QgsWkbTypes.isSingleType(geom.wkbType())
                #x = geom.asPoint()
                #print(feature.id(),x[0]-sekcja_w_2,x[1]-sekcja_h_2,x[0]+sekcja_w_2,x[1]+sekcja_h_2)
                #rect = QgsRectangle(x[0]-sekcja_w_2,x[1]-sekcja_h_2,x[0]+sekcja_w_2,x[1]+sekcja_h_2)
                # Teraz będzie działać zarówno na warstwie punktowej jak i multipunktowej
                print(feature.id(),geom.asPoint().x()-sekcja_w_2,geom.asPoint().y()-sekcja_h_2,geom.asPoint().x()+sekcja_w_2,geom.asPoint().y()+sekcja_h_2)
                rect = QgsRectangle(geom.asPoint().x()-sekcja_w_2,geom.asPoint().y()-sekcja_h_2,geom.asPoint().x()+sekcja_w_2,geom.asPoint().y()+sekcja_h_2)
                geom = QgsGeometry().fromRect(rect)
            
                ftr = QgsFeature()
                ftr.setGeometry(geom)
                ftr.setAttributes([feature.id()])
                pr.addFeatures([ftr])
            
                project.addMapLayer(lyr)
            layer = iface.activeLayer()
            
            pass