/*
 * This script contains the language-specific data used by searchtools.js,
 * namely the set of stopwords, stemmer, scorer and splitter.
 */

const stopwords = new Set(["a", "ao", "aos", "aquela", "aquelas", "aquele", "aqueles", "aquilo", "as", "at\u00e9", "com", "como", "da", "das", "de", "dela", "delas", "dele", "deles", "depois", "do", "dos", "e", "ela", "elas", "ele", "eles", "em", "entre", "era", "eram", "essa", "essas", "esse", "esses", "esta", "estamos", "estas", "estava", "estavam", "este", "esteja", "estejam", "estejamos", "estes", "esteve", "estive", "estivemos", "estiver", "estivera", "estiveram", "estiverem", "estivermos", "estivesse", "estivessem", "estiv\u00e9ramos", "estiv\u00e9ssemos", "estou", "est\u00e1", "est\u00e1vamos", "est\u00e3o", "eu", "foi", "fomos", "for", "fora", "foram", "forem", "formos", "fosse", "fossem", "fui", "f\u00f4ramos", "f\u00f4ssemos", "haja", "hajam", "hajamos", "havemos", "hei", "houve", "houvemos", "houver", "houvera", "houveram", "houverei", "houverem", "houveremos", "houveria", "houveriam", "houvermos", "houver\u00e1", "houver\u00e3o", "houver\u00edamos", "houvesse", "houvessem", "houv\u00e9ramos", "houv\u00e9ssemos", "h\u00e1", "h\u00e3o", "isso", "isto", "j\u00e1", "lhe", "lhes", "mais", "mas", "me", "mesmo", "meu", "meus", "minha", "minhas", "muito", "na", "nas", "nem", "no", "nos", "nossa", "nossas", "nosso", "nossos", "num", "numa", "n\u00e3o", "n\u00f3s", "o", "os", "ou", "para", "pela", "pelas", "pelo", "pelos", "por", "qual", "quando", "que", "quem", "se", "seja", "sejam", "sejamos", "sem", "serei", "seremos", "seria", "seriam", "ser\u00e1", "ser\u00e3o", "ser\u00edamos", "seu", "seus", "somos", "sou", "sua", "suas", "s\u00e3o", "s\u00f3", "tamb\u00e9m", "te", "tem", "temos", "tenha", "tenham", "tenhamos", "tenho", "terei", "teremos", "teria", "teriam", "ter\u00e1", "ter\u00e3o", "ter\u00edamos", "teu", "teus", "teve", "tinha", "tinham", "tive", "tivemos", "tiver", "tivera", "tiveram", "tiverem", "tivermos", "tivesse", "tivessem", "tiv\u00e9ramos", "tiv\u00e9ssemos", "tu", "tua", "tuas", "t\u00e9m", "t\u00ednhamos", "um", "uma", "voc\u00ea", "voc\u00eas", "vos", "\u00e0", "\u00e0s", "\u00e9ramos"]);
window.stopwords = stopwords;  // Export to global scope


/* Non-minified versions are copied as separate JavaScript files, if available */
BaseStemmer=function(){this.current="",this.cursor=0,this.limit=0,this.limit_backward=0,this.bra=0,this.ket=0,this.setCurrent=function(t){this.current=t,this.cursor=0,this.limit=this.current.length,this.limit_backward=0,this.bra=this.cursor,this.ket=this.limit},this.getCurrent=function(){return this.current},this.copy_from=function(t){this.current=t.current,this.cursor=t.cursor,this.limit=t.limit,this.limit_backward=t.limit_backward,this.bra=t.bra,this.ket=t.ket},this.in_grouping=function(t,r,i){return!(this.cursor>=this.limit||i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor++,0))},this.go_in_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.in_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward||i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor--,0))},this.go_in_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.out_grouping=function(t,r,i){return!(this.cursor>=this.limit)&&(i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor++,!0)},this.go_out_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.out_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward)&&(i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor--,!0)},this.go_out_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.eq_s=function(t){return!(this.limit-this.cursor<t.length||this.current.slice(this.cursor,this.cursor+t.length)!=t||(this.cursor+=t.length,0))},this.eq_s_b=function(t){return!(this.cursor-this.limit_backward<t.length||this.current.slice(this.cursor-t.length,this.cursor)!=t||(this.cursor-=t.length,0))},this.find_among=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit,e=0,n=0,c=!1;;){for(var u=r+(i-r>>>1),o=0,a=e<n?e:n,l=t[u],f=a;f<l[0].length;f++){if(s+a==h){o=-1;break}if(0!=(o=this.current.charCodeAt(s+a)-l[0].charCodeAt(f)))break;a++}if(o<0?(i=u,n=a):(r=u,e=a),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(l=t[r])[0].length){if(this.cursor=s+l[0].length,l.length<4)return l[2];var g=l[3](this);if(this.cursor=s+l[0].length,g)return l[2]}}while(0<=(r=l[1]));return 0},this.find_among_b=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit_backward,e=0,n=0,c=!1;;){for(var u,o=r+(i-r>>1),a=0,l=e<n?e:n,f=(u=t[o])[0].length-1-l;0<=f;f--){if(s-l==h){a=-1;break}if(0!=(a=this.current.charCodeAt(s-1-l)-u[0].charCodeAt(f)))break;l++}if(a<0?(i=o,n=l):(r=o,e=l),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(u=t[r])[0].length){if(this.cursor=s-u[0].length,u.length<4)return u[2];var g=u[3](this);if(this.cursor=s-u[0].length,g)return u[2]}}while(0<=(r=u[1]));return 0},this.replace_s=function(t,r,i){var s=i.length-(r-t);return this.current=this.current.slice(0,t)+i+this.current.slice(r),this.limit+=s,this.cursor>=r?this.cursor+=s:this.cursor>t&&(this.cursor=t),s},this.slice_check=function(){return!(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length)},this.slice_from=function(t){var r=!1;return this.slice_check()&&(this.replace_s(this.bra,this.ket,t),r=!0),r},this.slice_del=function(){return this.slice_from("")},this.insert=function(t,r,i){r=this.replace_s(t,r,i);t<=this.bra&&(this.bra+=r),t<=this.ket&&(this.ket+=r)},this.slice_to=function(){var t="";return t=this.slice_check()?this.current.slice(this.bra,this.ket):t},this.assign_to=function(){return this.current.slice(0,this.limit)}};
var PortugueseStemmer=function(){var u=new BaseStemmer,c=[["",-1,3],["ã",0,1],["õ",0,2]],t=[["",-1,3],["a~",0,1],["o~",0,2]],e=[["ic",-1,-1],["ad",-1,-1],["os",-1,-1],["iv",-1,1]],o=[["ante",-1,1],["avel",-1,1],["ível",-1,1]],a=[["ic",-1,1],["abil",-1,1],["iv",-1,1]],m=[["ica",-1,1],["ância",-1,1],["ência",-1,4],["logia",-1,2],["ira",-1,9],["adora",-1,1],["osa",-1,1],["ista",-1,1],["iva",-1,8],["eza",-1,1],["idade",-1,7],["ante",-1,1],["mente",-1,6],["amente",12,5],["ável",-1,1],["ível",-1,1],["ico",-1,1],["ismo",-1,1],["oso",-1,1],["amento",-1,1],["imento",-1,1],["ivo",-1,8],["aça~o",-1,1],["uça~o",-1,3],["ador",-1,1],["icas",-1,1],["ências",-1,4],["logias",-1,2],["iras",-1,9],["adoras",-1,1],["osas",-1,1],["istas",-1,1],["ivas",-1,8],["ezas",-1,1],["idades",-1,7],["adores",-1,1],["antes",-1,1],["aço~es",-1,1],["uço~es",-1,3],["icos",-1,1],["ismos",-1,1],["osos",-1,1],["amentos",-1,1],["imentos",-1,1],["ivos",-1,8]],n=[["ada",-1,1],["ida",-1,1],["ia",-1,1],["aria",2,1],["eria",2,1],["iria",2,1],["ara",-1,1],["era",-1,1],["ira",-1,1],["ava",-1,1],["asse",-1,1],["esse",-1,1],["isse",-1,1],["aste",-1,1],["este",-1,1],["iste",-1,1],["ei",-1,1],["arei",16,1],["erei",16,1],["irei",16,1],["am",-1,1],["iam",20,1],["ariam",21,1],["eriam",21,1],["iriam",21,1],["aram",20,1],["eram",20,1],["iram",20,1],["avam",20,1],["em",-1,1],["arem",29,1],["erem",29,1],["irem",29,1],["assem",29,1],["essem",29,1],["issem",29,1],["ado",-1,1],["ido",-1,1],["ando",-1,1],["endo",-1,1],["indo",-1,1],["ara~o",-1,1],["era~o",-1,1],["ira~o",-1,1],["ar",-1,1],["er",-1,1],["ir",-1,1],["as",-1,1],["adas",47,1],["idas",47,1],["ias",47,1],["arias",50,1],["erias",50,1],["irias",50,1],["aras",47,1],["eras",47,1],["iras",47,1],["avas",47,1],["es",-1,1],["ardes",58,1],["erdes",58,1],["irdes",58,1],["ares",58,1],["eres",58,1],["ires",58,1],["asses",58,1],["esses",58,1],["isses",58,1],["astes",58,1],["estes",58,1],["istes",58,1],["is",-1,1],["ais",71,1],["eis",71,1],["areis",73,1],["ereis",73,1],["ireis",73,1],["áreis",73,1],["éreis",73,1],["íreis",73,1],["ásseis",73,1],["ésseis",73,1],["ísseis",73,1],["áveis",73,1],["íeis",73,1],["aríeis",84,1],["eríeis",84,1],["iríeis",84,1],["ados",-1,1],["idos",-1,1],["amos",-1,1],["áramos",90,1],["éramos",90,1],["íramos",90,1],["ávamos",90,1],["íamos",90,1],["aríamos",95,1],["eríamos",95,1],["iríamos",95,1],["emos",-1,1],["aremos",99,1],["eremos",99,1],["iremos",99,1],["ássemos",99,1],["êssemos",99,1],["íssemos",99,1],["imos",-1,1],["armos",-1,1],["ermos",-1,1],["irmos",-1,1],["ámos",-1,1],["arás",-1,1],["erás",-1,1],["irás",-1,1],["eu",-1,1],["iu",-1,1],["ou",-1,1],["ará",-1,1],["erá",-1,1],["irá",-1,1]],l=[["a",-1,1],["i",-1,1],["o",-1,1],["os",-1,1],["á",-1,1],["í",-1,1],["ó",-1,1]],f=[["e",-1,1],["ç",-1,2],["é",-1,1],["ê",-1,1]],_=[17,65,16,0,0,0,0,0,0,0,0,0,0,0,0,0,3,19,12,2],b=0,d=0,k=0;function g(){return k<=u.cursor}function v(){return b<=u.cursor}function p(){var r;if(u.ket=u.cursor,0!=(r=u.find_among_b(m))){switch(u.bra=u.cursor,r){case 1:if(!v())return;if(u.slice_del())break;return;case 2:if(!v())return;if(u.slice_from("log"))break;return;case 3:if(!v())return;if(u.slice_from("u"))break;return;case 4:if(!v())return;if(u.slice_from("ente"))break;return;case 5:if(!(d<=u.cursor))return;if(!u.slice_del())return;var i=u.limit-u.cursor;r:if(u.ket=u.cursor,0==(r=u.find_among_b(e)))u.cursor=u.limit-i;else if(u.bra=u.cursor,v()){if(!u.slice_del())return;switch(r){case 1:if(u.ket=u.cursor,!u.eq_s_b("at")){u.cursor=u.limit-i;break r}if(u.bra=u.cursor,!v()){u.cursor=u.limit-i;break r}if(u.slice_del())break;return}}else u.cursor=u.limit-i;break;case 6:if(!v())return;if(!u.slice_del())return;var s=u.limit-u.cursor;if(u.ket=u.cursor,0==u.find_among_b(o))u.cursor=u.limit-s;else if(u.bra=u.cursor,v()){if(!u.slice_del())return}else u.cursor=u.limit-s;break;case 7:if(!v())return;if(!u.slice_del())return;s=u.limit-u.cursor;if(u.ket=u.cursor,0==u.find_among_b(a))u.cursor=u.limit-s;else if(u.bra=u.cursor,v()){if(!u.slice_del())return}else u.cursor=u.limit-s;break;case 8:if(!v())return;if(!u.slice_del())return;s=u.limit-u.cursor;if(u.ket=u.cursor,u.eq_s_b("at"))if(u.bra=u.cursor,v()){if(!u.slice_del())return}else u.cursor=u.limit-s;else u.cursor=u.limit-s;break;case 9:if(!g())return;if(!u.eq_s_b("e"))return;if(u.slice_from("ir"))break;return}return 1}}this.stem=function(){var r=u.cursor,r=((()=>{for(var r;;){var i=u.cursor;r:{switch(u.bra=u.cursor,r=u.find_among(c),u.ket=u.cursor,r){case 1:if(u.slice_from("a~"))break;return;case 2:if(u.slice_from("o~"))break;return;case 3:if(u.cursor>=u.limit)break r;u.cursor++}continue}u.cursor=i;break}})(),u.cursor=r,k=u.limit,d=u.limit,b=u.limit,u.cursor);r:{i:{var i=u.cursor;s:if(u.in_grouping(_,97,250)){var s=u.cursor;if(!u.out_grouping(_,97,250)||!u.go_out_grouping(_,97,250)){if(u.cursor=s,!u.in_grouping(_,97,250))break s;if(!u.go_in_grouping(_,97,250))break s}u.cursor++;break i}if(u.cursor=i,!u.out_grouping(_,97,250))break r;s=u.cursor;if(u.out_grouping(_,97,250)&&u.go_out_grouping(_,97,250));else{if(u.cursor=s,!u.in_grouping(_,97,250))break r;if(u.cursor>=u.limit)break r}u.cursor++}k=u.cursor}u.cursor=r,r=u.cursor,u.go_out_grouping(_,97,250)&&(u.cursor++,u.go_in_grouping(_,97,250))&&(u.cursor++,d=u.cursor,u.go_out_grouping(_,97,250))&&(u.cursor++,u.go_in_grouping(_,97,250))&&(u.cursor++,b=u.cursor),u.cursor=r,u.limit_backward=u.cursor,u.cursor=u.limit;r=u.limit-u.cursor;r:{var e=u.limit-u.cursor,o=u.limit-u.cursor,a=u.limit-u.cursor;if(p()||(u.cursor=u.limit-a,(()=>{if(!(u.cursor<k)){var r=u.limit_backward;if(u.limit_backward=k,u.ket=u.cursor,0!=u.find_among_b(n))return u.bra=u.cursor,u.slice_del()&&(u.limit_backward=r,1);u.limit_backward=r}})())){u.cursor=u.limit-o;a=u.limit-u.cursor;if(u.ket=u.cursor,u.eq_s_b("i")){u.bra=u.cursor;o=u.limit-u.cursor;if(u.eq_s_b("c")&&(u.cursor=u.limit-o,g())&&!u.slice_del())return!1}u.cursor=u.limit-a}else if(u.cursor=u.limit-e,u.ket=u.cursor,0==u.find_among_b(l)||(u.bra=u.cursor,!g())||!u.slice_del())break r}u.cursor=u.limit-r;r=u.limit-u.cursor,(()=>{var r;if(u.ket=u.cursor,0!=(r=u.find_among_b(f)))switch(u.bra=u.cursor,r){case 1:if(!g())return;if(!u.slice_del())return;u.ket=u.cursor;r:{var i=u.limit-u.cursor;if(u.eq_s_b("u")){u.bra=u.cursor;var s=u.limit-u.cursor;if(u.eq_s_b("g")){u.cursor=u.limit-s;break r}}if(u.cursor=u.limit-i,!u.eq_s_b("i"))return;u.bra=u.cursor;s=u.limit-u.cursor;if(!u.eq_s_b("c"))return;u.cursor=u.limit-s}if(!g())return;if(u.slice_del())break;return;case 2:if(u.slice_from("c"))break}})(),u.cursor=u.limit-r,u.cursor=u.limit_backward,r=u.cursor;return(()=>{for(var r;;){var i=u.cursor;r:{switch(u.bra=u.cursor,r=u.find_among(t),u.ket=u.cursor,r){case 1:if(u.slice_from("ã"))break;return;case 2:if(u.slice_from("õ"))break;return;case 3:if(u.cursor>=u.limit)break r;u.cursor++}continue}u.cursor=i;break}})(),u.cursor=r,!0},this.stemWord=function(r){return u.setCurrent(r),this.stem(),u.getCurrent()}};
window.Stemmer = PortugueseStemmer;
