/*
 * This script contains the language-specific data used by searchtools.js,
 * namely the set of stopwords, stemmer, scorer and splitter.
 */

const stopwords = new Set(["aan", "al", "alles", "als", "altijd", "andere", "ben", "bij", "daar", "dan", "dat", "de", "der", "deze", "die", "dit", "doch", "doen", "door", "dus", "een", "eens", "en", "er", "ge", "geen", "geweest", "haar", "had", "heb", "hebben", "heeft", "hem", "het", "hier", "hij", "hoe", "hun", "iemand", "iets", "ik", "in", "is", "ja", "je", "kan", "kon", "kunnen", "maar", "me", "meer", "men", "met", "mij", "mijn", "moet", "na", "naar", "niet", "niets", "nog", "nu", "of", "om", "omdat", "onder", "ons", "ook", "op", "over", "reeds", "te", "tegen", "toch", "toen", "tot", "u", "uit", "uw", "van", "veel", "voor", "want", "waren", "was", "wat", "werd", "wezen", "wie", "wil", "worden", "wordt", "zal", "ze", "zelf", "zich", "zij", "zijn", "zo", "zonder", "zou"]);
window.stopwords = stopwords;  // Export to global scope


/* Non-minified versions are copied as separate JavaScript files, if available */
BaseStemmer=function(){this.current="",this.cursor=0,this.limit=0,this.limit_backward=0,this.bra=0,this.ket=0,this.setCurrent=function(t){this.current=t,this.cursor=0,this.limit=this.current.length,this.limit_backward=0,this.bra=this.cursor,this.ket=this.limit},this.getCurrent=function(){return this.current},this.copy_from=function(t){this.current=t.current,this.cursor=t.cursor,this.limit=t.limit,this.limit_backward=t.limit_backward,this.bra=t.bra,this.ket=t.ket},this.in_grouping=function(t,r,i){return!(this.cursor>=this.limit||i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor++,0))},this.go_in_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.in_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward||i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor--,0))},this.go_in_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.out_grouping=function(t,r,i){return!(this.cursor>=this.limit)&&(i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor++,!0)},this.go_out_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.out_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward)&&(i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor--,!0)},this.go_out_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.eq_s=function(t){return!(this.limit-this.cursor<t.length||this.current.slice(this.cursor,this.cursor+t.length)!=t||(this.cursor+=t.length,0))},this.eq_s_b=function(t){return!(this.cursor-this.limit_backward<t.length||this.current.slice(this.cursor-t.length,this.cursor)!=t||(this.cursor-=t.length,0))},this.find_among=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit,e=0,n=0,c=!1;;){for(var u=r+(i-r>>>1),o=0,a=e<n?e:n,l=t[u],f=a;f<l[0].length;f++){if(s+a==h){o=-1;break}if(0!=(o=this.current.charCodeAt(s+a)-l[0].charCodeAt(f)))break;a++}if(o<0?(i=u,n=a):(r=u,e=a),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(l=t[r])[0].length){if(this.cursor=s+l[0].length,l.length<4)return l[2];var g=l[3](this);if(this.cursor=s+l[0].length,g)return l[2]}}while(0<=(r=l[1]));return 0},this.find_among_b=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit_backward,e=0,n=0,c=!1;;){for(var u,o=r+(i-r>>1),a=0,l=e<n?e:n,f=(u=t[o])[0].length-1-l;0<=f;f--){if(s-l==h){a=-1;break}if(0!=(a=this.current.charCodeAt(s-1-l)-u[0].charCodeAt(f)))break;l++}if(a<0?(i=o,n=l):(r=o,e=l),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(u=t[r])[0].length){if(this.cursor=s-u[0].length,u.length<4)return u[2];var g=u[3](this);if(this.cursor=s-u[0].length,g)return u[2]}}while(0<=(r=u[1]));return 0},this.replace_s=function(t,r,i){var s=i.length-(r-t);return this.current=this.current.slice(0,t)+i+this.current.slice(r),this.limit+=s,this.cursor>=r?this.cursor+=s:this.cursor>t&&(this.cursor=t),s},this.slice_check=function(){return!(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length)},this.slice_from=function(t){var r=!1;return this.slice_check()&&(this.replace_s(this.bra,this.ket,t),r=!0),r},this.slice_del=function(){return this.slice_from("")},this.insert=function(t,r,i){r=this.replace_s(t,r,i);t<=this.bra&&(this.bra+=r),t<=this.ket&&(this.ket+=r)},this.slice_to=function(){var t="";return t=this.slice_check()?this.current.slice(this.bra,this.ket):t},this.assign_to=function(){return this.current.slice(0,this.limit)}};
var DutchStemmer=function(){var o=new BaseStemmer,a=[["a",-1,1],["e",-1,2],["o",-1,1],["u",-1,1],["à",-1,1],["á",-1,1],["â",-1,1],["ä",-1,1],["è",-1,2],["é",-1,2],["ê",-1,2],["eë",-1,3],["ië",-1,4],["ò",-1,1],["ó",-1,1],["ô",-1,1],["ö",-1,1],["ù",-1,1],["ú",-1,1],["û",-1,1],["ü",-1,1]],t=[["nde",-1,8],["en",-1,7],["s",-1,2],["'s",2,1],["es",2,4],["ies",4,3],["aus",2,6],["és",2,5]],e=[["de",-1,5],["ge",-1,2],["ische",-1,4],["je",-1,1],["lijke",-1,3],["le",-1,9],["ene",-1,10],["re",-1,8],["se",-1,7],["te",-1,6],["ieve",-1,11]],s=[["heid",-1,3],["fie",-1,7],["gie",-1,8],["atie",-1,1],["isme",-1,5],["ing",-1,5],["arij",-1,6],["erij",-1,5],["sel",-1,3],["rder",-1,4],["ster",-1,3],["iteit",-1,2],["dst",-1,10],["tst",-1,9]],c=[["end",-1,9],["atief",-1,2],["erig",-1,9],["achtig",-1,3],["ioneel",-1,1],["baar",-1,3],["laar",-1,5],["naar",-1,4],["raar",-1,6],["eriger",-1,9],["achtiger",-1,3],["lijker",-1,8],["tant",-1,7],["erigst",-1,9],["achtigst",-1,3],["lijkst",-1,8]],u=[["ig",-1,1],["iger",-1,1],["igst",-1,1]],f=[["ft",-1,2],["kt",-1,1],["pt",-1,3]],n=[["bb",-1,1],["cc",-1,2],["dd",-1,3],["ff",-1,4],["gg",-1,5],["hh",-1,6],["jj",-1,7],["kk",-1,8],["ll",-1,9],["mm",-1,10],["nn",-1,11],["pp",-1,12],["qq",-1,13],["rr",-1,14],["ss",-1,15],["tt",-1,16],["v",-1,4],["vv",16,17],["ww",-1,18],["xx",-1,19],["z",-1,15],["zz",20,20]],l=[["d",-1,1],["t",-1,2]],_=[["",-1,-1],["eft",0,1],["vaa",0,1],["val",0,1],["vali",3,-1],["vare",0,1]],m=[["ë",-1,1],["ï",-1,2]],b=[["ë",-1,1],["ï",-1,2]],k=[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120],d=[1,65,16,0,0,0,0,0,0,0,0,0,0,0,0,128,11,120,46,15],g=[17,65,16,0,0,0,0,0,0,0,0,0,0,0,0,128,139,127,46,15],v=[17,65,16,1,0,0,0,0,0,0,0,0,0,0,0,128,139,127,46,15],q=[17,65,208,1,0,0,0,0,0,0,0,0,0,0,0,128,139,127,46,15],w=!1,h=!1,p=0,j=0,z="";function x(){return j<=o.cursor}function C(){return p<=o.cursor}function S(){var r=o.limit-o.cursor,i=o.limit-o.cursor;return(o.in_grouping_b(v,97,252)||(o.cursor=o.limit-i,o.eq_s_b("ij")))&&(o.cursor=o.limit-r,1)}function B(){var r=o.limit-o.cursor,i=o.limit-o.cursor;return!o.eq_s_b("ij")&&(o.cursor=o.limit-i,o.out_grouping_b(v,97,252))&&(o.cursor=o.limit-r,1)}function D(){var r,i=o.limit-o.cursor;r:if(o.out_grouping_b(q,97,252)&&(o.ket=o.cursor,0!=(r=o.find_among_b(a))))switch(o.bra=o.cursor,r){case 1:var e=o.limit-o.cursor,s=o.limit-o.cursor;if(o.out_grouping_b(g,97,252)||(o.cursor=o.limit-s,!(o.cursor>o.limit_backward))){if(o.cursor=o.limit-e,""==(z=o.slice_to()))return;s=o.cursor;o.insert(o.cursor,o.cursor,z),o.cursor=s}break;case 2:var c=o.limit-o.cursor,e=o.limit-o.cursor;if(o.out_grouping_b(g,97,252)||(o.cursor=o.limit-e,!(o.cursor>o.limit_backward))){var u=o.limit-o.cursor;i:{var t=o.limit-o.cursor;if(!o.in_grouping_b(d,97,252)){if(o.cursor=o.limit-t,!o.in_grouping_b(k,101,235))break i;if(o.cursor>o.limit_backward)break i}break r}o.cursor=o.limit-u;t=o.limit-o.cursor;if(o.cursor<=o.limit_backward||(o.cursor--,!o.in_grouping_b(d,97,252))||!o.out_grouping_b(g,97,252)){if(o.cursor=o.limit-t,o.cursor=o.limit-c,""==(z=o.slice_to()))return;t=o.cursor;o.insert(o.cursor,o.cursor,z),o.cursor=t}}break;case 3:if(o.slice_from("eëe"))break;return;case 4:if(o.slice_from("iee"))break;return}o.cursor=o.limit-i}function W(){var r;if(o.ket=o.cursor,0!=(r=o.find_among_b(e))){switch(o.bra=o.cursor,r){case 1:r:{var i=o.limit-o.cursor;if(o.eq_s_b("'t")){if(o.bra=o.cursor,o.slice_del())break r;return}if(o.cursor=o.limit-i,o.eq_s_b("et")&&(o.bra=o.cursor,x())&&B()){if(o.slice_del())break r;return}if(o.cursor=o.limit-i,o.eq_s_b("rnt")){if(o.bra=o.cursor,o.slice_from("rn"))break r;return}if(o.cursor=o.limit-i,o.eq_s_b("t")&&(o.bra=o.cursor,x())&&(()=>{var r,i=o.limit-o.cursor;return!(o.cursor<=o.limit_backward)&&(o.cursor--,r=o.limit-o.cursor,o.in_grouping_b(v,97,252)||(o.cursor=o.limit-r,o.eq_s_b("ij")))?(o.cursor=o.limit-i,1):void 0})()){if(o.slice_del())break r;return}if(o.cursor=o.limit-i,o.eq_s_b("ink")){if(o.bra=o.cursor,o.slice_from("ing"))break r;return}if(o.cursor=o.limit-i,o.eq_s_b("mp")){if(o.bra=o.cursor,o.slice_from("m"))break r;return}if(o.cursor=o.limit-i,o.eq_s_b("'")&&(o.bra=o.cursor,x())){if(o.slice_del())break r;return}if(o.cursor=o.limit-i,o.bra=o.cursor,!x())return;if(!B())return;if(!o.slice_del())return}break;case 2:if(!x())return;if(o.slice_from("g"))break;return;case 3:if(!x())return;if(o.slice_from("lijk"))break;return;case 4:if(!x())return;if(o.slice_from("isch"))break;return;case 5:if(!x())return;if(!B())return;if(o.slice_del())break;return;case 6:if(!x())return;if(o.slice_from("t"))break;return;case 7:if(!x())return;if(o.slice_from("s"))break;return;case 8:if(!x())return;if(o.slice_from("r"))break;return;case 9:if(!x())return;if(!o.slice_del())return;o.insert(o.cursor,o.cursor,"l"),D();break;case 10:if(!x())return;if(!B())return;if(!o.slice_del())return;o.insert(o.cursor,o.cursor,"en"),D();break;case 11:if(!x())return;if(!B())return;if(o.slice_from("ief"))break;return}return 1}}function y(){var r;if(o.ket=o.cursor,0!=(r=o.find_among_b(l))&&(o.bra=o.cursor,x())&&B()){switch(r){case 1:var i=o.limit-o.cursor;if(o.eq_s_b("n")&&x())return;o.cursor=o.limit-i;r:{var e=o.limit-o.cursor;if(o.eq_s_b("in")&&!(o.cursor>o.limit_backward)){if(o.slice_from("n"))break r;return}if(o.cursor=o.limit-e,!o.slice_del())return}break;case 2:i=o.limit-o.cursor;if(o.eq_s_b("h")&&x())return;o.cursor=o.limit-i;i=o.limit-o.cursor;if(o.eq_s_b("en")&&!(o.cursor>o.limit_backward))return;if(o.cursor=o.limit-i,o.slice_del())break;return}return 1}}function A(){j=o.limit,p=o.limit;for(var r=o.cursor;o.out_grouping(v,97,252););for(var i=1;;){var e=o.cursor,s=o.cursor;if(!o.eq_s("ij")&&(o.cursor=s,!o.in_grouping(v,97,252))){o.cursor=e;break}i--}if(!(0<i)&&o.out_grouping(v,97,252)){for(j=o.cursor;;)if(!o.out_grouping(v,97,252))break;for(var c=1;;){var u=o.cursor,t=o.cursor;if(!o.eq_s("ij")&&(o.cursor=t,!o.in_grouping(v,97,252))){o.cursor=u;break}c--}0<c||o.out_grouping(v,97,252)&&(p=o.cursor)}o.cursor=r}this.stem=function(){h=!1,A(),o.limit_backward=o.cursor,o.cursor=o.limit;var r=o.limit-o.cursor,r=((()=>{var r;if(o.ket=o.cursor,0!=(r=o.find_among_b(t))){switch(o.bra=o.cursor,r){case 1:if(o.slice_del())break;return;case 2:if(!x())return;var i=o.limit-o.cursor;if(o.eq_s_b("t")&&x())return;if(o.cursor=o.limit-i,!B())return;if(o.slice_del())break;return;case 3:if(!x())return;if(o.slice_from("ie"))break;return;case 4:r:{var e=o.limit-o.cursor,s=o.limit-o.cursor;if(o.eq_s_b("ar")&&x()&&B()){if(o.cursor=o.limit-s,!o.slice_del())return;D()}else{o.cursor=o.limit-e;s=o.limit-o.cursor;if(o.eq_s_b("er")&&x()&&B()){if(o.cursor=o.limit-s,o.slice_del())break r;return}if(o.cursor=o.limit-e,!x())return;if(!B())return;if(!o.slice_from("e"))return}}break;case 5:if(!x())return;if(o.slice_from("é"))break;return;case 6:if(!x())return;if(!S())return;if(o.slice_from("au"))break;return;case 7:r:{var c=o.limit-o.cursor;if(o.eq_s_b("hed")&&x()){if(o.bra=o.cursor,o.slice_from("heid"))break r;return}if(o.cursor=o.limit-c,o.eq_s_b("nd")){if(o.slice_del())break r;return}if(o.cursor=o.limit-c,o.eq_s_b("d")&&x()&&B()){if(o.bra=o.cursor,o.slice_del())break r;return}o.cursor=o.limit-c;var u=o.limit-o.cursor;if((o.eq_s_b("i")||(o.cursor=o.limit-u,o.eq_s_b("j")))&&S()){if(o.slice_del())break r;return}if(o.cursor=o.limit-c,!x())return;if(!B())return;if(!o.slice_del())return;D()}break;case 8:if(o.slice_from("nd"))break;return}return 1}})()&&(h=!0),o.cursor=o.limit-r,o.limit-o.cursor),r=(W()&&(h=!0),o.cursor=o.limit-r,o.limit-o.cursor),r=((()=>{var r;if(o.ket=o.cursor,0!=(r=o.find_among_b(s))){switch(o.bra=o.cursor,r){case 1:if(!x())return;if(o.slice_from("eer"))break;return;case 2:if(!x())return;if(!o.slice_del())return;D();break;case 3:if(!x())return;if(o.slice_del())break;return;case 4:if(o.slice_from("r"))break;return;case 5:r:{var i=o.limit-o.cursor;if(o.eq_s_b("ild")){if(o.slice_from("er"))break r;return}if(o.cursor=o.limit-i,!x())return;if(!o.slice_del())return;D()}break;case 6:if(!x())return;if(!B())return;if(o.slice_from("aar"))break;return;case 7:if(!C())return;if(!o.slice_del())return;o.insert(o.cursor,o.cursor,"f"),D();break;case 8:if(!C())return;if(!o.slice_del())return;o.insert(o.cursor,o.cursor,"g"),D();break;case 9:if(!x())return;if(!B())return;if(o.slice_from("t"))break;return;case 10:if(!x())return;if(!B())return;if(o.slice_from("d"))break;return}return 1}})()&&(h=!0),o.cursor=o.limit-r,o.limit-o.cursor),r=((()=>{r:{var r=o.limit-o.cursor;i:if(o.ket=o.cursor,0!=(i=o.find_among_b(c))){switch(o.bra=o.cursor,i){case 1:if(!x())break i;if(o.slice_from("ie"))break;return;case 2:if(!x())break i;if(o.slice_from("eer"))break;return;case 3:if(!x())break i;if(o.slice_del())break;return;case 4:if(!x())break i;if(!S())break i;if(o.slice_from("n"))break;return;case 5:if(!x())break i;if(!S())break i;if(o.slice_from("l"))break;return;case 6:if(!x())break i;if(!S())break i;if(o.slice_from("r"))break;return;case 7:if(!x())break i;if(o.slice_from("teer"))break;return;case 8:if(!x())break i;if(o.slice_from("lijk"))break;return;case 9:if(!x())break i;if(!B())break i;if(!o.slice_del())return;D()}break r}if(o.cursor=o.limit-r,o.ket=o.cursor,0==o.find_among_b(u))return;if(o.bra=o.cursor,!x())return;var i=o.limit-o.cursor;if(o.eq_s_b("inn")&&!(o.cursor>o.limit_backward))return;if(o.cursor=o.limit-i,!B())return;if(!o.slice_del())return;D()}return 1})()&&(h=!0),o.cursor=o.limit-r,o.cursor=o.limit_backward,w=!1,o.cursor),i=o.cursor,i=((()=>{if(o.bra=o.cursor,o.eq_s("ge")){o.ket=o.cursor;var r=o.cursor,i=o.cursor+3;if(!(i>o.limit)){o.cursor=i,o.cursor=r;for(var i=o.cursor;;){var e=o.cursor,s=o.cursor;if(o.eq_s("ij")||(o.cursor=s,o.in_grouping(v,97,252)))break;if(o.cursor=e,o.cursor>=o.limit)return;o.cursor++}for(;;){var c=o.cursor,u=o.cursor;if(!o.eq_s("ij")&&(o.cursor=u,!o.in_grouping(v,97,252))){o.cursor=c;break}}if(o.cursor<o.limit&&(o.cursor=i,1!==o.find_among(_))&&(w=!0,o.slice_del())){r=o.cursor;if(o.bra=o.cursor,0!=(i=o.find_among(m)))switch(o.ket=o.cursor,i){case 1:if(o.slice_from("e"))break;return;case 2:if(o.slice_from("i"))break;return}return o.cursor=r,1}}}})()&&(o.cursor=i,A()),o.cursor=r,o.limit_backward=o.cursor,o.cursor=o.limit,o.limit-o.cursor),r=(w&&(h=!0,y()),o.cursor=o.limit-i,o.cursor=o.limit_backward,w=!1,o.cursor),i=o.cursor,i=((()=>{if(!(o.cursor>=o.limit)){for(o.cursor++;;){if(o.bra=o.cursor,o.eq_s("ge")){o.ket=o.cursor;break}if(o.cursor>=o.limit)return;o.cursor++}var r=o.cursor,i=o.cursor+3;if(!(i>o.limit)){o.cursor=i,o.cursor=r;for(var i=o.cursor;;){var e=o.cursor,s=o.cursor;if(o.eq_s("ij")||(o.cursor=s,o.in_grouping(v,97,252)))break;if(o.cursor=e,o.cursor>=o.limit)return;o.cursor++}for(;;){var c=o.cursor,u=o.cursor;if(!o.eq_s("ij")&&(o.cursor=u,!o.in_grouping(v,97,252))){o.cursor=c;break}}if(o.cursor<o.limit&&(o.cursor=i,w=!0,o.slice_del())){r=o.cursor;if(o.bra=o.cursor,0!=(i=o.find_among(b)))switch(o.ket=o.cursor,i){case 1:if(o.slice_from("e"))break;return;case 2:if(o.slice_from("i"))break;return}return o.cursor=r,1}}}})()&&(o.cursor=i,A()),o.cursor=r,o.limit_backward=o.cursor,o.cursor=o.limit,o.limit-o.cursor),r=(w&&(h=!0,y()),o.cursor=o.limit-i,o.cursor=o.limit_backward,o.limit_backward=o.cursor,o.cursor=o.limit,o.limit-o.cursor),i=((()=>{var r;if(o.ket=o.cursor,0!=(r=o.find_among_b(f))){switch(o.bra=o.cursor,r){case 1:if(o.slice_from("k"))break;return;case 2:if(o.slice_from("f"))break;return;case 3:if(o.slice_from("p"))break;return}return 1}})()&&(h=!0),o.cursor=o.limit-r,o.limit-o.cursor);return h&&(()=>{var r;if(o.ket=o.cursor,0!=(r=o.find_among_b(n))){switch(o.bra=o.cursor,r){case 1:if(o.slice_from("b"))break;return;case 2:if(o.slice_from("c"))break;return;case 3:if(o.slice_from("d"))break;return;case 4:if(o.slice_from("f"))break;return;case 5:if(o.slice_from("g"))break;return;case 6:if(o.slice_from("h"))break;return;case 7:if(o.slice_from("j"))break;return;case 8:if(o.slice_from("k"))break;return;case 9:if(o.slice_from("l"))break;return;case 10:if(o.slice_from("m"))break;return;case 11:var i=o.limit-o.cursor;if(o.eq_s_b("i")&&!(o.cursor>o.limit_backward))return;if(o.cursor=o.limit-i,o.slice_from("n"))break;return;case 12:if(o.slice_from("p"))break;return;case 13:if(o.slice_from("q"))break;return;case 14:if(o.slice_from("r"))break;return;case 15:if(o.slice_from("s"))break;return;case 16:if(o.slice_from("t"))break;return;case 17:if(o.slice_from("v"))break;return;case 18:if(o.slice_from("w"))break;return;case 19:if(o.slice_from("x"))break;return;case 20:if(o.slice_from("z"))break;return}}})(),o.cursor=o.limit-i,o.cursor=o.limit_backward,!0},this.stemWord=function(r){return o.setCurrent(r),this.stem(),o.getCurrent()}};
window.Stemmer = DutchStemmer;
