/*
 * This script contains the language-specific data used by searchtools.js,
 * namely the set of stopwords, stemmer, scorer and splitter.
 */

const stopwords = new Set(["ei", "eiv\u00e4t", "emme", "en", "et", "ette", "ett\u00e4", "he", "heid\u00e4n", "heid\u00e4t", "heihin", "heille", "heill\u00e4", "heilt\u00e4", "heiss\u00e4", "heist\u00e4", "heit\u00e4", "h\u00e4n", "h\u00e4neen", "h\u00e4nelle", "h\u00e4nell\u00e4", "h\u00e4nelt\u00e4", "h\u00e4nen", "h\u00e4ness\u00e4", "h\u00e4nest\u00e4", "h\u00e4net", "h\u00e4nt\u00e4", "itse", "ja", "johon", "joiden", "joihin", "joiksi", "joilla", "joille", "joilta", "joina", "joissa", "joista", "joita", "joka", "joksi", "jolla", "jolle", "jolta", "jona", "jonka", "jos", "jossa", "josta", "jota", "jotka", "kanssa", "keiden", "keihin", "keiksi", "keille", "keill\u00e4", "keilt\u00e4", "kein\u00e4", "keiss\u00e4", "keist\u00e4", "keit\u00e4", "keneen", "keneksi", "kenelle", "kenell\u00e4", "kenelt\u00e4", "kenen", "kenen\u00e4", "keness\u00e4", "kenest\u00e4", "kenet", "ketk\u00e4", "ket\u00e4", "koska", "kuin", "kuka", "kun", "me", "meid\u00e4n", "meid\u00e4t", "meihin", "meille", "meill\u00e4", "meilt\u00e4", "meiss\u00e4", "meist\u00e4", "meit\u00e4", "mihin", "miksi", "mik\u00e4", "mille", "mill\u00e4", "milt\u00e4", "mink\u00e4", "minua", "minulla", "minulle", "minulta", "minun", "minussa", "minusta", "minut", "minuun", "min\u00e4", "miss\u00e4", "mist\u00e4", "mitk\u00e4", "mit\u00e4", "mukaan", "mutta", "ne", "niiden", "niihin", "niiksi", "niille", "niill\u00e4", "niilt\u00e4", "niin", "niin\u00e4", "niiss\u00e4", "niist\u00e4", "niit\u00e4", "noiden", "noihin", "noiksi", "noilla", "noille", "noilta", "noin", "noina", "noissa", "noista", "noita", "nuo", "nyt", "n\u00e4iden", "n\u00e4ihin", "n\u00e4iksi", "n\u00e4ille", "n\u00e4ill\u00e4", "n\u00e4ilt\u00e4", "n\u00e4in\u00e4", "n\u00e4iss\u00e4", "n\u00e4ist\u00e4", "n\u00e4it\u00e4", "n\u00e4m\u00e4", "ole", "olemme", "olen", "olet", "olette", "oli", "olimme", "olin", "olisi", "olisimme", "olisin", "olisit", "olisitte", "olisivat", "olit", "olitte", "olivat", "olla", "olleet", "ollut", "on", "ovat", "poikki", "se", "sek\u00e4", "sen", "siihen", "siin\u00e4", "siit\u00e4", "siksi", "sille", "sill\u00e4", "silt\u00e4", "sinua", "sinulla", "sinulle", "sinulta", "sinun", "sinussa", "sinusta", "sinut", "sinuun", "sin\u00e4", "sit\u00e4", "tai", "te", "teid\u00e4n", "teid\u00e4t", "teihin", "teille", "teill\u00e4", "teilt\u00e4", "teiss\u00e4", "teist\u00e4", "teit\u00e4", "tuo", "tuohon", "tuoksi", "tuolla", "tuolle", "tuolta", "tuon", "tuona", "tuossa", "tuosta", "tuota", "t\u00e4h\u00e4n", "t\u00e4ksi", "t\u00e4lle", "t\u00e4ll\u00e4", "t\u00e4lt\u00e4", "t\u00e4m\u00e4", "t\u00e4m\u00e4n", "t\u00e4n\u00e4", "t\u00e4ss\u00e4", "t\u00e4st\u00e4", "t\u00e4t\u00e4", "vaan", "vai", "vaikka", "yli"]);
window.stopwords = stopwords;  // Export to global scope


/* Non-minified versions are copied as separate JavaScript files, if available */
BaseStemmer=function(){this.current="",this.cursor=0,this.limit=0,this.limit_backward=0,this.bra=0,this.ket=0,this.setCurrent=function(t){this.current=t,this.cursor=0,this.limit=this.current.length,this.limit_backward=0,this.bra=this.cursor,this.ket=this.limit},this.getCurrent=function(){return this.current},this.copy_from=function(t){this.current=t.current,this.cursor=t.cursor,this.limit=t.limit,this.limit_backward=t.limit_backward,this.bra=t.bra,this.ket=t.ket},this.in_grouping=function(t,r,i){return!(this.cursor>=this.limit||i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor++,0))},this.go_in_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.in_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward||i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor--,0))},this.go_in_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.out_grouping=function(t,r,i){return!(this.cursor>=this.limit)&&(i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor++,!0)},this.go_out_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.out_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward)&&(i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor--,!0)},this.go_out_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.eq_s=function(t){return!(this.limit-this.cursor<t.length||this.current.slice(this.cursor,this.cursor+t.length)!=t||(this.cursor+=t.length,0))},this.eq_s_b=function(t){return!(this.cursor-this.limit_backward<t.length||this.current.slice(this.cursor-t.length,this.cursor)!=t||(this.cursor-=t.length,0))},this.find_among=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit,e=0,n=0,c=!1;;){for(var u=r+(i-r>>>1),o=0,a=e<n?e:n,l=t[u],f=a;f<l[0].length;f++){if(s+a==h){o=-1;break}if(0!=(o=this.current.charCodeAt(s+a)-l[0].charCodeAt(f)))break;a++}if(o<0?(i=u,n=a):(r=u,e=a),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(l=t[r])[0].length){if(this.cursor=s+l[0].length,l.length<4)return l[2];var g=l[3](this);if(this.cursor=s+l[0].length,g)return l[2]}}while(0<=(r=l[1]));return 0},this.find_among_b=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit_backward,e=0,n=0,c=!1;;){for(var u,o=r+(i-r>>1),a=0,l=e<n?e:n,f=(u=t[o])[0].length-1-l;0<=f;f--){if(s-l==h){a=-1;break}if(0!=(a=this.current.charCodeAt(s-1-l)-u[0].charCodeAt(f)))break;l++}if(a<0?(i=o,n=l):(r=o,e=l),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(u=t[r])[0].length){if(this.cursor=s-u[0].length,u.length<4)return u[2];var g=u[3](this);if(this.cursor=s-u[0].length,g)return u[2]}}while(0<=(r=u[1]));return 0},this.replace_s=function(t,r,i){var s=i.length-(r-t);return this.current=this.current.slice(0,t)+i+this.current.slice(r),this.limit+=s,this.cursor>=r?this.cursor+=s:this.cursor>t&&(this.cursor=t),s},this.slice_check=function(){return!(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length)},this.slice_from=function(t){var r=!1;return this.slice_check()&&(this.replace_s(this.bra,this.ket,t),r=!0),r},this.slice_del=function(){return this.slice_from("")},this.insert=function(t,r,i){r=this.replace_s(t,r,i);t<=this.bra&&(this.bra+=r),t<=this.ket&&(this.ket+=r)},this.slice_to=function(){var t="";return t=this.slice_check()?this.current.slice(this.bra,this.ket):t},this.assign_to=function(){return this.current.slice(0,this.limit)}};
var FinnishStemmer=function(){var c=new BaseStemmer,s=[["pa",-1,1],["sti",-1,2],["kaan",-1,1],["han",-1,1],["kin",-1,1],["hän",-1,1],["kään",-1,1],["ko",-1,1],["pä",-1,1],["kö",-1,1]],a=[["lla",-1,-1],["na",-1,-1],["ssa",-1,-1],["ta",-1,-1],["lta",3,-1],["sta",3,-1]],e=[["llä",-1,-1],["nä",-1,-1],["ssä",-1,-1],["tä",-1,-1],["ltä",3,-1],["stä",3,-1]],t=[["lle",-1,-1],["ine",-1,-1]],u=[["nsa",-1,3],["mme",-1,3],["nne",-1,3],["ni",-1,2],["si",-1,1],["an",-1,4],["en",-1,6],["än",-1,5],["nsä",-1,3]],r=[["aa",-1,-1],["ee",-1,-1],["ii",-1,-1],["oo",-1,-1],["uu",-1,-1],["ää",-1,-1],["öö",-1,-1]],o=[["a",-1,8],["lla",0,-1],["na",0,-1],["ssa",0,-1],["ta",0,-1],["lta",4,-1],["sta",4,-1],["tta",4,2],["lle",-1,-1],["ine",-1,-1],["ksi",-1,-1],["n",-1,7],["han",11,1],["den",11,-1,h],["seen",11,-1,v],["hen",11,2],["tten",11,-1,h],["hin",11,3],["siin",11,-1,h],["hon",11,4],["hän",11,5],["hön",11,6],["ä",-1,8],["llä",22,-1],["nä",22,-1],["ssä",22,-1],["tä",22,-1],["ltä",26,-1],["stä",26,-1],["ttä",26,2]],_=[["eja",-1,-1],["mma",-1,1],["imma",1,-1],["mpa",-1,1],["impa",3,-1],["mmi",-1,1],["immi",5,-1],["mpi",-1,1],["impi",7,-1],["ejä",-1,-1],["mmä",-1,1],["immä",10,-1],["mpä",-1,1],["impä",12,-1]],l=[["i",-1,-1],["j",-1,-1]],m=[["mma",-1,1],["imma",0,-1]],n=[17,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],b=[119,223,119,1],k=[17,65,16,1,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32],i=[17,65,16,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32],d=[17,97,24,1,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32],f=!1,g="",w=0,p=0;function q(){var r;if(!(c.cursor<p)){var i=c.limit_backward;if(c.limit_backward=p,c.ket=c.cursor,0==(r=c.find_among_b(s)))c.limit_backward=i;else{switch(c.bra=c.cursor,c.limit_backward=i,r){case 1:if(c.in_grouping_b(d,97,246))break;return;case 2:if(w<=c.cursor)break;return}c.slice_del()}}}function v(){return 0!=c.find_among_b(r)}function h(){return!!c.eq_s_b("i")&&!!c.in_grouping_b(i,97,246)}this.stem=function(){var r,i=c.cursor,i=(p=c.limit,w=c.limit,c.go_out_grouping(k,97,246)&&(c.cursor++,c.go_in_grouping(k,97,246))&&(c.cursor++,p=c.cursor,c.go_out_grouping(k,97,246))&&(c.cursor++,c.go_in_grouping(k,97,246))&&(c.cursor++,w=c.cursor),c.cursor=i,f=!1,c.limit_backward=c.cursor,c.cursor=c.limit,c.limit-c.cursor),i=(q(),c.cursor=c.limit-i,c.limit-c.cursor),i=((()=>{var r;if(!(c.cursor<p)){var i=c.limit_backward;if(c.limit_backward=p,c.ket=c.cursor,0==(r=c.find_among_b(u)))c.limit_backward=i;else switch(c.bra=c.cursor,c.limit_backward=i,r){case 1:var s=c.limit-c.cursor;if(c.eq_s_b("k"))return;if(c.cursor=c.limit-s,c.slice_del())break;return;case 2:if(!c.slice_del())return;if(c.ket=c.cursor,!c.eq_s_b("kse"))return;if(c.bra=c.cursor,c.slice_from("ksi"))break;return;case 3:if(c.slice_del())break;return;case 4:if(0==c.find_among_b(a))return;if(c.slice_del())break;return;case 5:if(0==c.find_among_b(e))return;if(c.slice_del())break;return;case 6:if(0==c.find_among_b(t))return;if(c.slice_del())break}}})(),c.cursor=c.limit-i,c.limit-c.cursor),i=((()=>{var r;if(!(c.cursor<p)){var i=c.limit_backward;if(c.limit_backward=p,c.ket=c.cursor,0==(r=c.find_among_b(o)))c.limit_backward=i;else{switch(c.bra=c.cursor,c.limit_backward=i,r){case 1:if(c.eq_s_b("a"))break;return;case 2:if(c.eq_s_b("e"))break;return;case 3:if(c.eq_s_b("i"))break;return;case 4:if(c.eq_s_b("o"))break;return;case 5:if(c.eq_s_b("ä"))break;return;case 6:if(c.eq_s_b("ö"))break;return;case 7:var s=c.limit-c.cursor,a=c.limit-c.cursor,e=c.limit-c.cursor;v()||(c.cursor=c.limit-e,c.eq_s_b("ie"))?(c.cursor=c.limit-a,c.cursor<=c.limit_backward?c.cursor=c.limit-s:(c.cursor--,c.bra=c.cursor)):c.cursor=c.limit-s;break;case 8:if(!c.in_grouping_b(k,97,246))return;if(c.in_grouping_b(b,98,122))break;return}c.slice_del()&&(f=!0)}}})(),c.cursor=c.limit-i,c.limit-c.cursor),i=((()=>{var r;if(!(c.cursor<w)){var i=c.limit_backward;if(c.limit_backward=w,c.ket=c.cursor,0==(r=c.find_among_b(_)))c.limit_backward=i;else{if(c.bra=c.cursor,c.limit_backward=i,1===r){i=c.limit-c.cursor;if(c.eq_s_b("po"))return;c.cursor=c.limit-i}c.slice_del()}}})(),c.cursor=c.limit-i,f?(i=c.limit-c.cursor,c.cursor<p||(r=c.limit_backward,c.limit_backward=p,c.ket=c.cursor,0==c.find_among_b(l)?c.limit_backward=r:(c.bra=c.cursor,c.limit_backward=r,c.slice_del())),c.cursor=c.limit-i):(r=c.limit-c.cursor,(()=>{var r;if(!(c.cursor<p)){var i=c.limit_backward;if(c.limit_backward=p,c.ket=c.cursor,c.eq_s_b("t")){c.bra=c.cursor;var s=c.limit-c.cursor;if(c.in_grouping_b(k,97,246)){if(c.cursor=c.limit-s,c.slice_del()&&(c.limit_backward=i,!(c.cursor<w))){s=c.limit_backward;if(c.limit_backward=w,c.ket=c.cursor,0==(r=c.find_among_b(m)))c.limit_backward=s;else{if(c.bra=c.cursor,c.limit_backward=s,1===r){s=c.limit-c.cursor;if(c.eq_s_b("po"))return;c.cursor=c.limit-s}c.slice_del()}}}else c.limit_backward=i}else c.limit_backward=i}})(),c.cursor=c.limit-r),c.limit-c.cursor);return(()=>{if(!(c.cursor<p)){var r=c.limit_backward,i=(c.limit_backward=p,c.limit-c.cursor),s=c.limit-c.cursor;if(!v()||(c.cursor=c.limit-s,c.ket=c.cursor,c.cursor<=c.limit_backward||(c.cursor--,c.bra=c.cursor,c.slice_del()))){c.cursor=c.limit-i;s=c.limit-c.cursor;if(c.ket=c.cursor,!c.in_grouping_b(n,97,228)||(c.bra=c.cursor,!c.in_grouping_b(b,98,122))||c.slice_del()){c.cursor=c.limit-s;i=c.limit-c.cursor;if(c.ket=c.cursor,c.eq_s_b("j")){c.bra=c.cursor;s=c.limit-c.cursor;if((c.eq_s_b("o")||(c.cursor=c.limit-s,c.eq_s_b("u")))&&!c.slice_del())return}c.cursor=c.limit-i;s=c.limit-c.cursor;c.ket=c.cursor,c.eq_s_b("o")&&(c.bra=c.cursor,c.eq_s_b("j"))&&!c.slice_del()||(c.cursor=c.limit-s,c.limit_backward=r,c.go_in_grouping_b(k,97,246)&&(c.ket=c.cursor,c.in_grouping_b(b,98,122))&&(c.bra=c.cursor,""!=(g=c.slice_to()))&&c.eq_s_b(g)&&c.slice_del())}}}})(),c.cursor=c.limit-i,c.cursor=c.limit_backward,!0},this.stemWord=function(r){return c.setCurrent(r),this.stem(),c.getCurrent()}};
window.Stemmer = FinnishStemmer;
