/*
 * This script contains the language-specific data used by searchtools.js,
 * namely the set of stopwords, stemmer, scorer and splitter.
 */

const stopwords = new Set(["aber", "alle", "allem", "allen", "aller", "alles", "als", "also", "am", "an", "ander", "andere", "anderem", "anderen", "anderer", "anderes", "anderm", "andern", "anderr", "anders", "auch", "auf", "aus", "bei", "bin", "bis", "bist", "da", "damit", "dann", "das", "dasselbe", "dazu", "da\u00df", "dein", "deine", "deinem", "deinen", "deiner", "deines", "dem", "demselben", "den", "denn", "denselben", "der", "derer", "derselbe", "derselben", "des", "desselben", "dessen", "dich", "die", "dies", "diese", "dieselbe", "dieselben", "diesem", "diesen", "dieser", "dieses", "dir", "doch", "dort", "du", "durch", "ein", "eine", "einem", "einen", "einer", "eines", "einig", "einige", "einigem", "einigen", "einiger", "einiges", "einmal", "er", "es", "etwas", "euch", "euer", "eure", "eurem", "euren", "eurer", "eures", "f\u00fcr", "gegen", "gewesen", "hab", "habe", "haben", "hat", "hatte", "hatten", "hier", "hin", "hinter", "ich", "ihm", "ihn", "ihnen", "ihr", "ihre", "ihrem", "ihren", "ihrer", "ihres", "im", "in", "indem", "ins", "ist", "jede", "jedem", "jeden", "jeder", "jedes", "jene", "jenem", "jenen", "jener", "jenes", "jetzt", "kann", "kein", "keine", "keinem", "keinen", "keiner", "keines", "k\u00f6nnen", "k\u00f6nnte", "machen", "man", "manche", "manchem", "manchen", "mancher", "manches", "mein", "meine", "meinem", "meinen", "meiner", "meines", "mich", "mir", "mit", "muss", "musste", "nach", "nicht", "nichts", "noch", "nun", "nur", "ob", "oder", "ohne", "sehr", "sein", "seine", "seinem", "seinen", "seiner", "seines", "selbst", "sich", "sie", "sind", "so", "solche", "solchem", "solchen", "solcher", "solches", "soll", "sollte", "sondern", "sonst", "um", "und", "uns", "unse", "unsem", "unsen", "unser", "unses", "unter", "viel", "vom", "von", "vor", "war", "waren", "warst", "was", "weg", "weil", "weiter", "welche", "welchem", "welchen", "welcher", "welches", "wenn", "werde", "werden", "wie", "wieder", "will", "wir", "wird", "wirst", "wo", "wollen", "wollte", "w\u00e4hrend", "w\u00fcrde", "w\u00fcrden", "zu", "zum", "zur", "zwar", "zwischen", "\u00fcber"]);
window.stopwords = stopwords;  // Export to global scope


/* Non-minified versions are copied as separate JavaScript files, if available */
BaseStemmer=function(){this.current="",this.cursor=0,this.limit=0,this.limit_backward=0,this.bra=0,this.ket=0,this.setCurrent=function(t){this.current=t,this.cursor=0,this.limit=this.current.length,this.limit_backward=0,this.bra=this.cursor,this.ket=this.limit},this.getCurrent=function(){return this.current},this.copy_from=function(t){this.current=t.current,this.cursor=t.cursor,this.limit=t.limit,this.limit_backward=t.limit_backward,this.bra=t.bra,this.ket=t.ket},this.in_grouping=function(t,r,i){return!(this.cursor>=this.limit||i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor++,0))},this.go_in_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.in_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward||i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor--,0))},this.go_in_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.out_grouping=function(t,r,i){return!(this.cursor>=this.limit)&&(i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor++,!0)},this.go_out_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.out_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward)&&(i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor--,!0)},this.go_out_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.eq_s=function(t){return!(this.limit-this.cursor<t.length||this.current.slice(this.cursor,this.cursor+t.length)!=t||(this.cursor+=t.length,0))},this.eq_s_b=function(t){return!(this.cursor-this.limit_backward<t.length||this.current.slice(this.cursor-t.length,this.cursor)!=t||(this.cursor-=t.length,0))},this.find_among=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit,e=0,n=0,c=!1;;){for(var u=r+(i-r>>>1),o=0,a=e<n?e:n,l=t[u],f=a;f<l[0].length;f++){if(s+a==h){o=-1;break}if(0!=(o=this.current.charCodeAt(s+a)-l[0].charCodeAt(f)))break;a++}if(o<0?(i=u,n=a):(r=u,e=a),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(l=t[r])[0].length){if(this.cursor=s+l[0].length,l.length<4)return l[2];var g=l[3](this);if(this.cursor=s+l[0].length,g)return l[2]}}while(0<=(r=l[1]));return 0},this.find_among_b=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit_backward,e=0,n=0,c=!1;;){for(var u,o=r+(i-r>>1),a=0,l=e<n?e:n,f=(u=t[o])[0].length-1-l;0<=f;f--){if(s-l==h){a=-1;break}if(0!=(a=this.current.charCodeAt(s-1-l)-u[0].charCodeAt(f)))break;l++}if(a<0?(i=o,n=l):(r=o,e=l),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(u=t[r])[0].length){if(this.cursor=s-u[0].length,u.length<4)return u[2];var g=u[3](this);if(this.cursor=s-u[0].length,g)return u[2]}}while(0<=(r=u[1]));return 0},this.replace_s=function(t,r,i){var s=i.length-(r-t);return this.current=this.current.slice(0,t)+i+this.current.slice(r),this.limit+=s,this.cursor>=r?this.cursor+=s:this.cursor>t&&(this.cursor=t),s},this.slice_check=function(){return!(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length)},this.slice_from=function(t){var r=!1;return this.slice_check()&&(this.replace_s(this.bra,this.ket,t),r=!0),r},this.slice_del=function(){return this.slice_from("")},this.insert=function(t,r,i){r=this.replace_s(t,r,i);t<=this.bra&&(this.bra+=r),t<=this.ket&&(this.ket+=r)},this.slice_to=function(){var t="";return t=this.slice_check()?this.current.slice(this.bra,this.ket):t},this.assign_to=function(){return this.current.slice(0,this.limit)}};
var GermanStemmer=function(){var n=new BaseStemmer,o=[["",-1,5],["ae",0,2],["oe",0,3],["qu",0,-1],["ue",0,4],["ß",0,1]],s=[["",-1,5],["U",0,2],["Y",0,1],["ä",0,3],["ö",0,4],["ü",0,2]],l=[["e",-1,3],["em",-1,1],["en",-1,3],["erinnen",2,2],["erin",-1,2],["ln",-1,5],["ern",-1,2],["er",-1,2],["s",-1,4],["es",8,3],["lns",8,5]],f=[["tick",-1,-1],["plan",-1,-1],["geordn",-1,-1],["intern",-1,-1],["tr",-1,-1]],_=[["en",-1,1],["er",-1,1],["et",-1,3],["st",-1,2],["est",3,1]],m=[["ig",-1,1],["lich",-1,1]],b=[["end",-1,1],["ig",-1,2],["ung",-1,1],["lich",-1,3],["isch",-1,2],["ik",-1,2],["heit",-1,3],["keit",-1,4]],t=[17,65,16,1,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32,8],k=[1,128,198,227,32,0,0,0,0,0,0,0,0,0,0,0,0,128],g=[117,30,5],d=[117,30,4],c=0,u=0,a=0;function v(){return a<=n.cursor}function h(){return u<=n.cursor}this.stem=function(){var r,i=n.cursor,i=((()=>{for(var r,i=n.cursor;;){var e=n.cursor;r:{for(;;){var s=n.cursor;i:if(n.in_grouping(t,97,252)){n.bra=n.cursor;e:{var c=n.cursor;if(n.eq_s("u")&&(n.ket=n.cursor,n.in_grouping(t,97,252))){if(n.slice_from("U"))break e;return}if(n.cursor=c,!n.eq_s("y"))break i;if(n.ket=n.cursor,!n.in_grouping(t,97,252))break i;if(!n.slice_from("Y"))return}n.cursor=s;break}if(n.cursor=s,n.cursor>=n.limit)break r;n.cursor++}continue}n.cursor=e;break}for(n.cursor=i;;){var u=n.cursor;r:{switch(n.bra=n.cursor,r=n.find_among(o),n.ket=n.cursor,r){case 1:if(n.slice_from("ss"))break;return;case 2:if(n.slice_from("ä"))break;return;case 3:if(n.slice_from("ö"))break;return;case 4:if(n.slice_from("ü"))break;return;case 5:if(n.cursor>=n.limit)break r;n.cursor++}continue}n.cursor=u;break}})(),n.cursor=i,n.cursor),e=(a=n.limit,u=n.limit,r=n.cursor,(e=n.cursor+3)>n.limit||(n.cursor=e,c=n.cursor,n.cursor=r,n.go_out_grouping(t,97,252)&&(n.cursor++,n.go_in_grouping(t,97,252))&&(n.cursor++,a=n.cursor,c<=a||(a=c),n.go_out_grouping(t,97,252))&&(n.cursor++,n.go_in_grouping(t,97,252))&&(n.cursor++,u=n.cursor)),n.cursor=i,n.limit_backward=n.cursor,n.cursor=n.limit,(()=>{var r,i=n.limit-n.cursor;r:if(n.ket=n.cursor,0!=(r=n.find_among_b(l))&&(n.bra=n.cursor,v()))switch(r){case 1:var e=n.limit-n.cursor;if(n.eq_s_b("syst"))break r;if(n.cursor=n.limit-e,n.slice_del())break;return;case 2:if(n.slice_del())break;return;case 3:if(!n.slice_del())return;e=n.limit-n.cursor;if(n.ket=n.cursor,n.eq_s_b("s"))if(n.bra=n.cursor,n.eq_s_b("nis")){if(!n.slice_del())return}else n.cursor=n.limit-e;else n.cursor=n.limit-e;break;case 4:if(!n.in_grouping_b(g,98,116))break r;if(n.slice_del())break;return;case 5:if(n.slice_from("l"))break;return}n.cursor=n.limit-i,i=n.limit-n.cursor;r:if(n.ket=n.cursor,0!=(r=n.find_among_b(_))&&(n.bra=n.cursor,v()))switch(r){case 1:if(n.slice_del())break;return;case 2:if(!n.in_grouping_b(d,98,116))break r;var s=n.cursor-3;if(s<n.limit_backward)break r;if(n.cursor=s,n.slice_del())break;return;case 3:var c=n.limit-n.cursor;if(!n.in_grouping_b(k,85,228))break r;n.cursor=n.limit-c;var u=n.limit-n.cursor;if(0!=n.find_among_b(f))break r;if(n.cursor=n.limit-u,n.slice_del())break;return}n.cursor=n.limit-i,i=n.limit-n.cursor;r:if(n.ket=n.cursor,0!=(r=n.find_among_b(b))&&(n.bra=n.cursor,h()))switch(r){case 1:if(!n.slice_del())return;var o=n.limit-n.cursor;if(n.ket=n.cursor,n.eq_s_b("ig")){n.bra=n.cursor;var t=n.limit-n.cursor;if(n.eq_s_b("e"))n.cursor=n.limit-o;else if(n.cursor=n.limit-t,h()){if(!n.slice_del())return}else n.cursor=n.limit-o}else n.cursor=n.limit-o;break;case 2:var a=n.limit-n.cursor;if(n.eq_s_b("e"))break r;if(n.cursor=n.limit-a,n.slice_del())break;return;case 3:if(!n.slice_del())return;t=n.limit-n.cursor,o=(n.ket=n.cursor,n.limit-n.cursor);if(n.eq_s_b("er")||(n.cursor=n.limit-o,n.eq_s_b("en")))if(n.bra=n.cursor,v()){if(!n.slice_del())return}else n.cursor=n.limit-t;else n.cursor=n.limit-t;break;case 4:if(!n.slice_del())return;a=n.limit-n.cursor;if(n.ket=n.cursor,0==n.find_among_b(m))n.cursor=n.limit-a;else if(n.bra=n.cursor,h()){if(!n.slice_del())return}else n.cursor=n.limit-a}n.cursor=n.limit-i})(),n.cursor=n.limit_backward,n.cursor);return(()=>{for(var r;;){var i=n.cursor;r:{switch(n.bra=n.cursor,r=n.find_among(s),n.ket=n.cursor,r){case 1:if(n.slice_from("y"))break;return;case 2:if(n.slice_from("u"))break;return;case 3:if(n.slice_from("a"))break;return;case 4:if(n.slice_from("o"))break;return;case 5:if(n.cursor>=n.limit)break r;n.cursor++}continue}n.cursor=i;break}})(),n.cursor=e,!0},this.stemWord=function(r){return n.setCurrent(r),this.stem(),n.getCurrent()}};
window.Stemmer = GermanStemmer;
