# 🛠️ Guía de Actualización: Antigravity Framework (Gen 2)

Esta guía documenta las mejoras realizadas en el **Antigravity Framework Starter Kit** para ser implementadas en la rama maestra por el equipo de desarrollo.

## 🚀 Resumen de Innovaciones
La versión "Generación 2" se enfoca en la **personalización instantánea** y la **expansión de dominios** (Data Science).

---

## ⚖️ Especialización de Herramientas (Generación 2)
Para mantener el framework ágil y profesional, hemos dividido las responsabilidades de análisis:

| Herramienta | Función Principal | Cuándo Usar |
| :--- | :--- | :--- |
| **`uv run ai-ctx`** | Análisis de Complejidad y Contexto | Mantenimiento diario, refactorización y auditoría de código base. |
| **`qgis-analyzer`** | Auditoría de Estándares QGIS | Antes de un Release, validación de UI/i18n y cumplimiento de repo oficial. |

---

## 1. Sistema de Placeholders Dinámicos
Se ha introducido el uso de `{{PROJECT_NAME}}` en archivos de configuración base para evitar la edición manual pesada.
- **Archivos afectados**: `pyproject.toml`, `README.md`.
- **Beneficio**: Permite que scripts de automatización detecten y personalicen el proyecto sin riesgo de romper la sintaxis.

## 2. Script de Automatización: `bootstrap.py`
Se ha incluido un script en la raíz del kit que actúa como asistente de configuración inicial.
- **Funcionalidad**:
    1.  Interactúa con el usuario para definir el nombre del proyecto.
    2.  Realiza el reemplazo de placeholders en caliente.
    3.  Limpia dependencias e inicializa el entorno con `uv sync`.
- **Implementación**: Debe copiarse en la raíz del repositorio template.

## 3. Skill de Dominio: Data Science
Se ha añadido el primer skill especializado de "vida real" en el `scaffold/`.
- **Estructura**:
    - `skills/data-science/SKILL.md`: Prompting estructurado para EDA.
    - `scripts/validate_dataset.py`: Validador de calidad de datos.
    - `examples/eda_template.py`: Referencia de implementación.
- **Propósito**: Servir como estándar sobre cómo los skins deben incluir scripts de validación y ejemplos.

## 4. Reestructuración de `BOOTSTRAP.md`
El documento de inicio para el usuario final ahora es más conciso y se apoya en el script `bootstrap.py`.

---

## 📋 Código Fuente y Cambios Detallados

A continuación se detalla el código exacto que debe integrarse en el Starter Kit.

### A. Script de Configuración: `bootstrap.py`
**Ubicación sugerida**: Raíz del repositorio.

```python
import os
import subprocess
import sys

def run_command(command):
    """Run a shell command and print its output."""
    print(f"Executing: {command}")
    try:
        subprocess.check_call(command, shell=True)
    except subprocess.CalledProcessError as e:
        print(f"Error executing command: {e}")
        return False
    return True

def replace_in_file(file_path, placeholder, replacement):
    """Replace all occurrences of placeholder in a file."""
    if not os.path.exists(file_path):
        print(f"Warning: File {file_path} not found.")
        return False

    with open(file_path, 'r', encoding='utf-8') as f:
        content = f.read()

    new_content = content.replace(placeholder, replacement)

    with open(file_path, 'w', encoding='utf-8') as f:
        f.write(new_content)
    return True

def bootstrap():
    print("🚀 Antigravity Framework - Project Bootstrapper\n")

    project_name = input("Enter project name (e.g., my-awesome-plugin): ").strip()
    if not project_name:
        print("Error: Project name is required.")
        sys.exit(1)

    # 1. Replace placeholders
    files_to_update = ['pyproject.toml', 'README.md']
    for file in files_to_update:
        print(f"Updating {file}...")
        replace_in_file(file, "{{PROJECT_NAME}}", project_name)

    # 2. Initialize uv
    print("\n📦 Initializing environment with uv...")
    if run_command("uv sync"):
        print("\n✅ Environment ready!")
    else:
        print("\n⚠️ Failed to initialize environment. Make sure 'uv' is installed.")

    print(f"\n✨ Project '{project_name}' configured successfully!")
    sys.exit(0)

if __name__ == "__main__":
    bootstrap()
```

### B. Plantilla de Skill: Data Science
**Ubicación**: `scaffold/skills/data-science/`

#### 1. `SKILL.md`
```markdown
---
name: data-science
description: Especialización en análisis de datos, limpieza, EDA y modelado estadístico.
trigger: al trabajar con archivos CSV, Excel, Parquet o bases de datos de análisis.
---
# Skill: Data Science (Standard)

## Guía Operativa
1. **Validación**: Ejecutar `uv run python scripts/validate_dataset.py --input path/to/dataset.csv`.
2. **EDA**: Seguir el template `examples/eda_template.py` para análisis descriptivo y correlaciones.
```

#### 2. `scripts/validate_dataset.py`
```python
import pandas as pd
from pathlib import Path
import argparse

def validate(file_path):
    df = pd.read_csv(file_path)
    print(f"Rows: {df.shape[0]}, Cols: {df.shape[1]}")
    print(df.isnull().sum())
    print(df.dtypes)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input", required=True)
    validate(parser.parse_args().input)
```

### C. Configuración con Placeholders
**`pyproject.toml`**:
```toml
[project]
name = "{{PROJECT_NAME}}"
version = "0.1.0"
# ... resto de la config
```

---

## 📋 Instrucciones para Mantenedores
Para integrar estos cambios en el repositorio maestro:
1.  **Sync**: Copiar `bootstrap.py` del kit generado a la raíz del repo.
2.  **Scaffold Update**: Reemplazar la carpeta `scaffold/skills/data-science/` con la nueva versión.
3.  **Placeholders**: Asegurarse de que `pyproject.toml` contenga `name = "{{PROJECT_NAME}}"` antes de hacer el merge.

> [!IMPORTANT]
> Esta actualización reduce el "Time to First Code" de un nuevo plugin de 15 minutos a menos de 1 minuto.
