# Antigravity Framework: El Sistema Operativo para Agentes de IA

El **Framework Antigravity** es una metodología de orquestación diseñada para transformar un repositorio de código en un ecosistema de colaboración inteligente. Proporciona los "rieles" necesarios para que cualquier IA opere con autonomía, precisión técnica y alineación absoluta con los estándares del proyecto.

## 🏗️ Los 4 Pilares del Framework

1.  **Skills (Conocimiento Declarativo)**: Manuales estructurados en YAML/Markdown que cargan "conocimiento experto" bajo demanda (Just-in-Time Learning).
2.  **Workflows (Ejecución Determinista)**: Flujos paso a paso que garantizan que el desarrollo siga un camino de calidad.
3.  **Roles (Identidad Cognitiva)**: Perfiles especializados (Architect, QA, Dev) que condicionan el rigor y el tono.
4.  **Memoria (Continuidad Semántica)**: Archivos persistentes (`AGENT_LESSONS.md`) que permiten al agente aprender y recordar.

## 📈 Beneficios Tangibles

| Beneficio | Descripción |
| :--- | :--- |
| **Onboarding Instantáneo** | Un nuevo desarrollador (o IA) entiende sus capacidades leyendo `AGENTS.md`. |
| **Calidad Consistente** | Checklists obligatorios aseguran que "Done" signifique lo mismo siempre. |
| **Reducción de Errores** | Los workflows actúan como *checklists de vuelo* para procesos críticos (Releases, Testing). |
| **Contexto Eficiente** | Carga solo los archivos necesarios según la tarea activa, optimizando el uso de tokens. |

## 📂 Anatomía de un Proyecto Antigravity

```text
.agent/
├── AGENTS.md             # El "Cerebro": Definición de roles y capacidades
├── skills/               # El "Saber": Módulos de conocimiento (coding-standards, git)
├── workflows/            # El "Hacer": Guías paso a paso (release, inicia-sesion)
├── memory/               # El "Recordar": Lecciones aprendidas y contexto dinámico
└── resources/            # El "Manual": Activos estáticos y snippets de código
```

## 🚀 Versatilidad por Ecosistema

El framework se adapta mediante la **Especialización de Habilidades**:

-   **Backend (Django/FastAPI)**: Skills en ORM, estándares REST y despliegue en la nube.
-   **Data Science**: Skills en optimización de Pandas, versionado de modelos y limpieza de datos.
-   **QGIS Plugins**: Skills en la API PyQGIS, asincronía (`QgsTask`) y mocking espacial.

## 🧠 Filosofía "Local First"

Antigravity asume que el asistente vive dentro del entorno del usuario. El código es la fuente de verdad, y el sistema permite que el agente entienda el repositorio no solo como texto, sino como un sistema vivo con reglas de negocio y métricas de calidad.

---
*Antigravity: Orquestación profesional para la era AI-Native.*
