# QGIS Plugin Modernization Standard

This repository contains the **Standard Modernization Guide for QGIS Plugins**, designed for development teams looking to adopt modern tools like `uv`, `ruff`, and `github-actions`.

## Content

- [📄 Modernization Guide (GUIDE.md)](GUIDE.md): The complete step-by-step procedure.

## Standard Objectives

1.  **Speed**: Reduce installation times from minutes to milliseconds using `uv`.
2.  **Quality**: Implement strict static analysis (Ruff, Mypy) by default.
3.  **Reproducibility**: Eliminate "works on my machine" issues via a unified `pyproject.toml`.
4.  **Automation**: Standardize CI/CD and pre-commit hooks.

## How to Use

Clone this repository and follow the steps in `GUIDE.md` to update your legacy projects.

## License

This document is distributed under the **CC-BY-4.0** license, allowing free distribution and adaptation for your teams.
