# Documentation Standards

## Image Naming Convention

For consistency and clarity in documentation, use the following naming convention for images located in `docs/images/`:

**Format:** `category_description_context.png` (using snake_case)

### Categories
*   **workflow**: For step-by-step guides (e.g., `workflow_01_select_dem.png`)
*   **ui**: For general interface screenshots (e.g., `ui_main_dialog.png`)
*   **feature**: For highlighting specific features (e.g., `feature_measure_tool.png`)
*   **tool**: For specific tools or icons (e.g., `tool_pan_icon.png`)

### Examples
1.  `workflow_01_input_selection.png` (Selecting DEM and Section Line)
2.  `workflow_02_geology_setup.png` (Configuring geology tab)
3.  `workflow_03_preview_generated.png` (The resulting profile)
4.  `feature_dynamic_checkboxes.gif` (Showing valid/invalid state)
5.  `feature_measure_tool_demo.png` (Showing the measurement in action)
