# Commit Message Guidelines

This project follows the **Conventional Commits** specification.

## Format

```text
<type>(<optional scope>): <concise description in imperative mood>

[optional body explaining "why"]

[optional footer(s)]
```

## Allowed Types

*   `feat`: A new feature
*   `fix`: A bug fix
*   `refactor`: A code change that neither fixes a bug nor adds a feature
*   `docs`: Documentation only changes
*   `test`: Adding missing tests or correcting existing tests
*   `chore`: Changes to the build process or auxiliary tools and libraries such as documentation generation

## Rules

1.  **Description**: Use the imperative mood ("add" not "added" or "adds"). No period at the end.
2.  **Body**: Use the body to explain *what* and *why* vs. *how*.
3.  **Language**: English (as per user preference).
