# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SDG_15_1_2_calculator
                                 A QGIS plugin
 Proportion of important sites for terrestrial and freshwater biodiversity that are covered by protected areas, by ecosystem type
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-07-14
        copyright            : (C) 2022 by IIA-CNR
        email                : aquilino@iia.cnr.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'IIA-CNR'
__date__ = '2022-07-14'
__copyright__ = '(C) 2022 by IIA-CNR'



# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QVariant,QSettings, QTranslator, qVersion, QCoreApplication, QFileInfo
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingMultiStepFeedback,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterFileDestination,
                       QgsVectorLayer,
                       QgsRasterLayer,
                       QgsMessageLog)
import processing
from osgeo import ogr,gdal,osr
from qgis.analysis import *
from processing.core.Processing import Processing
import sys,os, glob,tempfile, shutil, errno
import matplotlib, math


class SDG_15_1_2_calculatorAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('Ecosystemmap', 'Ecosystem map', defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('KeyBiodiversityArea', 'Key Biodiversity Area', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('ProtectedAreasboundaries', 'Protected Areas boundaries', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Output', 'output', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFileDestination('Log', 'log', fileFilter='Text files (*.txt);;HTML files (*.html *.HTML)', createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(11, model_feedback)
        results = {}
        outputs = {}

        # Rename layer
        alg_params = {
            'INPUT': parameters['Ecosystemmap'],
            'NAME': 'Ecomap'
        }
        outputs['RenameLayer'] = processing.run('native:renamelayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        gr= QgsRasterLayer(outputs['RenameLayer']['OUTPUT'])

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
        
        # r.info
        alg_params = {
            '-e': False,
            '-g': False,
            '-h': False,
            '-r': False,
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER': None,
            'html': 'TEMPORARY_OUTPUT',
            'map': parameters['Ecosystemmap'],
            'html': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Rinfo'] = processing.run('grass7:r.info', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Overlap analysis
        alg_params = {
            'INPUT': parameters['KeyBiodiversityArea'],
            'LAYERS': parameters['ProtectedAreasboundaries'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['OverlapAnalysis'] = processing.run('native:calculatevectoroverlaps', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Raster layer properties
        alg_params = {
            'BAND': 1,
            'INPUT': parameters['Ecosystemmap']
        }
        outputs['RasterLayerProperties'] = processing.run('native:rasterlayerproperties', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        #gr = (parameters['Ecosystemmap'])
        # This is how to take back the ownership of the layer from the context # 
        #gr = context.takeResultLayer(lyr_out_str)
        
        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Zonal statistics
        alg_params = {
            'COLUMN_PREFIX': 'N_',
            'INPUT': parameters['ProtectedAreasboundaries'],
            'INPUT_RASTER': parameters['Ecosystemmap'],
            'RASTER_BAND': 1,
            'STATISTICS': [1],  # Sum
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ZonalStatistics'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Intersection
        alg_params = {
            'INPUT': outputs['OverlapAnalysis']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['ZonalStatistics']['OUTPUT'],
            'OVERLAY_FIELDS': ['N_sum'],
            'OVERLAY_FIELDS_PREFIX': 'Ov',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Area_calculator
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': ' $area ',
            'INPUT': outputs['Intersection']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Area_calculator'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}


        # PixelAreaCalculator      
        alg_params = {
            'FIELD_LENGTH': 2,
            'FIELD_NAME': 'PixArea',
            'FIELD_PRECISION': 10,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': gr.rasterUnitsPerPixelX()*gr.rasterUnitsPerPixelY(),
            'INPUT': outputs['Area_calculator']['OUTPUT'],
            'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT,
            #'OUTPUT': parameters['Output']
        }
        outputs['PixAreaCalculator'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Output'] = outputs['PixAreaCalculator']['OUTPUT']

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Field calculator        
        alg_params = {
            'FIELD_LENGTH': 2,
            'FIELD_NAME': 'Percentage',
            'FIELD_PRECISION': 4,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '(100.0*\"PixArea\"*\"OvN_sum\")/ \"Area\"',
            'INPUT': outputs['PixAreaCalculator']['OUTPUT'],
            'OUTPUT':parameters['Output'],
            #'OUTPUT': parameters['Output']
        }
        outputs['FieldCalculator'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Output'] = outputs['FieldCalculator']['OUTPUT']
        
        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        #layer_out = context.takeResultLayer(7)
        #part2: textual output
        a = {}
        b = {}
        c = {}

        resultat = {}
        resultat1 = {}

        oo=QgsVectorLayer(outputs['FieldCalculator']['OUTPUT'])
        if not oo.isValid():
            try:
                with tempfile.TemporaryDirectory() as tempdir1:
                    # Save vector features to file
                    # Rename layer2
                    # Field calculator        
                    alg_params = {
                    'FIELD_LENGTH': 2,
                    'FIELD_NAME': 'Percentage',
                    'FIELD_PRECISION': 4,
                    'FIELD_TYPE': 0,  # Float
                    'FORMULA': '(100.0*\"PixArea\"*\"OvN_sum\")/ \"Area\"',
                    'INPUT': outputs['PixAreaCalculator']['OUTPUT'],
                    'OUTPUT':tempdir1+'\\outint'+'.shp',
                    #'OUTPUT': parameters['Output']
                    }
                    outputs['FieldCalculator'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                    results['Output'] = outputs['FieldCalculator']['OUTPUT']

                    feedback.setCurrentStep(9)
                    if feedback.isCanceled():
                       return {}

                    oo=QgsVectorLayer(tempdir1+'\\outint'+'.shp')
            except:
                QgsMessageLog.logMessage("Vector layer as a temp file!")

        for feat in oo.getFeatures():
            a[feat["SitRecID"]] = feat["Area_meter"]
            b[feat["SitRecID"]] = feat["Area"]
            c[feat["SitRecID"]]  = feat["OvN_sum"]*gr.rasterUnitsPerPixelX()*gr.rasterUnitsPerPixelY()

        resultat = {key: (100*b.get(key, 0)/a[key]) for key in a.keys()}
        resultat1 = {key: (100*c.get(key, 0)/b[key]) for key in b.keys()}

        count = 0
        mysum = 0
        mysum1= 0

        for i in resultat:
            count += 1
            mysum += resultat[i]
            mysum1 += resultat1[i]

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}
        
        # Save log to file
        alg_params = {
            'USE_HTML': False,
            'OUTPUT': parameters['Log']
        }
        outputs['SaveLogToFile'] = processing.run('native:savelog', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Log'] = outputs['SaveLogToFile']['OUTPUT']

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}   

        outFile =open(outputs['SaveLogToFile']['OUTPUT'], 'a')
        #print ("The mean percentage of area covered by protected area is ", mysum/count, file=outFile)
        print ("The mean percentage of area covered by protected area is ", mysum/count, file=outFile)
        print ("The mean percentage of area covered by protected area by ecosystem type is ", mysum1/count,file=outFile )
        outFile.close()

        return results
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        source = self.parameterAsSource(parameters, self.INPUT, context)
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        # Compute the number of steps to display within the progress bar and
        # get features from source
        total = 100.0 / source.featureCount() if source.featureCount() else 0
        features = source.getFeatures()

        for current, feature in enumerate(features):
            # Stop the algorithm if cancel button has been clicked
            if feedback.isCanceled():
                break

            # Add a feature in the sink
            sink.addFeature(feature, QgsFeatureSink.FastInsert)

            # Update the progress bar
            feedback.setProgress(int(current * total))
        
    

        # Return the results of the algorithm. In this case our only result is
        # the feature sink which contains the processed features, but some
        # algorithms may return multiple feature sinks, calculated numeric
        # statistics, etc. These should all be included in the returned
        # dictionary, with keys matching the feature corresponding parameter
        # or output names.
        return {self.OUTPUT: dest_id}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'SDG_15_1_2_calculator'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'SDG_15_1_2_calculator'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return SDG_15_1_2_calculatorAlgorithm()
