# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SciPyFilters
                                 A QGIS plugin
 Filter collection implemented with SciPy
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-03
        copyright            : (C) 2024 by Florian Neukirchen
        email                : mail@riannek.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Florian Neukirchen'
__date__ = '2024-03-03'
__copyright__ = '(C) 2024 by Florian Neukirchen'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import numpy as np


def minimumvalue(dtype):
    """Return the smallest possible value for a given dtype"""
    if np.issubdtype(dtype, np.integer):
        return np.iinfo(dtype).min
    else: 
        # Float
        return - np.inf


def maximumvalue(dtype):
    """Return the largest possible value for a given dtype"""
    if np.issubdtype(dtype, np.integer):
        return np.iinfo(dtype).max
    else: 
        # Float
        return np.inf

def centralvalue(dtype):
    """Return the difference of max and min of possible dtype values"""
    if np.issubdtype(dtype, np.unsignedinteger):
        return (np.iinfo(dtype).max - np.iinfo(dtype).min) // 2
    else: 
        # Float, signed integer
        return 0

def bandmean(dataset, band, approx=True):
    """Return band mean, estimated with gdal"""
    # GDAL band GetStatistics(): 
    # Set first parameter bApproxOK to True to get quick approximation
    # Second parameter: if quick way is not possible, calculate stats,
    # If False it may throw an exception if quick way is not possible
    # GDAL Returns (min, max, mean, std)

    stats = dataset.GetRasterBand(band).GetStatistics(approx,True)

    return stats[2]

def is_in_dtype_range(value, dtype):
    if np.issubdtype(dtype, np.integer):
        info = np.iinfo(dtype)
        if value < info.min or value > info.max:
            return False
    return True  