# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SciPyFilters
                                 A QGIS plugin
 Filter collection implemented with SciPy
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-03
        copyright            : (C) 2024 by Florian Neukirchen
        email                : mail@riannek.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Florian Neukirchen'
__date__ = '2024-03-03'
__copyright__ = '(C) 2024 by Florian Neukirchen'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'


from osgeo import gdal
from scipy import ndimage
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterRasterDestination,
                       QgsProcessingParameterString,
                       QgsProcessingException,
                        )

from .scipy_algorithm_baseclasses import SciPyAlgorithm

from .ui.structure_widget import (StructureWidgetWrapper, 
                                  SciPyParameterStructure,)

from .helpers import (array_to_str, 
                      str_to_int_or_list, 
                      check_structure, 
                      str_to_array, 
                      morphostructexamples,
                      footprintexamples)


class SciPyBinaryFillHolesAlgorithm(SciPyAlgorithm):

    STRUCTURE = 'STRUCTURE'
    CUSTOMSTRUCTURE = 'CUSTOMSTRUCTURE'

    # Overwrite constants of base class
    _name = 'fill_holes'
    _displayname = 'Morphological (binary) fill holes'
    _outputname = "Morphology: Fill holes" # If set to None, the displayname is used 
    _groupid = 'morphological'
    _help = """
            Fill holes in binary shapes by using binary dilations. \
            Calculated with binary_fill_holes from \
            <a href="https://docs.scipy.org/doc/scipy/reference/ndimage.html">scipy.ndimage</a>.

            <b>Dimension</b> Calculate for each band separately (2D) \
            or use all bands as a 3D datacube and perform filter in 3D. \
            Note: bands will be the first axis of the datacube.
            
            <b>Structure</b> String representation of array. \
            Must have 2 dimensions if <i>dimension</i> is set to 2D. \
            Should have 3 dimensions if <i>dimension</i> is set to 3D, \
            but a 2D array is also excepted (a new axis is added as first \
            axis and the result is the same as calculating each band \
            seperately). Examples can be loaded with the load button. \
            For convenience (i.e. when calling from a script), \
            the following shortcuts are accepted as well: \
            "square", "cross", "cross3D", "ball", "cube".
            """
    
    # The function to be called
    def get_fct(self):
        return ndimage.binary_fill_holes

 
    def initAlgorithm(self, config):
        super().initAlgorithm(config)

        struct_param = SciPyParameterStructure(
            self.STRUCTURE,
            self.tr('Structure'),
            defaultValue="[[0, 1, 0],\n[1, 1, 1],\n[0, 1, 0]]",
            examples=morphostructexamples,
            multiLine=True,
            to_int=True,
            optional=True,
            )
        
        struct_param.setMetadata({
            'widget_wrapper': {
                'class': StructureWidgetWrapper
            }
        })

        self.addParameter(struct_param)


    def get_parameters(self, parameters, context):
        kwargs = super().get_parameters(parameters, context)

        structure = self.parameterAsString(parameters, self.STRUCTURE, context)
        kwargs['structure'] = str_to_array(structure, self._ndim)

        return kwargs
    
    
    def checkParameterValues(self, parameters, context): 
        dims = self.getDimsForCheck(parameters, context)

        structure = self.parameterAsString(parameters, self.STRUCTURE, context)
        ok, s = check_structure(structure, dims)
        if not ok:
            return (ok, s)
            
        return super().checkParameterValues(parameters, context)
    
    def createInstance(self):
        return SciPyBinaryFillHolesAlgorithm()

