# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SciPyFilters
                                 A QGIS plugin
 Filter collection implemented with SciPy
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-03
        copyright            : (C) 2024 by Florian Neukirchen
        email                : mail@riannek.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Florian Neukirchen'
__date__ = '2024-03-03'
__copyright__ = '(C) 2024 by Florian Neukirchen'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication

try:
    from .scipy_filters_provider import SciPyFiltersProvider
except ModuleNotFoundError:
    # If scipy is not installed. We check below.
    pass

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class SciPyFiltersPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        try:
            self.provider = SciPyFiltersProvider()
            scipy_is_installed = True
        except NameError:
            scipy_is_installed = False

        if not scipy_is_installed:
            scipy_is_installed = self.install_scipy()

        if scipy_is_installed:
            QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)


    def install_scipy(self):
        from qgis.PyQt.QtWidgets import QMessageBox
        choice = QMessageBox.question(
            None,
            'SciPy Filters: SciPy is not installed',
            'SciPy is not installed. Do you want to install it automatically (using pip)?',
            QMessageBox.Yes | QMessageBox.No
        )
        if choice == QMessageBox.Yes:
            msg = None
            res = ""
            import subprocess
            import sys

            try:
                res = subprocess.check_call([sys.executable, '-m', 'pip', 'install', 'scipy'])
            except subprocess.CalledProcessError:
                msg = 'Installing SciPy failed. This probably means that pip is not installed.'
            

            # Test if it worked
            try:
                import scipy
            except ModuleNotFoundError:
                msg = 'Installing SciPy failed.'

            if not msg:
                return True
            
            QMessageBox.warning(
                None,
                'SciPy Filters: Installing SciPy failed.',
                msg + ' ' + res
            )


        return False