# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SciPyFilters
                                 A QGIS plugin
 Filter collection implemented with SciPy
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-03
        copyright            : (C) 2024 by Florian Neukirchen
        email                : mail@riannek.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Florian Neukirchen'
__date__ = '2024-03-03'
__copyright__ = '(C) 2024 by Florian Neukirchen'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import json
import numpy as np
from osgeo import gdal
from scipy import ndimage
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterRasterDestination,
                       QgsProcessingParameterString,
                       QgsProcessingParameterBoolean,
                       QgsProcessingException,
                        )
from .scipy_algorithm_baseclasses import SciPyAlgorithm

from .helpers import array_to_str, str_to_int_or_list, check_structure, str_to_array


class SciPyBinaryHitMissAlgorithm(SciPyAlgorithm):


    STRUCTURE1 = 'STRUCTURE1'
    STRUCTURE2 = 'STRUCTURE2'

    # Overwrite constants of base class
    _name = 'hit_or_miss'
    _displayname = 'Morphological (binary) hit or miss'
    _outputname = "Morphology: binary hit or miss"# If set to None, the displayname is used 
    _groupid = 'morphological'
    _help = """
            Preserves pixels whose neighbourhood matches structure1, but does not match the (disjoint) structure2.  \
            Calculated with binary_hit_or_miss from \
            <a href="https://docs.scipy.org/doc/scipy/reference/ndimage.html">scipy.ndimage</a>.

            <b>Dimension</b> Calculate for each band separately (2D) \
            or use all bands as a 3D datacube and perform filter in 3D. \
            Note: bands will be the first axis of the datacube.

            <b>Structure 1</b> String representation of array. 
            <b>Structure 2</b> String representation of array, disjoint to structure 1. \
             If no value is provided, the complementary of structure1 is taken.

            Both structures must have 2 dimensions if <i>dimension</i> is set to 2D. \
            Should have 3 dimensions if <i>dimension</i> is set to 3D, \
            but a 2D array is also excepted (a new axis is added as first \
            axis and the result is the same as calculating each band \
            seperately).
            """
    
    # The function to be called
    def get_fct(self):
        return ndimage.binary_hit_or_miss
 
    def initAlgorithm(self, config):
        super().initAlgorithm(config)


        self.addParameter(QgsProcessingParameterString(
            self.STRUCTURE1,
            self.tr('Structure 1: Custom structure (string representation of array)'),
            defaultValue="[[1, 0, 0],\n[0, 1, 1],\n[0, 1, 1]]",
            multiLine=True,
            optional=True,
            ))
        

        self.addParameter(QgsProcessingParameterString(
            self.STRUCTURE2,
            self.tr('Structure 2: Custom structure (string representation of array)'),
            defaultValue="[[1, 1, 1],\n[1, 1, 1],\n[1, 1, 1]]",
            multiLine=True,
            optional=True,
            ))

    def get_parameters(self, parameters, context):
        kwargs = super().get_parameters(parameters, context)

        structure1 = self.parameterAsString(parameters, self.STRUCTURE1, context)
        kwargs['structure1'] = str_to_array(structure1, self._ndim)


        structure2 = self.parameterAsString(parameters, self.STRUCTURE2, context)
        kwargs['structure2'] = str_to_array(structure2, self._ndim)

        return kwargs
    
    
    def checkParameterValues(self, parameters, context): 
        dims = self.getDimsForCheck(parameters, context)

        structure = self.parameterAsString(parameters, self.STRUCTURE1, context)
        ok, s = check_structure(structure, dims)
        if not ok:
            s = self.tr("Could not parse structure 1 or dimensions do not match")
            return (ok, s)
        
        structure = self.parameterAsString(parameters, self.STRUCTURE2, context)
        ok, s = check_structure(structure, dims)
        if not ok:
            s = self.tr("Could not parse structure 2 or dimensions do not match")
            return (ok, s)
        
        return super().checkParameterValues(parameters, context)
    
    def createInstance(self):
        return SciPyBinaryHitMissAlgorithm()