# User-manual

The ScienceFlightPlanner Plugin helps in improving your workflow when planning scientific flight surveys.

The plugin consists of eight core features. Seven of them are represented with according buttons and one feature can be accessed via the selection box in the toolbar.

In addition to this help manual, you can find tutorial videos for using our plugin on our Youtube channel [ScienceFlightPlanner](https://www.youtube.com/channel/UCkSBaCW_Sohcqlh8Pu6tufg)

## Feature Overview

Feature name | Access via | Short description | Applicable to geometry type
---|---|---|---
Display Flight Distance |![](./resources/icon_distance.png)| Shows the length of the current flight plan in meters.| Line 
Display Flight Duration |![](./resources/icon_duration.png)| Shows the expected flight duration of the current flight plan in hours.| Line 
Generate Waypoints for Flight Plan |![](./resources/icon_file.png) | Generates a new shapefile which contains all waypoints (numbered from 1 to n) of the current flight plan. | Line 
Mark Selected Waypoints as Significant |![](./resources/icon_highlight.png) | Marks the selected waypoints of the current flight plan as significant. | Points 
Generate Reduced Flight Plan from Significant Waypoints |![](./resources/icon_labels.png) | Extracts waypoints of currently selected waypoints that were previously marked as significant to a new shapefile. | Points 
Reverse Waypoints |![](./resources/icon_reverse.png) | Reverses the order of current waypoints or flight plan. | Line, Points 
Show Coverage | Sensor selection box in toolbar | When a specific sensor is chosen, the current flight plan's coverage for this specific sensor and flight altitude is computed and saved to a new shapefile. | Line 
Compute Optimal Coverage Lines |![](./resources/icon_coverage_lines.png) | Given a sensor and an area of interest are selected, optimal flight lines are computed which coverage covers the selected area. | Polygon 

## Detailed feature description

### Display Flight Distance

![](./resources/icon_distance.png)

When the above button is pressed and a line layer is selected [(FAQ)](#faq), then the length (km) of the flight plan in this layer is shown. While activated, the display of the flight distance updates in accordance to changes in the layer/feature selection [(FAQ)](#faq). If the button is pressed again, the display of the length is toggled. Whether the tool is activated, is indicated by toggling the button.

### Display Expected Flight Duration

![](./resources/icon_duration.png)

When the above button is pressed and a line layer is selected [(FAQ)](#faq), the expected duration (h) for flying along the flight plan in this layer is shown. While activated, the display of the flight duration updates in accordance to changes in the layer/feature selection [(FAQ)](#faq). If the button is pressed again, the display of the duration is toggled. Whether the tool is activated, is indicated by toggling the button.

The used flight speed can be set in the plugin settings [(FAQ)](#faq) with a default speed set to 200km/h.

### Generate Waypoints for Flight Plan

![](./resources/icon_file.png)

When the above button is pressed and a line layer is selected [(FAQ)](#faq), all waypoints of this layer\'s flight plan are extracted. A waypoint is defined as each point in the flight path where the flight changes direction.

A window will pop up in which you can set the name and location of the shp-file in which the extracted waypoints will be stored as points.

### Mark Selected Waypoints as Significant

![](./resources/icon_highlight.png)

When the above button is pressed and some waypoints are selected [(FAQ)](#faq) they are marked as significant. This means a field \"sig\" is added to the attribute table of the points which you have to confirm.

Afterwards each significant point is marked with a little star.

### Generate Reduced Flight Plan from Significant Waypoints

![](./resources/icon_labels.png)

When the above button is pressed and waypoints in the current layer were previously marked as significant, i.e. the flight plan layer has the field \"sig\", as generated by [\"Mark selected Waypoints as Significant\"](#mark_sig), the waypoints chosen to be significant will be saved in a new shp-file. The points in the new shp-file have ids according to their position in the original flight plan.

In the following pop-up you can then select location and name of the new file.

### Reverse Waypoints

![](./resources/icon_reverse.png)

When the above button is pressed and a line layer or a layer containing waypoints is selected [(FAQ)](#faq) and the features have the field id, the order of the waypoints or the layer\'s flight plan is reversed.

_Example: If the starting point had number 1 and the end point number 30 and the waypoints are reversed, the original starting point will then be number 30 and the original end point number 1.__

### Show coverage

When a line layer is selected [(FAQ)](#faq) and a sensor in the sensor selection box of the plugin toolbar is selected, a new shp-file will be created containing the area which is covered by the flight plan in the layer for a specific flight altitude and the selected sensor.

Given a coverage shp-file has been created for the current flight plan and sensor, changing the flight altitude or the sensor settings results in an update of the corresponding coverage shp-file. The flight altitude can be changed in the flight altitude SpinBox in the plugin\'s toolbar. Sensors can be added, deleted or changed in the plugin settings
[(FAQ)](#faq).

Before this feature can be used, it is necessary to set the CRS used for coverage computations in the plugin settings. The CRS should be compatible with the region of the QGIS project.

### Compute Optimal Coverage Lines

![](./resources/icon_coverage_lines.png)

When the above button is pressed, optimal flight lines are computed given a sensor and a polygon, representing an area of interest, are selected. These lines can be used as a template for a flight plan over the area of interest which for the selected sensor has some amount of overlap with as few turns as possible.

The flight altitude can be changed in the flight altitude SpinBox in the toolbar and sensors can be added, deleted or changed in the plugin settings [(FAQ)](#faq).

The amount of overlap which is considered when creating the optimal flight lines can also be changed in the plugin settings. Overlap means how much adjacent coverage segments overlap each other (see example below).

0% overlap

![](./resources/overlap_0_percent.png)

50% overlap

![](./resources/overlap_50_percent.png)

Additionally, it is possible to use two different settings for the line computations. The default setting, which we strongly suggest to use, is called \"optimal\". In this case the lines are optimal w.r.t. the criteria described above. Choosing \"90° rotated\" means that the lines are 90° rotated from the optimal orientation. Therefore, they are no longer optimal but depending on the flight plan and use case this might still be useful.

In order to use this feature for the first time it is necessary to set the CRS used for coverage computations in the plugin settings. The CRS should be compatible with the region of the QGIS project.

## FAQ

#### What does it mean that some feature has to be selected?

This means, that either the feature is the only feature in the current layer or the feature is selected with the QGIS selection tool which can be found in the standard toolbar (\"Selection Toolbar\") or via \"Edit ▶Select\".

#### How can I select multiple features?

Especially when you want to mark multiple points as significant it is useful to select multiple points. To select multiple points, press and hold the \"CRTL\" key (on Mac: \"Command\" key) and click on the features you want to select.

#### Where can the plugin settings be found?

The plugin setting can be found under: \"Settings ▶ Options\... ▶ ScienceFlightPlanner\".\ There it is possible to change the flight speed, the CRS used for computing sensor coverage, the setting used for computing overlap and to add, delete or change sensors.

#### I\'ve activated the flight duration/distance display, how is it updated?

When the flight duration/distance display is activated (indicated by a toggled button of the corresponding feature) the distance/duration is updated in accordance to the current layer/feature selection. This means that when for example changing the layer to a different line layer, the distance/duration is updated to match the new layer. If the layer contains multiple features, it is required to explicitly select one feature for which the distance/duration is to be shown. Similarly, as for a new layer selection, a new feature selection within the current layer results in an update of the distance/duration. When a layer of a geometry other than line is selected, the display is toggled until a layer of type line is selected again.