from qgis.core import QgsProject


def are_layers_valid(layer_names):
    """
    Checks if all layers in the given list exist and are valid in the current QGIS project.
    Returns True if all layers exist and are valid, else False.
    :param layer_names: List of layer name strings
    """
    project = QgsProject.instance()
    for name in layer_names:
        layers = project.mapLayersByName(name)
        if not layers or not any(layer.isValid() for layer in layers):
            return False
    return True


def get_missing_or_invalid_layers(layer_names):
    """
    Returns a list of layer names that are missing or invalid in the current QGIS project.
    :param layer_names: List of layer name strings
    :return: List of missing or invalid layer names
    """
    project = QgsProject.instance()
    missing_or_invalid = []
    for name in layer_names:
        layers = project.mapLayersByName(name)
        if not layers or not any(layer.isValid() for layer in layers):
            missing_or_invalid.append(name)
    return missing_or_invalid
