
import os
import tempfile
from qgis.core import QgsProject, QgsApplication

def get_qgis_project_root():
    """
    Returns a safe writable directory for the QGIS plugin to store files.
    If a project is loaded, returns the project home path.
    Otherwise, returns a fallback writable directory (like QGIS user profile or temp folder).
    """
    project = QgsProject.instance()
    home_path = project.homePath()

    # Check if a valid project is loaded (homePath points to a writable folder)
    if home_path and os.path.isdir(home_path):
        try:
            test_file = os.path.join(home_path, ".__write_test__")
            with open(test_file, "w") as f:
                f.write("test")
            os.remove(test_file)
            return home_path  # ✅ Writable project directory
        except PermissionError:
            pass  # Fall back if not writable

    # 🧩 Fallback: QGIS user profile directory (writable)
    user_profile_path = QgsApplication.qgisSettingsDirPath()
    if user_profile_path and os.access(user_profile_path, os.W_OK):
        return user_profile_path

    # 🧩 Final fallback: system temp directory
    return tempfile.gettempdir()

