from qgis.core import (
    QgsVectorLayer,
    QgsFeature,
    QgsGeometry,
    QgsProject
)

# Create AOI/ROI layer (smaller extent)
aoi_layer = QgsVectorLayer('Polygon?crs=EPSG:4326', 'AOI_Layer', 'memory')
aoi_provider = aoi_layer.dataProvider()

# Create a smaller polygon for AOI
aoi_feature = QgsFeature()
aoi_geometry = QgsGeometry.fromWkt('POLYGON((70 10, 80 10, 80 20, 70 20, 70 10))')
aoi_feature.setGeometry(aoi_geometry)
aoi_provider.addFeature(aoi_feature)

# Create selected layer (larger extent)
selected_layer = QgsVectorLayer('Polygon?crs=EPSG:4326', 'Selected_Layer', 'memory')
selected_provider = selected_layer.dataProvider()

# Create a larger polygon that extends beyond AOI
selected_feature = QgsFeature()
selected_geometry = QgsGeometry.fromWkt('POLYGON((65 5, 85 5, 85 25, 65 25, 65 5))')
selected_feature.setGeometry(selected_geometry)
selected_provider.addFeature(selected_feature)

# Add layers to the project
QgsProject.instance().addMapLayer(aoi_layer)
QgsProject.instance().addMapLayer(selected_layer)

# Print extents to verify
print("AOI Layer extent:", aoi_layer.extent().toString())
print("Selected Layer extent:", selected_layer.extent().toString())

# Optional: Zoom to layers
iface.zoomToActiveLayer()
