# Sampling Time

## About Sampling Time
Sampling Time is a powerful QGIS plugin that revolutionizes spatial data collection by automating multiple sampling methods. Whether you're working in environmental studies, urban planning, or resource management, this tool streamlines your geospatial workflow through:

* Multiple sampling techniques (judgmental, random, systematic, stratified, and cluster)
* Customizable point generation with automated labeling
* Vector layer support with precise coordinate outputs
* Flexible exclusion zone definition
* Intuitive interface for both beginners and experts

The plugin enhances QGIS's capabilities by providing a comprehensive suite of sampling tools that adapt to diverse analytical needs while maintaining professional-grade functionality.

## Installation
Getting started with Sampling Time is straightforward:

1. Open QGIS
2. Navigate to Plugins > Manage and Install Plugins
3. Select the "All" tab
4. Search for "Sampling Time"
5. Click Install

Alternative manual installation:

1. Download the ZIP file from the [GitHub repository](https://github.com/MarcelGeoRGB/Sampling-Time-QGIS-Plugin)
2. In QGIS, go to Plugins > Manage and Install Plugins > Install from ZIP
3. Select the downloaded file
4. Complete the installation

*Note: You may need to restart QGIS after installation.*

## Using the Plugin
For detailed instructions and tutorials on using Sampling Time, visit our comprehensive guide at:
[Sampling Time User Guide](https://giscourse.online/qgis-sampling-time-plugin/)

## Website
Explore features, updates, and resources at our official website:
[Sampling Time Official Website](https://giscourse.online/qgis-sampling-time-plugin/)

## Documentation
Access our detailed documentation through:

* [Official Website Documentation](https://giscourse.online/qgis-sampling-time-plugin/)
* [GitHub Repository](https://github.com/MarcelGeoRGB/Sampling-Time-QGIS-Plugin)

## About the Author
Marcel A. Cedrez is a hydrogeologist with over a decade of experience in environmental studies and spatial analysis. His journey from field expertise to software development showcases his commitment to making geospatial tools more accessible. As an educator with thousands of teaching hours and over 140 video tutorials on GIS and spatial analysis, Marcel combines practical experience with innovative solutions to create tools that serve the GIS community.

## License
Sampling Time is distributed under the GNU General Public License version 3, ensuring free and open access to the software while protecting user freedoms.

## How to Cite
When using Sampling Time in your research, please use the following citation:

Cedrez, M. A. (2024). Sampling Time: A QGIS plugin for automating sampling techniques in geospatial analysis (Version 1.0). GitHub Plugin Repository. https://github.com/MarcelGeoRGB/Sampling-Time-QGIS-Plugin

---

*For support, feedback, or collaboration opportunities, contact: marcel.a@giscourse.online*