# -*- coding: utf-8 -*-

__author__ = 'Sanda Takeru'
__date__ = '2025-02-14'
__copyright__ = '(C) 2025 by Sanda Takeru'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from pathlib import Path
from PyQt5.QtGui import QIcon
from qgis.core import QgsProcessingProvider
from .sample_plot_survey_algorithm import SamplePlotSurveyAlgorithm, ReuseSurveyAlgorithm


class SamplePlotSurveyProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(ReuseSurveyAlgorithm())
        self.addAlgorithm(SamplePlotSurveyAlgorithm())
        
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Sample Plot Survey'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Sample Plot Survey')

    def icon(self):
        path = (Path(__file__).parent / "iconSPS2.svg").resolve()
        return QIcon(str(path))

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
