# sQlER – Visualisation ER à partir de SQL

sQlER est une extension QGIS qui permet de **coller ou charger des scripts SQL (DDL)**  
(`CREATE TABLE`, `FOREIGN KEY`, etc.) et de visualiser le schéma sous forme de **diagramme entité–relation interactif** :

- tables déplaçables à la souris,
- zoom et pan,
- marquage des clés primaires / étrangères,
- calcul de la cardinalité à partir des contraintes (`NOT NULL`, `UNIQUE`, PK),
- export du diagramme en **PNG**, **SVG** et **Draw.io** (`.drawio`),
- exécution du script SQL dans une base **SpatiaLite** (avec option de sauvegarde automatique).

> ⚠️ sQlER ne remplace pas DB Manager pour les manipulations lourdes :  
> c’est un outil de **visualisation, prototypage et petits scripts**.

---

## Fonctionnalités

### 1. Zone SQL

- Ouverture de fichiers `.sql` / `.txt`.
- Saisie et édition directe de scripts SQL.
- L’analyse est déclenchée automatiquement (avec un petit délai) après modification du texte.

Le parseur DDL reconnaît notamment :

- `CREATE TABLE … ( … )`
- clés primaires :
  - en ligne de colonne (`… PRIMARY KEY`),
  - au niveau de la table (`CONSTRAINT … PRIMARY KEY (…)`)
- clés étrangères :
  - inline (`col INTEGER REFERENCES other_table(id)`),
  - au niveau de la table (`CONSTRAINT fk … FOREIGN KEY (…) REFERENCES … (…)`),
  - `ALTER TABLE … ADD CONSTRAINT … FOREIGN KEY (…) REFERENCES … (…)`
- contraintes `NOT NULL`, `UNIQUE`, `DEFAULT`.

Il est conçu pour des DDL de type PostgreSQL / SQLite “classiques” ; certaines syntaxes exotiques peuvent ne pas être reconnues.

---

### 2. Diagramme ER interactif

La partie basse du dock affiche le diagramme :

- une **boîte** par table,
- une **ligne** par colonne,
- un symbole **🔑** pour les clés primaires, **#** pour les clés étrangères,
- des **flèches courbes** entre les colonnes PK / FK,
- la **cardinalité** (`1-1`, `0-1`, `1-N`, `0-N`) calculée à partir des contraintes du côté FK :
  - `UNIQUE` + `NOT NULL` → `1-1`
  - `UNIQUE` + nullable → `0-1`
  - non unique + `NOT NULL` → `1-N`
  - non unique + nullable → `0-N`

Interactions :

- zoom (molette de la souris),
- pan (clic maintenu et déplacement),
- déplacement des tables à la souris (les liens se mettent à jour).

---

### 3. Export du diagramme

Bouton **Exporter…** :

- **PNG…** : export du diagramme en image raster.
- **SVG…** : export en vectoriel, pratique pour insertion dans des présentations ou de la documentation.
- **DRAWIO…** : export en fichier `.drawio` (format diagrams.net / draw.io) :

  - chaque table est exportée sous forme de “table” avec une ligne par colonne,
  - les clés primaires / étrangères sont marquées,
  - les relations sont exportées en arêtes orthogonales,
  - la cardinalité est affichée sur la relation.

Le fichier `.drawio` peut ensuite être ouvert et retravaillé dans l’éditeur en ligne ou l’application de bureau.

---

### 4. Exécution du SQL dans une base SpatiaLite

Bouton **Appliquer dans SpatiaLite…** :

- **Vers une base SpatiaLite connectée…**
  - liste les bases SpatiaLite configurées dans QGIS (comme dans DB Manager),
  - l’utilisateur choisit une cible,
  - une **boîte de confirmation** apparaît, avec option de créer une sauvegarde (copie du fichier `.sqlite` avec suffixe personnalisé),
  - le script est exécuté sur la base choisie.

- **Vers un fichier SpatiaLite…**
  - ouvre un explorateur de fichiers pour choisir un `.sqlite` / `.db`,
  - même boîte de confirmation + possibilité de sauvegarde,
  - exécution du script sur le fichier sélectionné.

Détails techniques :

- le script est légèrement **normalisé pour SQLite** :
  - par exemple `FOREIGN KEY "col"` est réécrit en `FOREIGN KEY ("col")`,
- l’exécution se fait via le module Python `sqlite3`,
- le plugin tente de charger l’extension **`mod_spatialite`** :
  - si le chargement réussit, des instructions comme `AddGeometryColumn` peuvent fonctionner,
  - si le chargement échoue, le SQL “standard” fonctionnera, mais les fonctions SpatiaLite spécifiques pourront échouer.

---

## Installation

1. Copier le dossier `sQlER` dans le répertoire des extensions utilisateur de QGIS :
   - sous Windows :  
     `%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\sQlER`
2. Vérifier que les fichiers suivants existent :
   - `metadata.txt`
   - `__init__.py`
   - `plugin.py`
   - `dock.py`
   - `ddl_parser.py`
   - `erd_scene.py`
   - `icon.svg`
3. Lancer (ou relancer) QGIS.
4. Activer **sQlER** dans `Extensions → Gérer et installer les extensions`.

---

## Limitations

- Le parseur SQL ne couvre pas **toutes** les syntaxes possibles (types spécifiques, contraintes très avancées, etc.).
- Les bases de données **PostgreSQL** ne sont pas exécutées depuis sQlER : l’exécution est limitée aux **bases SQLite / SpatiaLite**.
- Le chargement de `mod_spatialite` dépend de la configuration de votre système et de QGIS :
  - si la DLL / SO n’est pas trouvée, les fonctions SpatiaLite pourront échouer.

---

## Licence

*(À compléter selon ton choix : par ex. GPL v3, MIT, etc.)*

---

# sQlER – ER diagrams from SQL

sQlER is a QGIS plugin that lets you **paste or load SQL DDL scripts**  
(`CREATE TABLE`, `FOREIGN KEY`, etc.) and visualize the schema as an **interactive entity–relationship diagram**:

- tables can be dragged with the mouse,
- zoom and pan,
- primary / foreign keys highlighted,
- cardinality computed from constraints (`NOT NULL`, `UNIQUE`, PK),
- export diagram as **PNG**, **SVG**, and **Draw.io** (`.drawio`),
- execute the SQL script on a **SpatiaLite** database (with optional backup).

> ⚠️ sQlER is **not** a full-featured DB manager.  
> It is meant for **visualisation, prototyping and small DDL/DML scripts**.

---

## Features

### 1. SQL editor

- Open `.sql` / `.txt` files.
- Edit SQL scripts directly in the dock widget.
- Parsing is triggered automatically (with a short delay) after edits.

The DDL parser understands, among others:

- `CREATE TABLE … ( … )`
- primary keys:
  - inline (`… PRIMARY KEY`),
  - table-level (`CONSTRAINT … PRIMARY KEY (…)`)
- foreign keys:
  - inline (`col INTEGER REFERENCES other_table(id)`),
  - table-level (`CONSTRAINT fk … FOREIGN KEY (…) REFERENCES … (…)`),
  - `ALTER TABLE … ADD CONSTRAINT … FOREIGN KEY (…) REFERENCES … (…)`
- `NOT NULL`, `UNIQUE`, `DEFAULT` constraints.

It is aimed at “standard” PostgreSQL / SQLite-style DDL; some exotic syntax may not be recognised.

---

### 2. Interactive ER diagram

The lower part of the dock displays the diagram:

- one **box** per table,
- one **row** per column,
- **🔑** marks primary keys, **#** marks foreign keys,
- **curved edges** between matching PK / FK columns,
- **cardinality** (`1-1`, `0-1`, `1-N`, `0-N`) computed from the FK-side constraints:
  - `UNIQUE` + `NOT NULL` → `1-1`
  - `UNIQUE` + nullable → `0-1`
  - non-unique + `NOT NULL` → `1-N`
  - non-unique + nullable → `0-N`

Interactions:

- zoom with mouse wheel,
- pan by dragging the canvas,
- move tables by dragging them (edges update automatically).

---

### 3. Diagram export

**Export…** button:

- **PNG…**: export as a raster image.
- **SVG…**: export as a vector image, ideal for documentation and slides.
- **DRAWIO…**: export as `.drawio` for diagrams.net / draw.io:

  - each table is exported as a “table” shape with one row per column,
  - PK / FK are marked,
  - relations are exported as orthogonal edges,
  - cardinality is displayed on the relation.

The `.drawio` file can then be opened and further edited in diagrams.net / draw.io.

---

### 4. Executing SQL on a SpatiaLite database

**Apply to SpatiaLite…** button:

- **To a connected SpatiaLite database…**
  - lists SpatiaLite connections configured in QGIS (same as DB Manager),
  - user chooses a target,
  - a **confirmation dialog** appears, with an option to create a backup (copy of the `.sqlite` file with a user-defined suffix),
  - the script is executed on the chosen database.

- **To a SpatiaLite file…**
  - opens a file chooser to select a `.sqlite` / `.db`,
  - same confirmation + optional backup,
  - script is executed on the selected file.

Technical details:

- the script is slightly **normalised for SQLite**:
  - e.g. `FOREIGN KEY "col"` is rewritten as `FOREIGN KEY ("col")`,
- execution uses Python’s `sqlite3` module,
- the plugin attempts to load the **`mod_spatialite`** extension:
  - if successful, SpatiaLite functions such as `AddGeometryColumn` can work,
  - if not, “plain” SQL will still work, but SpatiaLite-specific functions may fail.

---

## Installation

1. Copy the `sQlER` folder into your QGIS user plugins directory:
   - on Windows:  
     `%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\sQlER`
2. Ensure the following files are present:
   - `metadata.txt`
   - `__init__.py`
   - `plugin.py`
   - `dock.py`
   - `ddl_parser.py`
   - `erd_scene.py`
   - `icon.svg`
3. Start (or restart) QGIS.
4. Enable **sQlER** in `Plugins → Manage and Install Plugins`.

---

## Limitations

- The SQL parser does **not** cover every possible syntax (very advanced types, vendor-specific constructs, etc.).
- Only **SQLite / SpatiaLite** databases are executed from sQlER; PostgreSQL execution is out of scope.
- Loading `mod_spatialite` depends on your system and QGIS installation:
  - if the library cannot be loaded, SpatiaLite-specific functions may fail.

---

## License

*(To be defined – e.g. GPL v3, MIT, etc.)*