# -*- coding: utf-8 -*-

import os

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from .dock import SqlErDock


class SqlErPlugin:
    def __init__(self, iface):
        self.iface = iface
        self.action = None
        self.dock = None
        # dossier du plugin
        self.plugin_dir = os.path.dirname(__file__)

    def initGui(self):
        icon_path = os.path.join(self.plugin_dir, "icon.svg")
        icon = QIcon(icon_path) if os.path.exists(icon_path) else QIcon()

        self.action = QAction(icon, "sQlER – Diagramme ER SQL", self.iface.mainWindow())
        self.action.triggered.connect(self.toggle_dock)

        self.iface.addPluginToMenu("&sQlER", self.action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        if self.action:
            self.iface.removePluginMenu("&sQlER", self.action)
            self.iface.removeToolBarIcon(self.action)
            self.action = None

        if self.dock:
            self.iface.removeDockWidget(self.dock)
            self.dock.deleteLater()
            self.dock = None

    def toggle_dock(self):
        if self.dock is None:
            self.dock = SqlErDock(self.iface.mainWindow())
            self.dock.setAllowedAreas(
                Qt.LeftDockWidgetArea
                | Qt.RightDockWidgetArea
                | Qt.BottomDockWidgetArea
                | Qt.TopDockWidgetArea
            )
            self.iface.addDockWidget(Qt.BottomDockWidgetArea, self.dock)
            self.dock.show()
            self.dock.raise_()
            return

        if self.dock.isVisible():
            self.dock.hide()
        else:
            self.dock.show()
            self.dock.raise_()