# -*- coding: utf-8 -*-

"""
/***************************************************************************
 S2Toolkit
                                 A QGIS plugin
 Tools for the S2 Geometry.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-02
        copyright            : (C) 2024 by Mikhail Melnikov, Oleg Petrov
        email                : support@ibtgeo.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Mikhail Melnikov, Oleg Petrov'
__date__ = '2024-05-02'
__copyright__ = '(C) 2024 by Mikhail Melnikov, Oleg Petrov'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessingProvider
from .s2toolkit_algorithm import (S2Toolkit_fromLayerExtent,
                                  S2Toolkit_fromFeatureExtents,
                                  S2Toolkit_fromGeometry)
from . import resources
import os
pluginPath = os.path.dirname(__file__)

class S2ToolkitProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)
    
    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(S2Toolkit_fromLayerExtent())
        # add additional algorithms here
        self.addAlgorithm(S2Toolkit_fromGeometry())
        self.addAlgorithm(S2Toolkit_fromFeatureExtents())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'S2 Toolkit'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('S2 Toolkit')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(pluginPath, "logo.png"))

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
