# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

import resources

class ManagerPlugin:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface
	
	def initGui(self):
		# Create action that will start plugin configuration
		self.action = QAction(QIcon(":/icons/rt_sql-layer.png"), "RT Sql Layer", self.iface.mainWindow())
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)
	
		# Add toolbar button and menu item
		self.iface.addToolBarIcon(self.action)
		if hasattr( self.iface, 'addPluginToDatabaseMenu' ):
			self.iface.addPluginToDatabaseMenu("&PG and SL", self.action)
		else:
			self.iface.addPluginToMenu("&PG and SL", self.action)
	
	def unload(self):
		# Remove the plugin menu item and icon
		if hasattr( self.iface, 'removePluginDatabaseMenu' ):
			self.iface.removePluginDatabaseMenu("&PG and SL", self.action)
		else:
			self.iface.removePluginMenu("&PG and SL", self.action)
		self.iface.removeToolBarIcon(self.action)
	
	def run(self):
		return self.runWithSettings()

	def runWithSettings(self, parent=None):
		from DbConnection import ConnectionManager
		if not ConnectionManager.initConnectionSupport():
			modules = ", ".join( map(lambda x: u"'%s'" % x[1], ConnectionManager.MISSED_CONNECTORS) )
			QMessageBox.information(self.iface.mainWindow(), "hey", "Couldn't import Python modules %s for communication with databases. Without it you won't be able to run RT Sql Layer. Please install it." % modules )
			return

		from ManagerWindow import ManagerWindow
		self.dlg = ManagerWindow(True, parent, ManagerWindow.ModeReadOnly | ManagerWindow.ModeSimplified, self.iface)
		self.dlg.show()

