# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.gui import *
from qgis.core import *

import Utils
from ui.WizPage4_ui import Ui_WizardPage

class WizardPage(QWizardPage, Ui_WizardPage):
	
	def __init__(self, iface, wizState):
		QWizardPage.__init__(self)
		self.iface = iface
		self.wizState = wizState

		self.setupUi(self)

		self.connect(self.outputDirButton, SIGNAL("clicked()"), self.fillOutputDirEdit)
		self.connect(self.outputDirEdit, SIGNAL("textChanged(const QString &)"), SIGNAL( "completeChanged()" ) )
		self.connect(self.prefixCheck, SIGNAL("toggled(bool)"), SIGNAL( "completeChanged()" ) )
		self.connect(self.prefixEdit, SIGNAL("textChanged(const QString &)"), SIGNAL( "completeChanged()" ) )

	def fillOutputDirEdit(self):
		outputDir = QFileDialog.getExistingDirectory( self, self.tr( "Select where to save the output" ), Utils.getLastUsedDir() )
		if outputDir.isEmpty():
			return

		Utils.setLastUsedDir(outputDir)
		self.outputDirEdit.setText( outputDir )

	def validatePage(self):
		self.wizState.outputDir = self.outputDirEdit.text()
		self.wizState.outputFilePrefix = self.prefixEdit.text() if self.prefixCheck.isChecked() else None
		return True

	def isComplete(self):
		return not ( self.outputDirEdit.text().isEmpty() or ( self.prefixCheck.isChecked() and self.prefixEdit.text().isEmpty() ) )
