# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.gui import *
from qgis.core import *

from Utils import QueryUtils
from DatabaseModel import TableItem, SchemaItem, SqlItem, DatabaseModel
import postgis_utils

from ui.WizPage3_ui import Ui_WizardPage

class WizardPage(QWizardPage, Ui_WizardPage):
	
	def __init__(self, iface, wizState):
		QWizardPage.__init__(self)
		self.iface = iface
		self.canvas = self.iface.mapCanvas()
		self.wizState = wizState

		self.setupUi(self)

		self.tablesSelector.setMode(self.tablesSelector.MultiSelection, postgis_utils.Table.FILTER_GEOM_TABLES, False)
		self.connect( self.tablesSelector, SIGNAL("tablesSelectionChanged()"), SIGNAL("completeChanged()") )

	def onClosing(self):
		# close the connection to the database
		self.tablesSelector.setDatabase(None)


	def initializePage(self):
		# fill defaults
		self.tablesSelector.fillConnectionCombo()

		currentConnection, db = self.wizState.cuttingArchiveDb
		if currentConnection:
			self.tablesSelector.setCurrentConnection(currentConnection)
		if db:
			self.tablesSelector.setDatabase(db)


	def validatePage(self):
		QApplication.setOverrideCursor(QCursor(Qt.WaitCursor))

		self.wizState.archiveToCutLayers = []
		db = self.tablesSelector.db
		inSrid = self.wizState.srid

		diffSridTables = []
		for row in self.tablesSelector.selectedTables:

			if isinstance(row, TableItem):
				schema = row.schema().name
				table =  row.name

				geom = row.geom_column
				geomtype = QString(row.geom_type).toUpper()
				dim = row.geom_dim
				srid = row.geom_srid if row.geom_srid > 0 else -1

				_srid, _geomtype, _dim = QueryUtils.getSridAndGeomType(db, db._table_name(schema, table), geom)
				if geomtype == 'GEOMETRY' and \
						_geomtype != None and _geomtype != 'GEOMETRY':
					geomtype = _geomtype

				if dim >= 3 or _dim >= 3:
					geomtype += '25D'

				if srid < 0 and _srid > 0:
					srid = _srid

				tablename = db._table_name(schema, table)

				self.wizState.archiveToCutLayers.append( (schema, table, geom, None, geomtype) )

			elif isinstance(row, SqlItem):
				query = row.name

				geom = row.geom_column
				srid, geomtype, dim = QueryUtils.getSridAndGeomType(db, query, geom)

				if dim >= 3:
					geomtype += '25D'

				tablename = '"%s" (%s)' % ( query, geom )

				self.wizState.archiveToCutLayers.append( (None, None, geom, query, geomtype) )
			else:
				return False

			# manage the qgis default CRS 
			if srid < 0 and self.wizState.cuttingArchiveMode != self.wizState.CUTTING_POSTGRES and inSrid == 4326:
				self.wizState.srid = inSrid = -1

			# test if the selected table have the same SRID of the cutting archive
			if ( inSrid < 0 and srid > 0 ) or ( inSrid > 0 and inSrid != srid ):
				diffSridTables.append( tablename )
				#print "DIFFERENT SRID", tablename, "in:", inSrid, "out:", srid


		if len(diffSridTables) > 0:
			QApplication.restoreOverrideCursor()
			QMessageBox.warning( self, self.tr( "Different SRIDs" ), self.tr( "The following tables have different SRIDs from the intersecting archive one: \n%1" ).arg( "\n".join(diffSridTables) ) )
			return False

		self.wizState.archiveToCutDb = (self.tablesSelector.currentConnection, db)

		QApplication.restoreOverrideCursor()
		return True

	def isComplete(self):
		return len(self.tablesSelector.selectedTables) > 0

