# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

import qgis.gui
import qgis.core

from DlgAbout import DlgAbout

from WizPage1 import WizardPage as CuttingArchiveWizPage
from WizPage2 import WizardPage as BufferOutputWizPage
from WizPage3 import WizardPage as ArchiveToCutWizPage
from WizPage4 import WizardPage as SelectOutputWizPage
from WizPage5 import WizardPage as ProgressExecWizPage

class Wizard(QWizard):
	
	def __init__(self, parent=None, iface=None):
		QWizard.__init__(self, parent, Qt.Window)
		self.setModal(True)
		self.iface = iface
		self.wizState = WizardState()

		self.setupUi()
		self.setOptions( QWizard.IndependentPages | QWizard.HaveHelpButton | QWizard.DisabledBackButtonOnLastPage )
		self.setButtonText( QWizard.HelpButton, "About" )

		self.connect(self, SIGNAL("rejected()"), self.onClosing)
		self.connect(self, SIGNAL("accepted()"), self.onClosing)
		self.connect(self, SIGNAL("helpRequested()"), self.about)

	# reimplemented - virtual void changeEvent( QEvent * event )
	def changeEvent(self, event):
		QWizard.changeEvent(self, event)
		if event.type() == QEvent.WindowStateChange:
			parent = self.parentWidget()
			if self.windowState() & Qt.WindowMinimized:
				parent.setWindowState(parent.windowState() | Qt.WindowMinimized)
			else:
				parent.setWindowState(parent.windowState() & ~Qt.WindowMinimized)

	def onClosing(self):
		for p in self.pages:
			if hasattr(p, "onClosing"):
				p.onClosing()

	def about(self):
		DlgAbout(self).exec_()

	def setupUi(self):
		self.setWindowTitle("RT Postgres Extractor")
		self.setWindowIcon(QIcon(":/icons/rt_postgres_extractor.png"))

		self.pages = []
		wizPagesList = [CuttingArchiveWizPage, BufferOutputWizPage, ArchiveToCutWizPage, SelectOutputWizPage, ProgressExecWizPage]
		for wizPage in wizPagesList:
			wizPage = wizPage( self.iface, self.wizState )
			self.addPage( wizPage )
			self.pages.append( wizPage )

		self.resize(QSize(100,100).expandedTo(self.minimumSizeHint()))

class WizardState:
	CUTTING_POSTGRES, CUTTING_LAYER, CUTTING_DRAWN = range(3)
	OUT_FORMAT_SHAPEFILE, OUT_FORMAT_KML, OUT_FORMAT_SPATIALITE, OUT_FORMAT_GML3 = range(4)
	EXPORT_AFTER_CUT, EXPORT_WITHOUT_CUT = range(2)

	def __init__(self):
		self.cuttingArchiveMode = None
		self.cuttingArchiveModeName = None
		self.cuttingArchiveDb = None
		self.cuttingArchiveLayer = None
		self.cuttingArchiveTitle = None
		self.srid = -1

		self.cuttingBuffer = None
		self.outputFormat = None
		self.exportOptions = None

		self.archiveToCutDb = None
		self.archiveToCutLayers = None

		self.outputDir = None
		self.outputFilePrefix = None
