# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.gui import *
from qgis.core import *

from ui.WizPage2_ui import Ui_WizardPage

class WizardPage(QWizardPage, Ui_WizardPage):
	
	def __init__(self, iface, wizState):
		QWizardPage.__init__(self)
		self.iface = iface
		self.wizState = wizState

		self.setupUi(self)

		self.connect(self.outputFormatCombo, SIGNAL("currentIndexChanged(int)"), self.outputFormatChanged)

	def outputFormatChanged(self, index):
		if index == 3:
			QMessageBox.warning( self, self.tr( "Feature disabled" ), self.tr( "The selected output format is not supported yet." ) ) 
		self.emit( SIGNAL( "completeChanged()" ) )

	def validatePage(self):
		self.wizState.cuttingBuffer = self.cuttingBufferDSpin.value() if self.enableBufferCheck.isChecked() else None
		self.wizState.outputFormat = self.outputFormatCombo.currentIndex()
		self.wizState.exportOptions = self.wizState.EXPORT_AFTER_CUT if self.cutExportRadio.isChecked() else self.wizState.EXPORT_WITHOUT_CUT
		return True

	def isComplete(self):
		return not (self.outputFormatCombo.currentIndex() < 0 or self.outputFormatCombo.currentIndex() > 2) 
