# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.gui import *
from qgis.core import *

from DlgDbError import DlgDbError
import postgis_utils

from Utils import QueryUtils
from ui.CustomQuery_ui import Ui_CustomQuery

class CustomQuery(QGroupBox, Ui_CustomQuery):
	
	def __init__(self, parent = None):
		QGroupBox.__init__(self, parent)
		self.setupUi(self)

		self.setDatabase(None)

		self.connect(self.getColumnsBtn, SIGNAL("clicked()"), self.fillColumnsCombo)
		self.connect(self.geomCombo, SIGNAL("editTextChanged(const QString &)"), self.allFieldsFilled)
		self.connect(self.uniqueCombo, SIGNAL("editTextChanged(const QString &)"), self.allFieldsFilled)
		self.connect(self.queryEditor, SIGNAL("textChanged()"), self.allFieldsFilled)

	def showUniqueColumn(self, value=True):
		self.uniqueLabel.setVisible(value)
		self.uniqueCombo.setVisible(value)

	def setDatabase(self, db):
		self.db = db
		self.setEnabled(self.db != None)
		self.allFieldsFilled()

	def allFieldsFilled(self):
		query = self.getQuery()
		enabler = not (self.db == None or query.isEmpty() or self.getGeomCol().isEmpty() )
		if self.uniqueCombo.isVisible():
			enabler &= not self.getUniqueCol.isEmpty()
		enabler &= query.contains( QRegExp( "^SELECT\\s*", Qt.CaseInsensitive) )

		self.emit( SIGNAL("completed(bool)"), enabler)

	def fillColumnsCombo(self):
		if not self.db:
			return

		QApplication.setOverrideCursor(QCursor(Qt.WaitCursor))

		# retrieve the columns in the query result
		query = self.queryEditor.toPlainText()
		try:
			geomCols, uniqueCols = QueryUtils.getGeomAndUniqueFields(self.db, query)

		except postgis_utils.DbError, e:
			QApplication.restoreOverrideCursor()
			DlgDbError.showError(e, self)
			return

		except QueryUtils.DuplicatedFieldsError, e:
			QApplication.restoreOverrideCursor()
			QErrorMessage(self).showMessage( e.msg.replace("\n", "<br>") )
			return

		# fill both the geometry and the unique combo
		geomCols = map(lambda x: x.name(), geomCols)
		geomCols.sort()
		self.geomCombo.clear()
		self.geomCombo.addItems( geomCols )

		uniqueCols = map(lambda x: x.name(), uniqueCols)
		uniqueCols.sort()
		self.uniqueCombo.clear()
		self.uniqueCombo.addItems( uniqueCols )


		QApplication.restoreOverrideCursor()

	def getQuery(self):
		query = self.queryEditor.toPlainText()
		return QueryUtils.sanitizeQuery( query )

	def getUniqueCol(self):
		return self.uniqueCombo.currentText()

	def getGeomCol(self):
		return self.geomCombo.currentText()

	def getQueryAndCols(self):
		return ( unicode(self.getQuery()), unicode(self.getGeomCol()), unicode(self.getUniqueCol()) if self.uniqueCombo.isVisible() else None )

