# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

import resources

class ManagerPlugin:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface
	
	def initGui(self):
		# Create action that will start plugin configuration
		self.action = QAction(QIcon(":/icons/rt_postgres-extractor.png"), "RT Postgres Extractor", self.iface.mainWindow())
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)
	
		# Add toolbar button and menu item
		self.iface.addToolBarIcon(self.action)
		if hasattr( self.iface, 'addPluginToDatabaseMenu' ):
			self.iface.addPluginToDatabaseMenu("&PostGIS", self.action)
		else:
			self.iface.addPluginToMenu("&PostGIS", self.action)
	
	def unload(self):
		# Remove the plugin menu item and icon
		if hasattr( self.iface, 'removePluginDatabaseMenu' ):
			self.iface.removePluginDatabaseMenu("&PostGIS", self.action)
		else:
			self.iface.removePluginMenu("&PostGIS", self.action)
		self.iface.removeToolBarIcon(self.action)
	
	def run(self):
		try:
			import psycopg2
		except ImportError, e:
			QMessageBox.information(self.iface.mainWindow(), "hey", "Couldn't import Python module 'psycopg2' for communication with PostgreSQL database. Without it you won't be able to run RT Postgres Extractor. Please install it.")
			return

		from Wizard import Wizard
		self.dlg = Wizard(self.iface.mainWindow(), self.iface)
		self.dlg.exec_()

