DROP TABLE IF EXISTS SCHEDA_UNITA_VOLUMETRICA;
DROP TABLE IF EXISTS ZZ_MORFOLOGIA_COPERTURA;
DROP TABLE IF EXISTS SCHEDA_EDIFICIO;
DROP TABLE IF EXISTS RIFERIMENTI_CATASTALI;
DROP TABLE IF EXISTS LOCALIZZAZIONE_EDIFICIO;
DROP TABLE IF EXISTS ZZ_PROVINCE;
DROP TABLE IF EXISTS ZZ_COMUNI;
DROP TABLE IF EXISTS GEOMETRIE_UNITA_VOLUMETRICHE_ORIGINALI_DI_PARTENZA;
DROP TABLE IF EXISTS INDIRIZZO_VIA;
DROP TABLE IF EXISTS GEOMETRIE_RILEVATE_NUOVE_O_MODIFICATE;
DROP TABLE IF EXISTS ZZ_NORMATIVA_SISMICA;
DROP TABLE IF EXISTS ZZ_QUALITA_INFORMAZIONE;
DROP TABLE IF EXISTS INTERVENTO_EDIFICIO;
DROP TABLE IF EXISTS ZZ_TIPO_INTERVENTO;
DROP TABLE IF EXISTS ZZ_POSIZIONE_EDIFICIO_AGGREGATO;
DROP TABLE IF EXISTS ZZ_TIPOLOGIA_EDILIZIA;
DROP TABLE IF EXISTS ZZ_FRUIZIONE_TEMPORALE;
DROP TABLE IF EXISTS ZZ_STATO_EDIFICIO;
DROP TABLE IF EXISTS STATO_UTILIZZO_EDIFICIO;
DROP TABLE IF EXISTS ZZ_STATO_GEOMETRIA;
DROP TABLE IF EXISTS ZZ_CATEGORIA_USO_PREVALENTE;
DROP TABLE IF EXISTS ZZ_CATEGORIA_USO_PIANO_TERRA;
DROP TABLE IF EXISTS ZZ_CATEGORIA_USO_ALTRI_PIANI;
DROP TABLE IF EXISTS ZZ_PROPRIETA;
DROP TABLE IF EXISTS CATEGORIA_USO_PREVALENTE_STATO_UTILIZZO_EDIFICIO;
DROP TABLE IF EXISTS CATEGORIA_USO_PIANO_TERRA_STATO_UTILIZZO_EDIFICIO;
DROP TABLE IF EXISTS CATEGORIA_USO_ALTRI_PIANI_STATO_UTILIZZO_EDIFICIO;
DROP TABLE IF EXISTS STRUTTURE_PORTANTI_VERTICALI;
DROP TABLE IF EXISTS ZZ_TIPOLOGIA_COSTRUTTIVA;
DROP TABLE IF EXISTS ZZ_STATO_CONSERVAZIONE_STRUTTURALE;
DROP TABLE IF EXISTS TIPOLOGIA_COSTRUTTIVA_CARATTERISTICA_STRUTTURALE;
DROP TABLE IF EXISTS ZZ_APPARECCHIATURA_MURARIA;
DROP TABLE IF EXISTS ZZ_INCATENAMENTI;
DROP TABLE IF EXISTS ZZ_TAMPONATURE_DISTRIBUZIONE;
DROP TABLE IF EXISTS ZZ_TAMPONATURE_TIPOLOGIA;
DROP TABLE IF EXISTS ZZ_TAMPONATURE_PRESENZA_PIANO_DEBOLE;
DROP TABLE IF EXISTS STRUTTURE_ORIZZONTALI_SOLAI;
DROP TABLE IF EXISTS ZZ_TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTE;
DROP TABLE IF EXISTS RILEVATORE;
DROP TABLE IF EXISTS TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTE_STRUTTURE_ORIZZONTALI_SOLAI;
DROP TABLE IF EXISTS STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_ORDINARI;
DROP TABLE IF EXISTS ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_ORDINARI;
DROP TABLE IF EXISTS ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURA;
DROP TABLE IF EXISTS ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARI;
DROP TABLE IF EXISTS ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_GRANDI_LUCI;
DROP TABLE IF EXISTS STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_GRANDI_LUCI;
DROP TABLE IF EXISTS ZZ_MATERIALE_COPERTURA_EDIFICI_GRANDI_LUCI;
DROP TABLE IF EXISTS ZZ_TIPO_MANTO_COPERTURA;
DROP TABLE IF EXISTS MANTO_COPERTURA_UNITA_VOLUMETRICA;
DROP TABLE IF EXISTS ZZ_STATO_CONSERVAZIONE_MANTO;
DROP TABLE IF EXISTS ZZ_PROSPETTO_PREVALENTE;
DROP TABLE IF EXISTS CARATTERISTICHE_ARCHITETTONICHE_EDIFICIO;
DROP TABLE IF EXISTS ZZ_TIPO_PARAMENTI_ARCHITETTONICI;
DROP TABLE IF EXISTS ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO;
DROP TABLE IF EXISTS PARAMENTI;
DROP TABLE IF EXISTS ZZ_TIPO_PARAMENTI_ARCHITETTONICI_PARAMENTI;
DROP TABLE IF EXISTS BALCONI;
DROP TABLE IF EXISTS ZZ_TIPO_BALCONI;
DROP TABLE IF EXISTS OSCURAMENTI;
DROP TABLE IF EXISTS ZZ_TIPO_OSCURAMENTI;
DROP TABLE IF EXISTS ZZ_TIPO_OSCURAMENTI_OSCURAMENTI;
DROP TABLE IF EXISTS ZZ_TIPO_INFISSI;
DROP TABLE IF EXISTS INFISSI;
DROP TABLE IF EXISTS ZZ_TIPO_INFISSI_INFISSI;
DROP TABLE IF EXISTS ZZ_TIPO_GRONDA;
DROP TABLE IF EXISTS GRONDA;
DROP TABLE IF EXISTS ZZ_TIPO_ELEMENTI_DECORATIVI;
DROP TABLE IF EXISTS ELEMENTI_DECORATIVI;
DROP TABLE IF EXISTS ZZ_TIPO_ELEMENTI_DECORATIVI_ELEMENTI_DECORATIVI;
DROP TABLE IF EXISTS ZZ_TIPO_SUPERFETAZIONI;
DROP TABLE IF EXISTS SUPERFETAZIONI_INCONGRUENZE;
DROP TABLE IF EXISTS ZZ_TIPO_SUPERFETAZIONI_SUPERFETAZIONI;
DROP TABLE IF EXISTS ZZ_TIPO_BALCONI_BALCONI;
DROP TABLE IF EXISTS ZZ_TIPO_GRONDA_GRONDA;
DROP TABLE IF EXISTS FOTO_GEOREF;
DROP TABLE IF EXISTS ZZ_FRONTE_EDIFICIO;
DROP TABLE IF EXISTS NUMERI_CIVICI;
DROP TABLE IF EXISTS LOCALIZZAZIONE_EDIFICIO_INDIRIZZO_VIA;
DROP TABLE IF EXISTS ZZ_DISCLAIMER;
DROP TABLE IF EXISTS RIFERIMENTI_CATASTALI_SCHEDA_EDIFICIO;
DROP TABLE IF EXISTS ZZ_WMS;
DROP TABLE IF EXISTS NOTE_STORICHE_EDIFICIO;
CREATE TABLE SCHEDA_UNITA_VOLUMETRICA (ID_SCHEDA_UV varchar(60) NOT NULL, INTERR_NPIANI integer(5) NOT NULL, FUORITERR_NPIANI integer(5) NOT NULL, ZZ_MORFOLOGIA_COPERTURAID integer(10) NOT NULL, GEOMETRIE_RILEVATE_NUOVE_O_MODIFICATEID_UV_NEW varchar(60) NOT NULL, SCHEDA_EDIFICIOID varchar(60) NOT NULL, STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_ORDINARIID varchar(60), STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_GRANDI_LUCIID varchar(60), MANTO_COPERTURA_UNITA_VOLUMETRICAID varchar(60) NOT NULL, ALTEZZA_VOLUME float(15), PRIMARY KEY (ID_SCHEDA_UV), FOREIGN KEY(ZZ_MORFOLOGIA_COPERTURAID) REFERENCES ZZ_MORFOLOGIA_COPERTURA(ID), FOREIGN KEY(GEOMETRIE_RILEVATE_NUOVE_O_MODIFICATEID_UV_NEW) REFERENCES GEOMETRIE_RILEVATE_NUOVE_O_MODIFICATE(ID_UV_NEW), FOREIGN KEY(SCHEDA_EDIFICIOID) REFERENCES SCHEDA_EDIFICIO(ID), FOREIGN KEY(STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_ORDINARIID) REFERENCES STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_ORDINARI(ID), FOREIGN KEY(STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_GRANDI_LUCIID) REFERENCES STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_GRANDI_LUCI(ID), FOREIGN KEY(MANTO_COPERTURA_UNITA_VOLUMETRICAID) REFERENCES MANTO_COPERTURA_UNITA_VOLUMETRICA(ID));
CREATE TABLE ZZ_MORFOLOGIA_COPERTURA (ID  INTEGER NOT NULL PRIMARY KEY, DESCRIZIONE varchar(150) NOT NULL);
CREATE TABLE SCHEDA_EDIFICIO (ID varchar(60) NOT NULL, DATA_COMPILAZIONE_SCHEDA varchar(20) NOT NULL, LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ varchar(60) NOT NULL, STATO_UTILIZZO_EDIFICIOID varchar(60) NOT NULL, ZZ_PROPRIETAID integer(10) NOT NULL, NUM_UNITA_IMMOBILIARI integer(10), INIZIO_EPOCA_COSTRUTTIVA varchar(10) NOT NULL, FINE_EPOCA_COSTRUTTIVA varchar(10), ZZ_QUALITA_INFORMAZIONE_EPOCA_COSTRUTTIVAID integer(10) NOT NULL, STRUTTURE_PORTANTI_VERTICALIID varchar(60) NOT NULL, RILEVATOREID varchar(20) NOT NULL, CARATTERISTICHE_ARCHITETTONICHE_EDIFICIOID varchar(60), NOME_EDIFICIO varchar(255), NOTA_STORICA varchar(3000), PRIMARY KEY (ID), FOREIGN KEY(LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ) REFERENCES LOCALIZZAZIONE_EDIFICIO(IDLOCALIZZ), FOREIGN KEY(STATO_UTILIZZO_EDIFICIOID) REFERENCES STATO_UTILIZZO_EDIFICIO(ID), FOREIGN KEY(ZZ_PROPRIETAID) REFERENCES ZZ_PROPRIETA(ID), FOREIGN KEY(STRUTTURE_PORTANTI_VERTICALIID) REFERENCES STRUTTURE_PORTANTI_VERTICALI(ID), FOREIGN KEY(RILEVATOREID) REFERENCES RILEVATORE(ID), FOREIGN KEY(CARATTERISTICHE_ARCHITETTONICHE_EDIFICIOID) REFERENCES CARATTERISTICHE_ARCHITETTONICHE_EDIFICIO(ID), FOREIGN KEY(ZZ_QUALITA_INFORMAZIONE_EPOCA_COSTRUTTIVAID) REFERENCES ZZ_QUALITA_INFORMAZIONE(ID));
CREATE TABLE RIFERIMENTI_CATASTALI (IDREF_CATAST varchar(60) NOT NULL, FOGLIO varchar(5) NOT NULL, PARTICELLA varchar(5) NOT NULL, PRIMARY KEY (IDREF_CATAST));
CREATE TABLE LOCALIZZAZIONE_EDIFICIO (IDLOCALIZZ varchar(60) NOT NULL, EDIFICIO_ISOLATO integer(1) NOT NULL, ZZ_POSIZIONE_EDIFICIO_AGGREGATOID integer(10) NOT NULL, PRIMARY KEY (IDLOCALIZZ), FOREIGN KEY(ZZ_POSIZIONE_EDIFICIO_AGGREGATOID) REFERENCES ZZ_POSIZIONE_EDIFICIO_AGGREGATO(ID));
CREATE TABLE ZZ_PROVINCE (ISTATPROV varchar(5) NOT NULL, NOME varchar(50) NOT NULL, PRIMARY KEY (ISTATPROV));
CREATE TABLE ZZ_COMUNI (ISTATCOM varchar(8) NOT NULL, NOME varchar(128) NOT NULL, ZZ_PROVINCEISTATPROV varchar(5) NOT NULL, PRIMARY KEY (ISTATCOM), FOREIGN KEY(ZZ_PROVINCEISTATPROV) REFERENCES ZZ_PROVINCE(ISTATPROV));
CREATE TABLE GEOMETRIE_UNITA_VOLUMETRICHE_ORIGINALI_DI_PARTENZA (CODICE varchar(50) NOT NULL, PRIMARY KEY (CODICE));
CREATE TABLE INDIRIZZO_VIA (ID_INDIRIZZO varchar(60) NOT NULL, VIA varchar(250) NOT NULL, ZZ_COMUNIISTATCOM varchar(8) NOT NULL, ID_ESTERNO varchar(60), SOURCE varchar(30) DEFAULT 'MANUALE' NOT NULL, TIPO varchar(20) DEFAULT 'EDITABILE' NOT NULL, PRIMARY KEY (ID_INDIRIZZO), FOREIGN KEY(ZZ_COMUNIISTATCOM) REFERENCES ZZ_COMUNI(ISTATCOM));
CREATE TABLE GEOMETRIE_RILEVATE_NUOVE_O_MODIFICATE (ID_UV_NEW varchar(60) NOT NULL, GEOMETRIE_UNITA_VOLUMETRICHE_ORIGINALI_DI_PARTENZACODICE varchar(50), ZZ_STATO_GEOMETRIAID integer(10) NOT NULL, ABBINATO_A_SCHEDA integer(1) DEFAULT 0 NOT NULL, NOTA varchar(1000), PRIMARY KEY (ID_UV_NEW), FOREIGN KEY(GEOMETRIE_UNITA_VOLUMETRICHE_ORIGINALI_DI_PARTENZACODICE) REFERENCES GEOMETRIE_UNITA_VOLUMETRICHE_ORIGINALI_DI_PARTENZA(CODICE), FOREIGN KEY(ZZ_STATO_GEOMETRIAID) REFERENCES ZZ_STATO_GEOMETRIA(ID));
CREATE TABLE ZZ_NORMATIVA_SISMICA (ID integer(10) NOT NULL, DESCRIZIONE varchar(150) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_QUALITA_INFORMAZIONE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE INTERVENTO_EDIFICIO (ID varchar(60) NOT NULL, ANNO_PROGETTAZIONE integer(4), ZZ_QUALITA_INFORMAZIONEID integer(10) NOT NULL, DESCRIZ_INTERV varchar(2000), TITOLO_ABILITATIVO varchar(60), DATA_TITOLO_ABILITATIVO varchar(15), INTERVENTO_IN_CORSO integer(1) NOT NULL, ZZ_TIPO_INTERVENTOID integer(10) NOT NULL, ZZ_NORMATIVA_SISMICAID integer(10), SCHEDA_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_QUALITA_INFORMAZIONEID) REFERENCES ZZ_QUALITA_INFORMAZIONE(ID), FOREIGN KEY(ZZ_TIPO_INTERVENTOID) REFERENCES ZZ_TIPO_INTERVENTO(ID), FOREIGN KEY(ZZ_NORMATIVA_SISMICAID) REFERENCES ZZ_NORMATIVA_SISMICA(ID), FOREIGN KEY(SCHEDA_EDIFICIOID) REFERENCES SCHEDA_EDIFICIO(ID));
CREATE TABLE ZZ_TIPO_INTERVENTO (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_POSIZIONE_EDIFICIO_AGGREGATO (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TIPOLOGIA_EDILIZIA (ID varchar(4) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_FRUIZIONE_TEMPORALE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_STATO_EDIFICIO (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE STATO_UTILIZZO_EDIFICIO (ID varchar(60) NOT NULL, ZZ_FRUIZIONE_TEMPORALEID integer(10), ZZ_STATO_EDIFICIOID integer(10) NOT NULL, ZZ_TIPOLOGIA_EDILIZIAID varchar(4) NOT NULL, DESCRIZIONE_VISIVA varchar(1000), PRIMARY KEY (ID), FOREIGN KEY(ZZ_FRUIZIONE_TEMPORALEID) REFERENCES ZZ_FRUIZIONE_TEMPORALE(ID), FOREIGN KEY(ZZ_STATO_EDIFICIOID) REFERENCES ZZ_STATO_EDIFICIO(ID), FOREIGN KEY(ZZ_TIPOLOGIA_EDILIZIAID) REFERENCES ZZ_TIPOLOGIA_EDILIZIA(ID));
CREATE TABLE ZZ_STATO_GEOMETRIA (ID integer(10) NOT NULL, DESCRIZIONE varchar(128), PRIMARY KEY (ID));
CREATE TABLE ZZ_CATEGORIA_USO_PREVALENTE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_CATEGORIA_USO_PIANO_TERRA (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_CATEGORIA_USO_ALTRI_PIANI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_PROPRIETA (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE CATEGORIA_USO_PREVALENTE_STATO_UTILIZZO_EDIFICIO (ZZ_CATEGORIA_USO_PREVALENTEID integer(10) NOT NULL, STATO_UTILIZZO_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (ZZ_CATEGORIA_USO_PREVALENTEID, STATO_UTILIZZO_EDIFICIOID), FOREIGN KEY(ZZ_CATEGORIA_USO_PREVALENTEID) REFERENCES ZZ_CATEGORIA_USO_PREVALENTE(ID), FOREIGN KEY(STATO_UTILIZZO_EDIFICIOID) REFERENCES STATO_UTILIZZO_EDIFICIO(ID));
CREATE TABLE CATEGORIA_USO_PIANO_TERRA_STATO_UTILIZZO_EDIFICIO (ZZ_CATEGORIA_USO_PIANO_TERRAID integer(10) NOT NULL, STATO_UTILIZZO_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (ZZ_CATEGORIA_USO_PIANO_TERRAID, STATO_UTILIZZO_EDIFICIOID), FOREIGN KEY(ZZ_CATEGORIA_USO_PIANO_TERRAID) REFERENCES ZZ_CATEGORIA_USO_PIANO_TERRA(ID), FOREIGN KEY(STATO_UTILIZZO_EDIFICIOID) REFERENCES STATO_UTILIZZO_EDIFICIO(ID));
CREATE TABLE CATEGORIA_USO_ALTRI_PIANI_STATO_UTILIZZO_EDIFICIO (ZZ_CATEGORIA_USO_ALTRI_PIANIID integer(10) NOT NULL, STATO_UTILIZZO_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (ZZ_CATEGORIA_USO_ALTRI_PIANIID, STATO_UTILIZZO_EDIFICIOID), FOREIGN KEY(ZZ_CATEGORIA_USO_ALTRI_PIANIID) REFERENCES ZZ_CATEGORIA_USO_ALTRI_PIANI(ID), FOREIGN KEY(STATO_UTILIZZO_EDIFICIOID) REFERENCES STATO_UTILIZZO_EDIFICIO(ID));
CREATE TABLE STRUTTURE_PORTANTI_VERTICALI (ID varchar(60) NOT NULL, ZZ_STATO_CONSERVAZIONE_STRUTTURALEID integer(10) NOT NULL, ZZ_QUALITA_INFORMAZIONEID integer(10) NOT NULL, ZZ_APPARECCHIATURA_MURARIAID integer(10), ZZ_INCATENAMENTIID integer(10), ZZ_TAMPONATURE_DISTRIBUZIONEID integer(10), ZZ_TAMPONATURE_TIPOLOGIAID integer(10), ZZ_TAMPONATURE_PRESENZA_PIANO_DEBOLEID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_STRUTTURALEID) REFERENCES ZZ_STATO_CONSERVAZIONE_STRUTTURALE(ID), FOREIGN KEY(ZZ_QUALITA_INFORMAZIONEID) REFERENCES ZZ_QUALITA_INFORMAZIONE(ID), FOREIGN KEY(ZZ_APPARECCHIATURA_MURARIAID) REFERENCES ZZ_APPARECCHIATURA_MURARIA(ID), FOREIGN KEY(ZZ_INCATENAMENTIID) REFERENCES ZZ_INCATENAMENTI(ID), FOREIGN KEY(ZZ_TAMPONATURE_DISTRIBUZIONEID) REFERENCES ZZ_TAMPONATURE_DISTRIBUZIONE(ID), FOREIGN KEY(ZZ_TAMPONATURE_TIPOLOGIAID) REFERENCES ZZ_TAMPONATURE_TIPOLOGIA(ID), FOREIGN KEY(ZZ_TAMPONATURE_PRESENZA_PIANO_DEBOLEID) REFERENCES ZZ_TAMPONATURE_PRESENZA_PIANO_DEBOLE(ID));
CREATE TABLE ZZ_TIPOLOGIA_COSTRUTTIVA (ID integer(10) NOT NULL, DESCRIZIONE varchar(200) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_STATO_CONSERVAZIONE_STRUTTURALE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE TIPOLOGIA_COSTRUTTIVA_CARATTERISTICA_STRUTTURALE (ZZ_TIPOLOGIA_COSTRUTTIVAID integer(10) NOT NULL, STRUTTURE_PORTANTI_VERTICALIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPOLOGIA_COSTRUTTIVAID, STRUTTURE_PORTANTI_VERTICALIID), FOREIGN KEY(ZZ_TIPOLOGIA_COSTRUTTIVAID) REFERENCES ZZ_TIPOLOGIA_COSTRUTTIVA(ID), FOREIGN KEY(STRUTTURE_PORTANTI_VERTICALIID) REFERENCES STRUTTURE_PORTANTI_VERTICALI(ID));
CREATE TABLE ZZ_APPARECCHIATURA_MURARIA (ID integer(10) NOT NULL, DESCRIZIONE integer(10) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_INCATENAMENTI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TAMPONATURE_DISTRIBUZIONE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TAMPONATURE_TIPOLOGIA (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TAMPONATURE_PRESENZA_PIANO_DEBOLE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE STRUTTURE_ORIZZONTALI_SOLAI (ID varchar(60) NOT NULL, ZZ_QUALITA_INFORMAZIONEID integer(10), ZZ_STATO_CONSERVAZIONE_STRUTTURALEID integer(10) NOT NULL, SCHEDA_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_QUALITA_INFORMAZIONEID) REFERENCES ZZ_QUALITA_INFORMAZIONE(ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_STRUTTURALEID) REFERENCES ZZ_STATO_CONSERVAZIONE_STRUTTURALE(ID), FOREIGN KEY(SCHEDA_EDIFICIOID) REFERENCES SCHEDA_EDIFICIO(ID));
CREATE TABLE ZZ_TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE RILEVATORE (ID varchar(20) NOT NULL, NOME varchar(50) NOT NULL, COGNOME varchar(50) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTE_STRUTTURE_ORIZZONTALI_SOLAI (ZZ_TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTEID integer(10) NOT NULL, STRUTTURE_ORIZZONTALI_SOLAIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTEID, STRUTTURE_ORIZZONTALI_SOLAIID), FOREIGN KEY(ZZ_TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTEID) REFERENCES ZZ_TIPOLOGIA_COSTRUTTIVA_ORIZZONTALE_PREVALENTE(ID), FOREIGN KEY(STRUTTURE_ORIZZONTALI_SOLAIID) REFERENCES STRUTTURE_ORIZZONTALI_SOLAI(ID));
CREATE TABLE STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_ORDINARI (ID varchar(60) NOT NULL, ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARIID integer(10), ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURAID integer(10), ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_ORDINARIID integer(10) NOT NULL, ZZ_QUALITA_INFORMAZIONEID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARIID) REFERENCES ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARI(ID), FOREIGN KEY(ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURAID) REFERENCES ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURA(ID), FOREIGN KEY(ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_ORDINARIID) REFERENCES ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_ORDINARI(ID), FOREIGN KEY(ZZ_QUALITA_INFORMAZIONEID) REFERENCES ZZ_QUALITA_INFORMAZIONE(ID));
CREATE TABLE ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_ORDINARI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURA (ID integer(10) NOT NULL, DESCRIZIONE varchar(120) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_GRANDI_LUCI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE STRUTTURE_ORIZZONTALI_COPERTURA_EDIFICI_GRANDI_LUCI (ID varchar(60) NOT NULL, ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_GRANDI_LUCIID integer(10) NOT NULL, ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURAID integer(10), ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARIID integer(10), ZZ_QUALITA_INFORMAZIONEID integer(10) NOT NULL, ZZ_MATERIALE_COPERTURA_EDIFICI_GRANDI_LUCIID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_GRANDI_LUCIID) REFERENCES ZZ_TIPOLOGIA_COSTRUTTIVA_COPERTURA_EDIFICI_GRANDI_LUCI(ID), FOREIGN KEY(ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURAID) REFERENCES ZZ_COMPORTAMENTO_STRUTTURALE_COPERTURA(ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARIID) REFERENCES ZZ_STATO_CONSERVAZIONE_COPERTURA_EDIFICI_ORDINARI(ID), FOREIGN KEY(ZZ_QUALITA_INFORMAZIONEID) REFERENCES ZZ_QUALITA_INFORMAZIONE(ID), FOREIGN KEY(ZZ_MATERIALE_COPERTURA_EDIFICI_GRANDI_LUCIID) REFERENCES ZZ_MATERIALE_COPERTURA_EDIFICI_GRANDI_LUCI(ID));
CREATE TABLE ZZ_MATERIALE_COPERTURA_EDIFICI_GRANDI_LUCI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TIPO_MANTO_COPERTURA (ID integer(10) NOT NULL, DESCRIZIONE integer(10) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE MANTO_COPERTURA_UNITA_VOLUMETRICA (ID varchar(60) NOT NULL, ALTRO_MANTO_COPERTURA varchar(128), ELEMENTI_INCONGRUENTI integer(1) DEFAULT 0 NOT NULL, DESCRIZIONE_INCONGRUENZA varchar(1000), ZZ_TIPO_MANTO_COPERTURAID integer(10) NOT NULL, ZZ_STATO_CONSERVAZIONE_MANTOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_TIPO_MANTO_COPERTURAID) REFERENCES ZZ_TIPO_MANTO_COPERTURA(ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_MANTOID) REFERENCES ZZ_STATO_CONSERVAZIONE_MANTO(ID));
CREATE TABLE ZZ_STATO_CONSERVAZIONE_MANTO (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_PROSPETTO_PREVALENTE (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE CARATTERISTICHE_ARCHITETTONICHE_EDIFICIO (ID varchar(60) NOT NULL, ZZ_PROSPETTO_PREVALENTEID integer(10) NOT NULL, PARAMENTIID varchar(60) NOT NULL, BALCONIID varchar(60) NOT NULL, OSCURAMENTIID varchar(60) NOT NULL, INFISSIID varchar(60) NOT NULL, GRONDAID varchar(60) NOT NULL, ELEMENTI_DECORATIVIID varchar(60) NOT NULL, SUPERFETAZIONI_INCONGRUENZEID varchar(60) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_PROSPETTO_PREVALENTEID) REFERENCES ZZ_PROSPETTO_PREVALENTE(ID), FOREIGN KEY(PARAMENTIID) REFERENCES PARAMENTI(ID), FOREIGN KEY(BALCONIID) REFERENCES BALCONI(ID), FOREIGN KEY(OSCURAMENTIID) REFERENCES OSCURAMENTI(ID), FOREIGN KEY(INFISSIID) REFERENCES INFISSI(ID), FOREIGN KEY(GRONDAID) REFERENCES GRONDA(ID), FOREIGN KEY(ELEMENTI_DECORATIVIID) REFERENCES ELEMENTI_DECORATIVI(ID), FOREIGN KEY(SUPERFETAZIONI_INCONGRUENZEID) REFERENCES SUPERFETAZIONI_INCONGRUENZE(ID));
CREATE TABLE ZZ_TIPO_PARAMENTI_ARCHITETTONICI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE PARAMENTI (ID varchar(60) NOT NULL, ALTRO_PARAMENTO varchar(128), PRESENZA_INCONGRUENZE integer(1) DEFAULT '0' NOT NULL, DESCRIZIONE_INCONGRUENZE varchar(1000), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_PARAMENTI_ARCHITETTONICI_PARAMENTI (ZZ_TIPO_PARAMENTI_ARCHITETTONICIID integer(10) NOT NULL, PARAMENTIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_PARAMENTI_ARCHITETTONICIID, PARAMENTIID), FOREIGN KEY(ZZ_TIPO_PARAMENTI_ARCHITETTONICIID) REFERENCES ZZ_TIPO_PARAMENTI_ARCHITETTONICI(ID), FOREIGN KEY(PARAMENTIID) REFERENCES PARAMENTI(ID));
CREATE TABLE BALCONI (ID varchar(60) NOT NULL, ALTRO_BALCONE varchar(128), PRESENZA_INCONGRUENZE integer(1) DEFAULT '0' NOT NULL, DESCRIZIONI_INCONGRUENZE varchar(1000), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_BALCONI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE OSCURAMENTI (ID varchar(60) NOT NULL, ALTRO_OSCURAMENTO varchar(128), PRESENZA_INCONGRUENZE integer(1) DEFAULT 0 NOT NULL, DESCRIZIONI_INCONGRUENZE varchar(1000), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_OSCURAMENTI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ZZ_TIPO_OSCURAMENTI_OSCURAMENTI (ZZ_TIPO_OSCURAMENTIID integer(10) NOT NULL, OSCURAMENTIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_OSCURAMENTIID, OSCURAMENTIID), FOREIGN KEY(ZZ_TIPO_OSCURAMENTIID) REFERENCES ZZ_TIPO_OSCURAMENTI(ID), FOREIGN KEY(OSCURAMENTIID) REFERENCES OSCURAMENTI(ID));
CREATE TABLE ZZ_TIPO_INFISSI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE INFISSI (ID varchar(60) NOT NULL, ALTRO_INFISSO varchar(128), PRESENZA_INCONGRUENZE integer(1) DEFAULT 0 NOT NULL, DESCRIZIONI_INCONGRUENZE varchar(1000), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_INFISSI_INFISSI (ZZ_TIPO_INFISSIID integer(10) NOT NULL, INFISSIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_INFISSIID, INFISSIID), FOREIGN KEY(ZZ_TIPO_INFISSIID) REFERENCES ZZ_TIPO_INFISSI(ID), FOREIGN KEY(INFISSIID) REFERENCES INFISSI(ID));
CREATE TABLE ZZ_TIPO_GRONDA (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE GRONDA (ID varchar(60) NOT NULL, ALTRO_GRONDA varchar(128), PRESENZA_INCONGRUENZE integer(1) DEFAULT '0' NOT NULL, DESCRIZIONI_INCONGRUENZE varchar(1000), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_ELEMENTI_DECORATIVI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE ELEMENTI_DECORATIVI (ID varchar(60) NOT NULL, ALTRO_ELEMENTO_DECORATIVO varchar(128), PRESENZA_INCONGRUENZE integer(1) DEFAULT 0 NOT NULL, DESCRIZIONI_INCONGRUENZE varchar(1000), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_ELEMENTI_DECORATIVI_ELEMENTI_DECORATIVI (ZZ_TIPO_ELEMENTI_DECORATIVIID integer(10) NOT NULL, ELEMENTI_DECORATIVIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_ELEMENTI_DECORATIVIID, ELEMENTI_DECORATIVIID), FOREIGN KEY(ZZ_TIPO_ELEMENTI_DECORATIVIID) REFERENCES ZZ_TIPO_ELEMENTI_DECORATIVI(ID), FOREIGN KEY(ELEMENTI_DECORATIVIID) REFERENCES ELEMENTI_DECORATIVI(ID));
CREATE TABLE ZZ_TIPO_SUPERFETAZIONI (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE SUPERFETAZIONI_INCONGRUENZE (ID varchar(60) NOT NULL, ALTRO_SUPERFETAZIONE_INCONGRUENZA varchar(128), ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID integer(10) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(ZZ_STATO_CONSERVAZIONE_ARCHITETTONICOID) REFERENCES ZZ_STATO_CONSERVAZIONE_ARCHITETTONICO(ID));
CREATE TABLE ZZ_TIPO_SUPERFETAZIONI_SUPERFETAZIONI (ZZ_TIPO_SUPERFETAZIONIID integer(10) NOT NULL, SUPERFETAZIONI_INCONGRUENZEID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_SUPERFETAZIONIID, SUPERFETAZIONI_INCONGRUENZEID), FOREIGN KEY(ZZ_TIPO_SUPERFETAZIONIID) REFERENCES ZZ_TIPO_SUPERFETAZIONI(ID), FOREIGN KEY(SUPERFETAZIONI_INCONGRUENZEID) REFERENCES SUPERFETAZIONI_INCONGRUENZE(ID));
CREATE TABLE ZZ_TIPO_BALCONI_BALCONI (ZZ_TIPO_BALCONIID integer(10) NOT NULL, BALCONIID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_BALCONIID, BALCONIID), FOREIGN KEY(ZZ_TIPO_BALCONIID) REFERENCES ZZ_TIPO_BALCONI(ID), FOREIGN KEY(BALCONIID) REFERENCES BALCONI(ID));
CREATE TABLE ZZ_TIPO_GRONDA_GRONDA (ZZ_TIPO_GRONDAID integer(10) NOT NULL, GRONDAID varchar(60) NOT NULL, PRIMARY KEY (ZZ_TIPO_GRONDAID, GRONDAID), FOREIGN KEY(ZZ_TIPO_GRONDAID) REFERENCES ZZ_TIPO_GRONDA(ID), FOREIGN KEY(GRONDAID) REFERENCES GRONDA(ID));
CREATE TABLE FOTO_GEOREF (ID varchar(60) NOT NULL, GEOREF_PROIET_X double(12), GEOREF_PROIET_Y double(12), GEOREF_EPSG4326_X double(12), GEOREF_EPSG4326_Y double(12), FILENAME varchar(128), IMAGE blob, ANNOTAZIONE varchar(2000), ZZ_FRONTE_EDIFICIOID integer(10) NOT NULL, SCHEDA_EDIFICIOID varchar(60) NOT NULL, FILETYPE varchar(20), PRIMARY KEY (ID), FOREIGN KEY(ZZ_FRONTE_EDIFICIOID) REFERENCES ZZ_FRONTE_EDIFICIO(ID), FOREIGN KEY(SCHEDA_EDIFICIOID) REFERENCES SCHEDA_EDIFICIO(ID));
CREATE TABLE ZZ_FRONTE_EDIFICIO (ID integer(10) NOT NULL, DESCRIZIONE varchar(128) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE NUMERI_CIVICI (IDNUMEROCIVICO varchar(60) NOT NULL, N_CIVICO integer(5) NOT NULL, MOD_CIVICO varchar(10), INDIRIZZO_VIAID_INDIRIZZO varchar(60) NOT NULL, LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ varchar(60) NOT NULL, PRIMARY KEY (IDNUMEROCIVICO), FOREIGN KEY(INDIRIZZO_VIAID_INDIRIZZO) REFERENCES INDIRIZZO_VIA(ID_INDIRIZZO), FOREIGN KEY(LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ) REFERENCES LOCALIZZAZIONE_EDIFICIO(IDLOCALIZZ));
CREATE TABLE LOCALIZZAZIONE_EDIFICIO_INDIRIZZO_VIA (LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ varchar(60) NOT NULL, INDIRIZZO_VIAID_INDIRIZZO varchar(60) NOT NULL, PRIMARY KEY (LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ, INDIRIZZO_VIAID_INDIRIZZO), FOREIGN KEY(LOCALIZZAZIONE_EDIFICIOIDLOCALIZZ) REFERENCES LOCALIZZAZIONE_EDIFICIO(IDLOCALIZZ), FOREIGN KEY(INDIRIZZO_VIAID_INDIRIZZO) REFERENCES INDIRIZZO_VIA(ID_INDIRIZZO));
CREATE TABLE ZZ_DISCLAIMER ("DATABASE" varchar(255) DEFAULT 'DB-EDIFICI' NOT NULL, TARGET varchar(255) NOT NULL, DB_VERSION_MAIOR integer(10) DEFAULT 1 NOT NULL, DB_VERSION_MINOR integer(10) DEFAULT 0 NOT NULL, AUTHOR varchar(255) DEFAULT 'Regione Toscana - SITA' NOT NULL, DB_CREATION_DATE varchar(20) DEFAULT '12/01/2011' NOT NULL, DB_FIRST_DATE_USAGE varchar(20), DB_LAST_DATE_USAGE varchar(20), ATTIVO integer(1) DEFAULT 0 NOT NULL, XMIN numeric(18, 5), YMIN numeric(18, 5), XMAX numeric(18, 5), YMAX numeric(18, 5), BUFFER integer(5) DEFAULT 0 NOT NULL);
CREATE TABLE RIFERIMENTI_CATASTALI_SCHEDA_EDIFICIO (RIFERIMENTI_CATASTALIIDREF_CATAST varchar(60) NOT NULL, SCHEDA_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (RIFERIMENTI_CATASTALIIDREF_CATAST, SCHEDA_EDIFICIOID), FOREIGN KEY(RIFERIMENTI_CATASTALIIDREF_CATAST) REFERENCES RIFERIMENTI_CATASTALI(IDREF_CATAST), FOREIGN KEY(SCHEDA_EDIFICIOID) REFERENCES SCHEDA_EDIFICIO(ID));
CREATE TABLE ZZ_WMS ("ORDER" integer(2) NOT NULL, TITLE varchar(128) NOT NULL, URL varchar(255) NOT NULL, LAYERS varchar(255) NOT NULL, SRS varchar(20) NOT NULL, FORMAT varchar(30) NOT NULL, TRANSPARENT varchar(20) NOT NULL, VERSION varchar(20) NOT NULL, CACHE_SCALA integer(7) DEFAULT 2000 NOT NULL, CACHE_ESTENSIONE integer(7) DEFAULT 2000 NOT NULL);
CREATE TABLE NOTE_STORICHE_EDIFICIO (ID varchar(60) NOT NULL, NOTA varchar(2000) NOT NULL, SCHEDA_EDIFICIOID varchar(60) NOT NULL, PRIMARY KEY (ID), FOREIGN KEY(SCHEDA_EDIFICIOID) REFERENCES SCHEDA_EDIFICIO(ID));
