BEGIN TRANSACTION; 
delete from ZZ_DISCLAIMER; -- T00 
insert into ZZ_DISCLAIMER(database,target,db_version_maior,db_version_minor,author,db_creation_date,attivo) Values ('DB-EDIFICI','Demo',1,5,'Regione Toscana - SITA','19/10/2011',0);
COMMIT; 

BEGIN TRANSACTION; 
delete from ZZ_WMS; -- T00 
insert into ZZ_WMS Values (1,'WMS RT - OFC 1:10k anno 2010','http://web.rete.toscana.it/sgrwms/com.rt.wms.RTmap/_rt_wms?','otf10k10,idcomuni,_idreg','EPSG:3003','PNG','TRUE','1.3.0',4000,2000);
insert into ZZ_WMS Values (2,'WMS RT - CTR 1:10k','http://web.rete.toscana.it/sgrwms/com.rt.wms.RTmap/_rt_wms?','idrst10k,idcomuni,_idreg','EPSG:3003','PNG','TRUE','1.3.0',4000,2000);
insert into ZZ_WMS Values (3,'WMS RT - CTR 1:2k','http://web.rete.toscana.it/sgrwms/com.rt.wms.RTmap/_rt_wms?','rst2k_liv3,idcomuni,_idreg','EPSG:3003','PNG','TRUE','1.3.0',1000,2000);
insert into ZZ_WMS Values (4,'WMS RT - STRADE','http://web.rete.toscana.it/sgrwms/com.rt.wms.RTmap/_rt_wms?','idstradeestesa,_idreg','EPSG:3003','PNG','TRUE','1.3.0',2000,2000);
insert into ZZ_WMS Values (5,'WMS RT - CATASTO Fabbricati','http://web.rete.toscana.it/sgrwms/com.rt.wms.RTmap/_rt_wms?','idcatfabbr051,idcatfabbr048,idcatfabbr053,idcatfabbr049,idcatfabbr046,idcatfabbr045,idcatfabbr050,idcatfabbr047,idcatfabbr100,idcatfabbr052,_idreg','EPSG:3003','PNG','TRUE','1.3.0',1500,2000);
insert into ZZ_WMS Values (6,'WMS RT - CATASTO Particelle','http://web.rete.toscana.it/sgrwms/com.rt.wms.RTmap/_rt_wms?','idbfmc051,idbfmc048,idbfmc053,idbfmc049,idbfmc046,idbfmc045,idbfmc050,idbfmc047,idbfmc100,idbfmc052,idpartcat051,idpartcat048,idpartcat053,idpartcat049,idpartcat046,idpartcat045,idpartcat050,idpartcat047,idpartcat100,idpartcat052,_idreg','EPSG:3003','PNG','TRUE','1.3.0',2000,2000);
COMMIT; 

DROP TRIGGER IF EXISTS _dbedifici_deny_insert_originali;
DROP TRIGGER IF EXISTS _dbedifici_deny_update_originali;
DROP TRIGGER IF EXISTS _dbedifici_deny_delete_originali;
DROP TRIGGER IF EXISTS _dbedifici_deny_insert_modificate;
DROP TRIGGER IF EXISTS _dbedifici_deny_update_modificate;
DROP TRIGGER IF EXISTS _dbedifici_deny_delete_modificate;
;

CREATE TRIGGER "_dbedifici_deny_insert_originali" 
 BEFORE INSERT ON "geometrie_unita_volumetriche_originali_di_partenza"
 FOR EACH ROW BEGIN
 SELECT RAISE(ROLLBACK, 
 'QUESTO STRATO NON VA ALTERATO. Non è possibile inserire nuove geometrie');
 END;

CREATE TRIGGER "_dbedifici_deny_update_originali" 
 BEFORE UPDATE ON "geometrie_unita_volumetriche_originali_di_partenza"
 FOR EACH ROW BEGIN
 SELECT RAISE(ROLLBACK, 
 'QUESTO STRATO NON VA ALTERATO. Non è possibile modificare le geometrie presenti');
 END;

CREATE TRIGGER "_dbedifici_deny_delete_originali" 
 BEFORE DELETE ON "geometrie_unita_volumetriche_originali_di_partenza"
 FOR EACH ROW BEGIN
 SELECT RAISE(ROLLBACK, 
 'QUESTO STRATO NON VA ALTERATO. Non è possibile cancellare le geometrie presenti');
 END;

CREATE TRIGGER "_dbedifici_deny_insert_modificate"
 BEFORE INSERT ON "geometrie_rilevate_nuove_o_modificate"
 FOR EACH ROW BEGIN
 SELECT RAISE(ROLLBACK, 
 'QUESTO STRATO NON VA ALTERATO. Non è possibile inserire nuove geometrie') WHERE (SELECT attivo FROM 
 zz_disclaimer WHERE attivo=1) IS NULL;
 END;

CREATE TRIGGER "_dbedifici_deny_update_modificate" 
 BEFORE UPDATE ON "geometrie_rilevate_nuove_o_modificate"
 FOR EACH ROW BEGIN
 SELECT RAISE(ROLLBACK, 
 'QUESTO STRATO NON VA ALTERATO. Non è possibile modificare le geometrie presenti') WHERE (SELECT attivo FROM 
 zz_disclaimer WHERE attivo=1) IS NULL;
 END;

CREATE TRIGGER "_dbedifici_deny_delete_modificate" 
 BEFORE DELETE ON "geometrie_rilevate_nuove_o_modificate"
 FOR EACH ROW BEGIN
 SELECT RAISE(ROLLBACK, 
 'QUESTO STRATO NON VA ALTERATO. Non è possibile cancellare le geometrie presenti') WHERE (SELECT attivo FROM 
 zz_disclaimer WHERE attivo=1) IS NULL;
 END;

