# -*- coding: utf-8 -*-
"""
/***************************************************************************
 routeplanning
                                 A QGIS plugin
 Calculating the best route between two chosen point in terrain conditions. The calculation considers terrain, land cover and road network.
 Important remark: The files have to be in the same CRS, otherwise the plugin will run into an error.
 The methodology is based on: https://doi.org/10.5194/ica-proc-4-4-2021
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-28
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Zsofia Sarközy
        email                : sarkozy.zsofi@inf.elte.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QApplication, QWidget, QProgressBar, QPushButton, QVBoxLayout, QDialogButtonBox
from qgis.analysis import QgsNativeAlgorithms
from qgis.core import *
import processing
import os
QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .routeplanning_dialog import routeplanningDialog
import os.path

#https://docs.qgis.org/3.40/en/docs/user_manual/processing_algs/index.html
#phyton console: import processing
#processing.algorithmHelp("gdal:rasterize")

class routeplanning:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'routeplanning_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&route-planner')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('routeplanning', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = QIcon(os.path.join(os.path.dirname(__file__), "icon.png"))

        self.add_action(
            icon_path,
            text=self.tr(u'route-planner'),
            callback=self.run,
            parent=self.iface.mainWindow())
       
        
        
        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&route-planner'),
                action)
            self.iface.removeToolBarIcon(action)
    
    def empty(self):
        self.dlg.input_lineEdit.clear(),
        self.dlg.output_lineEdit.clear(),
        self.dlg.acc_output_lineEdit.clear(),
        self.dlg.dir_lineEdit.clear(),
       
   
        
    def select_input_raster(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlg, "Select a cost surface: ", "", '*.tif')
        self.dlg.input_lineEdit.setText(filename)
        
    def select_accumulated_output_file(self):
        filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select accumulated cost output file: ", "", '*.tif')
        self.dlg.acc_output_lineEdit.setText(filename)
    def select_output_file(self):
        filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file ","", '*.shp')
        self.dlg.output_lineEdit.setText(filename)
        
    def select_directon_file(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlg, "Select direction of maximum cost","", '*.tif')
        self.dlg.dir_lineEdit.setText(filename)
        
    def select_start_point(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlg, "Select layer with starting point","", '*.shp')
        self.dlg.start_lineEdit.setText(filename)
        
    def select_finish_point(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlg, "Select layer with finish point","", '*.shp')
        self.dlg.finish_lineEdit.setText(filename)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = routeplanningDialog()
            self.dlg.start_pushButton.clicked.connect(self.select_start_point)
            self.dlg.finish_pushButton.clicked.connect(self.select_finish_point)
            self.dlg.input_pushButton.clicked.connect(self.select_input_raster)
            self.dlg.output_pushButton.clicked.connect(self.select_output_file)
            self.dlg.acc_output_pushButton.clicked.connect(self.select_accumulated_output_file)
            self.dlg.dir_pushButton.clicked.connect(self.select_directon_file)
            # Fetch the currently loaded layers
            layers = QgsProject.instance().layerTreeRoot().children()
            # Clear the contents from previous runs
            self.dlg.start_lineEdit.clear()
            self.dlg.finish_lineEdit.clear()
            self.dlg.output_lineEdit.clear()
            self.dlg.acc_output_lineEdit.clear()
            self.dlg.button_box.button(QDialogButtonBox.Reset).clicked.connect(self.empty)
        
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        # See if OK was pressed
        if result:
            
            #Push message in QGIS when
            self.iface.messageBar().clearWidgets()
            progressMessageBar = self.iface.messageBar()
            progressbar = QProgressBar()
            progressMessageBar.pushWidget(progressbar)
            # Processing feedback            
            
            ###################
            #Accumulated cost:#
            ###################
                
            costsurface = self.dlg.input_lineEdit.text()
            dir_maxcost = self.dlg.dir_lineEdit.text()
            dest_point = self.dlg.finish_lineEdit.text()
            acc_raster = self.dlg.acc_output_lineEdit.text()
            #all_raster = os.path.join(working_dir, "allocation_raster.tif")
            
            processing.run("saga:accumulatedcost",{
                'DEST_TYPE':0,
                'DEST_POINTS':dest_point,
                'DEST_GRID':costsurface,
                'COST':costsurface,
                'DIR_MAXCOST': dir_maxcost,
                'DIR_UNIT':0,
                'DIR_K':2,
                'ACCUMULATED':acc_raster,
                'ALLOCATION':'TEMPORARY_OUTPUT'
                #'THRESHOLD':0
                })
                
            print("Accumulated raster saved to:", acc_raster)

            addRaster = QgsRasterLayer(acc_raster, acc_raster, "gdal")
            if addRaster.isValid():
                QgsProject.instance().addMapLayer(addRaster)
            else:
                print("Failed to load output raster:", acc_raster)
                
            ##################
            #Least cost path:#
            ##################
            
            start_point = self.dlg.start_lineEdit.text()
            output = self.dlg.output_lineEdit.text()
            processing.run('saga:leastcostpaths',{
                'SOURCE':start_point,
                'DEM':acc_raster,
                'VALUES':None,
                'POINTS':'TEMPORARY_OUTPUT',
                'LINE':output
                })
            
            print("Least cost path saved to:", output)

            addLCP = QgsVectorLayer(output, output, "ogr")
            if addLCP.isValid():
                QgsProject.instance().addMapLayer(addLCP)
            else:
                print("Failed to load least cost path:", output)
            
            #Push message in QGIS when done
            self.iface.messageBar().pushMessage(
              "Success", "Output file written",
              level=Qgis.Success, duration=3)
            self.iface.messageBar().clearWidgets()
            
            pass
     