import sys

from PyQt5.QtPrintSupport import QPrintDialog, QPrinter
from PyQt5.QtWidgets import (QApplication, QMainWindow, QPushButton, QTextEdit,
                             QVBoxLayout, QWidget)


class PrintApp(QMainWindow):
    def __init__(self):
        super().__init__()
        self.setWindowTitle("Native Windows Print Dialog")
        self.resize(600, 400)
        # UI Setup
        self.editor = QTextEdit(self)
        self.editor.setHtml("<h1>Hello Windows!</h1><p>This will be sent to the native print dialog.</p>")
        
        self.print_btn = QPushButton("Open Print Dialog", self)
        self.print_btn.clicked.connect(self.show_print_dialog)
        layout = QVBoxLayout()
        layout.addWidget(self.editor)
        layout.addWidget(self.print_btn)
        container = QWidget()
        container.setLayout(layout)
        self.setCentralWidget(container)

    def show_print_dialog(self):
        # 1. Initialize the printer with High Resolution
        printer = QPrinter(QPrinter.HighResolution)
        # 2. Create the Native Dialog
        # On Windows, this automatically pulls up the system dialog with a preview
        dialog = QPrintDialog(printer, self)
        
        if dialog.exec_() == QPrintDialog.Accepted:
            # 3. If user clicks 'Print', send the document to the printer
            self.editor.print_(printer)

if __name__ == "__main__":
    app = QApplication(sys.argv)
    window = PrintApp()
    window.show()
    sys.exit(app.exec_())

