from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class roadnetworkorientationosmnxroseProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'roadnetwork_orientation_osmnx_roses'

    def name(self):
        return self.tr('Road Network Orientation OSMnx (Rose Diagram)')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.roadnetwork_orientation_osmnx_roses import RoadNetworkOrientationOSMnxs
        self.addAlgorithm(RoadNetworkOrientationOSMnxs())

