"""
/***************************************************************************
 RMCGeo
                                 A QGIS plugin
 Conjunto de ferramentas para simplificar tarefas geoespaciais.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-01-10
        copyright            : (C) 2025 by Rodolfo Martins de Carvalho
        email                : rodolfomartins09@gmail.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import sys
from os import path
sys.path.append(path.abspath(path.join(path.dirname(__file__), '..')))
from qgis.PyQt.QtWidgets import QAction, QMenu
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import Qt, QCoreApplication, QSettings, QTranslator
from .modules.gms_to_decimal import run as run_gms_decimal
from .modules.street_view import run as run_street_view
from .modules.point_insert import run as run_point_insert
from .modules.copy_coordenadas import run as run_copy_coord_def
from .modules.desenho_azimute import run as run_azimuth_distance
from .modules.desenho_rumo import run as run_rumo_distance
from .modules.add_area_tabela import run as run_add_area_tabela
from .modules.add_azimute_tabela import run as run_add_azimute_tabela
from .modules.add_perimetro_tabela import run as run_add_perimetro_tabela
from .modules.add_coord_x_tabela import run as run_add_coord_x_tabela
from .modules.add_coord_y_tabela import run as run_add_coord_y_tabela
from .modules.add_comprimento_tabela import run as run_add_comprimento_tabela
from .modules.extend_tool import run as run_extend_tool
from .modules.offset_tool import run as run_offset_tool
from .modules.chanfro_tool import run as run_chanfro_tool
from .modules.project_norms import run as run_project_norms
from .modules.links_uteis import LinksUteisManager

from .about import AboutDialog
import os.path
#from . import resources

class RMCGeo:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_menu = None
        
        # Inicialização do sistema de tradução
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        self.locale = locale
        
        # Log para depuração
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'rmcgeo_{}.qm'.format(locale))
            
        print(f"RMCGEO Plugin: Idioma detectado = {locale}")
        print(f"RMCGEO Plugin: Procurando arquivo de tradução em {locale_path}")
        
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            result = self.translator.load(locale_path)
            if result:
                print(f"RMCGEO Plugin: Arquivo de tradução carregado com sucesso")
                QCoreApplication.installTranslator(self.translator)

            else:
                print(f"RMCGEO Plugin: Falha ao carregar o arquivo de tradução")
        else:
            print(f"RMCGEO Plugin: Arquivo de tradução não encontrado")

    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('RMCGeo', message)

    def initGui(self):
        self.plugin_menu = QMenu(self.tr("RMCGEO"), self.iface.mainWindow().menuBar())
        #self.plugin_menu.setIcon(QIcon(':/plugins/rmcgeo2/icon.png')) nao usar
        self.iface.mainWindow().menuBar().addMenu(self.plugin_menu)

        submenu1 = QMenu(self.tr("Memorial (In Development)"), self.plugin_menu)
        submenu1.setIcon(QIcon(':/images/themes/default/mActionShowPluginManager.svg'))
        self.plugin_menu.addMenu(submenu1)

        self.plugin_menu.addSeparator()

        menu_aplicativos = QMenu(self.tr("Applications"), self.plugin_menu)
        menu_aplicativos.setIcon(QIcon(':/images/themes/default/mActionShowPluginManager.svg'))
        self.plugin_menu.addMenu(menu_aplicativos)

        #Desenho por Azimute e Distância
        self.action_azimuth = QAction(QIcon(':/images/themes/default/mActionMeasureBearing.svg'),
        self.tr("Drawing by Azimuth and Distance"), self.iface.mainWindow())
        self.action_azimuth.triggered.connect(lambda: run_azimuth_distance(self.iface))
        menu_aplicativos.addAction(self.action_azimuth)

        #Desenho por Rumo e Distância
        self.action_rumo = QAction(QIcon(':/images/themes/default/mActionMeasureBearing.svg'),
        self.tr("Drawing by Rumo and Distance"), self.iface.mainWindow())
        self.action_rumo.triggered.connect(lambda: run_rumo_distance(self.iface))
        menu_aplicativos.addAction(self.action_rumo)

        menu_aplicativos.addSeparator()

        #Conversor de Graus decimal para GMS
        self.action11 = QAction(QIcon(':/images/themes/default/mActionCalculateField.svg'),
        self.tr("Decimal to GMS Converter"), self.iface.mainWindow())
        self.action11.triggered.connect(lambda: run_gms_decimal(self.iface))
        menu_aplicativos.addAction(self.action11)

        # Normas de Projeto (Específico Goiânia)
        self.action_norms = QAction(QIcon(':/images/themes/default/mActionLabeling.svg'),
        "Análise de Normas (Goiânia)", self.iface.mainWindow())
        self.action_norms.triggered.connect(lambda: run_project_norms(self.iface))
        menu_aplicativos.addAction(self.action_norms)

        menu_ferramentas = QMenu(self.tr("Tools"), self.plugin_menu)
        menu_ferramentas.setIcon(QIcon(':/images/themes/default/processingAlgorithm.svg'))
        self.plugin_menu.addMenu(menu_ferramentas)

        # Ferramenta Extend
        self.action_extend = QAction(QIcon(':/images/themes/default/mActionTrimExtendFeature.svg'),
        self.tr("Extend Line"), self.iface.mainWindow())
        self.action_extend.triggered.connect(lambda: run_extend_tool(self.iface))
        menu_ferramentas.addAction(self.action_extend)

        # Ferramenta Offset
        self.action_offset = QAction(QIcon(':/images/themes/default/algorithms/mAlgorithmOffsetLines.svg'),
        self.tr("Offset Line"), self.iface.mainWindow())
        self.action_offset.triggered.connect(lambda: run_offset_tool(self.iface))
        menu_ferramentas.addAction(self.action_offset)

        # Ferramenta Chanfro
        self.action_chanfro = QAction(QIcon(':/images/themes/default/algorithms/mAlgorithmBuffer.svg'),
        self.tr("Chamfer Line"), self.iface.mainWindow())
        self.action_chanfro.triggered.connect(lambda: run_chanfro_tool(self.iface))
        menu_ferramentas.addAction(self.action_chanfro)

        menu_ferramentas.addSeparator() 

        #Inserir Ponto
        self.point_insert = QAction(QIcon(':/images/themes/default/gpsicons/mActionAddTrackPoint.svg'),
        self.tr("Insert Point (X,Y)"), self.iface.mainWindow())
        self.point_insert.triggered.connect(lambda: run_point_insert(self.iface))
        menu_ferramentas.addAction(self.point_insert)

        #Copiar Coordenadas pelo SRC
        self.action23 = QAction(QIcon(':/images/themes/default/mActionEditCopy.svg'),
        self.tr("Copy Coordinates"), self.iface.mainWindow())
        self.action23.triggered.connect(lambda: run_copy_coord_def(self.iface))
        menu_ferramentas.addAction(self.action23)

        #Street View pelo Navegador Padrao
        self.action_street_view = QAction(QIcon(':/images/themes/default/mIconWms.svg'),
        self.tr("Street View"), self.iface.mainWindow())
        self.action_street_view.triggered.connect(lambda: run_street_view(self.iface))
        menu_ferramentas.addAction(self.action_street_view)

        menu_manipulador_tabela = QMenu(self.tr("Table Manipulation"), self.plugin_menu)
        menu_manipulador_tabela.setIcon(QIcon(':/images/themes/default/processingAlgorithm.svg'))
        self.plugin_menu.addMenu(menu_manipulador_tabela)

        #Adicionar Área na Tabela de Atributos
        self.action_add_area = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Area to Table"), self.iface.mainWindow())
        self.action_add_area.triggered.connect(lambda: run_add_area_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_area)

        #Adicionar Azimute em GMS na Tabela de Atributos
        self.action_add_azimute = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Azimuth GMS to Table"), self.iface.mainWindow())
        self.action_add_azimute.triggered.connect(lambda: run_add_azimute_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_azimute)

        #Adicionar Perímetro na Tabela de Atributos
        self.action_add_perimetro = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Perimeter to Table"), self.iface.mainWindow())
        self.action_add_perimetro.triggered.connect(lambda: run_add_perimetro_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_perimetro)

        #Adicionar Coordenada X na Tabela de Atributos
        self.action_add_coord_x = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Coordinate X to Table"), self.iface.mainWindow())
        self.action_add_coord_x.triggered.connect(lambda: run_add_coord_x_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_coord_x)

        #Adicionar Coordenada Y na Tabela de Atributos
        self.action_add_coord_y = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Coordinate Y to Table"), self.iface.mainWindow())
        self.action_add_coord_y.triggered.connect(lambda: run_add_coord_y_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_coord_y)

        #Adicionar Comprimento na Tabela de Atributos
        self.action_add_comprimento = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Length to Table"), self.iface.mainWindow())
        self.action_add_comprimento.triggered.connect(lambda: run_add_comprimento_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_comprimento)

        # Menu Links Úteis
        menu_links_uteis = QMenu(self.tr("Useful Links"), self.plugin_menu)
        menu_links_uteis.setIcon(QIcon(':/images/themes/default/mIconWms.svg'))
        self.plugin_menu.addMenu(menu_links_uteis)
        
        # Inicializar gerenciador de links (sem precisar passar plugin_dir)
        self.links_manager = LinksUteisManager()
        # Criar ações de links dinamicamente
        self.links_actions = self.links_manager.create_menu_actions(menu_links_uteis, self.iface)

        self.plugin_menu.addSeparator()

        #Sobre o RMCGEO
        self.menu_about = QAction(QIcon(':/images/flags/pt_BR.svg'),
            self.tr("About RMCGEO"), self.iface.mainWindow())
        self.menu_about.triggered.connect(self.show_about)
        self.plugin_menu.addAction(self.menu_about)

    def show_about(self):
        dlg = AboutDialog(self.iface.mainWindow())
        # Compatibilidade Qt5/Qt6: exec_() foi renomeado para exec()
        if hasattr(dlg, 'exec'):
            dlg.exec()
        else:
            dlg.exec_()

    def unload(self):
        if hasattr(self, 'plugin_menu'):
            self.plugin_menu.deleteLater()




