"""
/***************************************************************************
 RMCGeo
                                 A QGIS plugin
 Conjunto de ferramentas para simplificar tarefas geoespaciais.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-01-10
        copyright            : (C) 2025 by Rodolfo Martins de Carvalho
        email                : rodolfomartins09@gmail.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import sys
from os import path
sys.path.append(path.abspath(path.join(path.dirname(__file__), '..')))
from qgis.PyQt.QtWidgets import QAction, QMenu
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import Qt, QCoreApplication, QSettings, QTranslator
from .modules.gms_to_decimal import run as run_gms_decimal
from .modules.street_view import run as run_street_view
from .modules.point_insert import run as run_point_insert
from .modules.copy_coordenadas import run as run_copy_coord_def
from .modules.desenho_azimute import run as run_azimuth_distance
from .modules.desenho_rumo import run as run_rumo_distance
from .modules.add_area_tabela import run as run_add_area_tabela
from .modules.add_azimute_tabela import run as run_add_azimute_tabela
from .modules.add_perimetro_tabela import run as run_add_perimetro_tabela
from .modules.add_coord_x_tabela import run as run_add_coord_x_tabela
from .modules.add_coord_y_tabela import run as run_add_coord_y_tabela
from .modules.add_comprimento_tabela import run as run_add_comprimento_tabela

from .about import AboutDialog
import os.path
#from . import resources

class RMCGeo:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_menu = None
        
        # Inicialização do sistema de tradução
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        self.locale = locale
        
        # Log para depuração
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'rmcgeo_{}.qm'.format(locale))
            
        print(f"RMCGEO Plugin: Idioma detectado = {locale}")
        print(f"RMCGEO Plugin: Procurando arquivo de tradução em {locale_path}")
        
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            result = self.translator.load(locale_path)
            if result:
                print(f"RMCGEO Plugin: Arquivo de tradução carregado com sucesso")
                QCoreApplication.installTranslator(self.translator)

            else:
                print(f"RMCGEO Plugin: Falha ao carregar o arquivo de tradução")
        else:
            print(f"RMCGEO Plugin: Arquivo de tradução não encontrado")

    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('RMCGeo', message)

    def initGui(self):
        self.plugin_menu = QMenu(self.tr("RMCGEO"), self.iface.mainWindow().menuBar())
        #self.plugin_menu.setIcon(QIcon(':/plugins/rmcgeo2/icon.png')) nao usar
        self.iface.mainWindow().menuBar().addMenu(self.plugin_menu)
        
        submenu1 = QMenu(self.tr("Memorial Descritivo (In Development)"), self.plugin_menu)
        submenu1.setIcon(QIcon(':/images/themes/default/mActionShowPluginManager.svg'))
        self.plugin_menu.addMenu(submenu1)

        menu_aplicativos = QMenu(self.tr("Applications"), self.plugin_menu)
        menu_aplicativos.setIcon(QIcon(':/images/themes/default/mActionShowPluginManager.svg'))
        self.plugin_menu.addMenu(menu_aplicativos)

        #Desenho por Azimute e Distância
        self.action_azimuth = QAction(QIcon(':/images/themes/default/mActionMeasure.svg'),
        self.tr("Drawing by Azimuth and Distance"), self.iface.mainWindow())
        self.action_azimuth.triggered.connect(lambda: run_azimuth_distance(self.iface))
        menu_aplicativos.addAction(self.action_azimuth)

        #Desenho por Rumo e Distância
        self.action_rumo = QAction(QIcon(':/images/themes/default/mActionMeasure.svg'),
        self.tr("Drawing by Rumo and Distance"), self.iface.mainWindow())
        self.action_rumo.triggered.connect(lambda: run_rumo_distance(self.iface))
        menu_aplicativos.addAction(self.action_rumo)

        #Conversor de Graus decimal para GMS
        self.action11 = QAction(QIcon(':/images/themes/default/mActionCalculateField.svg'),
        self.tr("Decimal to GMS Converter"), self.iface.mainWindow())
        self.action11.triggered.connect(lambda: run_gms_decimal(self.iface))
        menu_aplicativos.addAction(self.action11)

        menu_ferramentas = QMenu(self.tr("Tools"), self.plugin_menu)
        menu_ferramentas.setIcon(QIcon(':/images/themes/default/processingAlgorithm.svg'))
        self.plugin_menu.addMenu(menu_ferramentas)

        #Inserir Ponto
        self.point_insert = QAction(QIcon(':/images/themes/default/gpsicons/mActionAddTrackPoint.svg'),
        "Inserir Ponto (X,Y)", self.iface.mainWindow())
        self.point_insert.triggered.connect(lambda: run_point_insert(self.iface))
        menu_ferramentas.addAction(self.point_insert)

        #Copiar Coordenadas pelo SRC
        self.action23 = QAction(QIcon(':/images/themes/default/mActionEditCopy.svg'),
        self.tr("Copy Coordinates"), self.iface.mainWindow())
        self.action23.triggered.connect(lambda: run_copy_coord_def(self.iface))
        menu_ferramentas.addAction(self.action23)

        #Street View pelo Navegador Padrao
        self.action_street_view = QAction(QIcon(':/images/themes/default/mIconWms.svg'),
        "Street View", self.iface.mainWindow())
        self.action_street_view.triggered.connect(lambda: run_street_view(self.iface))
        menu_ferramentas.addAction(self.action_street_view)

        menu_manipulador_tabela = QMenu(self.tr("Table Manipulation"), self.plugin_menu)
        menu_manipulador_tabela.setIcon(QIcon(':/images/themes/default/processingAlgorithm.svg'))
        self.plugin_menu.addMenu(menu_manipulador_tabela)

        #Adicionar Área na Tabela de Atributos
        self.action_add_area = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Area to Table"), self.iface.mainWindow())
        self.action_add_area.triggered.connect(lambda: run_add_area_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_area)

        #Adicionar Azimute em GMS na Tabela de Atributos
        self.action_add_azimute = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Azimuth GMS to Table"), self.iface.mainWindow())
        self.action_add_azimute.triggered.connect(lambda: run_add_azimute_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_azimute)

        #Adicionar Perímetro na Tabela de Atributos
        self.action_add_perimetro = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Perimeter to Table"), self.iface.mainWindow())
        self.action_add_perimetro.triggered.connect(lambda: run_add_perimetro_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_perimetro)

        #Adicionar Coordenada X na Tabela de Atributos
        self.action_add_coord_x = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Coordinate X to Table"), self.iface.mainWindow())
        self.action_add_coord_x.triggered.connect(lambda: run_add_coord_x_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_coord_x)

        #Adicionar Coordenada Y na Tabela de Atributos
        self.action_add_coord_y = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Coordinate Y to Table"), self.iface.mainWindow())
        self.action_add_coord_y.triggered.connect(lambda: run_add_coord_y_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_coord_y)

        #Adicionar Comprimento na Tabela de Atributos
        self.action_add_comprimento = QAction(QIcon(':/images/themes/default/mActionNewAttribute.svg'),
        self.tr("Add Length to Table"), self.iface.mainWindow())
        self.action_add_comprimento.triggered.connect(lambda: run_add_comprimento_tabela(self.iface))
        menu_manipulador_tabela.addAction(self.action_add_comprimento)

        #Sobre o RMCGEO
        self.menu_about = QAction(QIcon(':/images/themes/default/mActionHelpContents.svg'),
            self.tr("About RMCGEO"), self.iface.mainWindow())
        self.menu_about.triggered.connect(self.show_about)
        self.plugin_menu.addAction(self.menu_about)

    def show_about(self):
        dlg = AboutDialog(self.iface.mainWindow())
        dlg.exec_()

    def unload(self):
        if hasattr(self, 'plugin_menu'):
            self.plugin_menu.deleteLater()




