# River Tools QGIS processing plugin : collection of tools for studying rivers

## Brief summary

This is a processing plugin for QGIS. It has 2 tools which can be used to study rivers :

-  segmentation boxes : divides a long polygon, for example a river polygon, into multiple boxes of a given length and width.
- distance along river : distances between pair of points along a river axis (points are projected on this axis)

## Segmentation boxes

This script divides a river into multiple with same length :

illustration goes here !

### Input data :

* a river layer, which can be polygon or line
* an optional line layer for the river centerline, which will be used if river layer is polygon. If river layer is polygon and no centerline is set, it will be calculated
* the length of the boxes to be created, same units as river layer
* the width of the boxes to be created : will only be used if river layer is a line layer, otherwise width will be that of the river

### Ouput data

* polygon layer with boxes
* optionally, river centerline layer

### How it works

There are 3 steps for this plugin :

- creating the polygon centerline, with grass "v.voronoi.skeleton" algorithm, if input layer is set and no centerline provided
- creating points along this centerline at a given interval, using QGIS algorithm "points along line"
- creating Thiessen polygons for this point layer, using QGIS algorithm "Voronoi polygons"
- clipping these polygons by the initial polygon layer, using QGIS algorithm "Clip" if input layer is polygon, or by a buffer of given width if input layer is line

## Distance along river

Given 2 point layers and one line layer, each point gets projected orthogonally on line. Distance is then calculated between each pair of projected points as well as between each pair of original points.

illustration goes here too !

### Input data

- 2 point vector layers
- id fields for each of these layers : points with same id in both layer will be paired
- an input vector layer, which can be a line or a polygon layer. If if it is polygon, its centerline will be calculated

### Output data

- a CSV file with 4 columns : ID in first layer, ID in second layer, straight line distance and projected along river distance
- centerline river, if a polygon river layer was used
- projected on river point layer for each input point layer

### How it works

Points are projected on the line layer using SQL St_ShortestLine function.
