# -*- coding: utf-8 -*-

"""
/***************************************************************************
 RiskAssessment
                                 A QGIS plugin
 Risk assessment calculation for forecast based financing
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-10-11
        copyright            : (C) 2023 by HeiGIT gGmbH
        email                : info@heigit.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "HeiGIT gGmbH"
__date__ = "2023-10-11"
__copyright__ = "(C) 2023 by HeiGIT gGmbH"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

import inspect
import os
import sys

from qgis._core import Qgis
from qgis.core import QgsApplication, QgsProject
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from risk_assessment.proc.risk_assessment_provider import RiskAssessmentProvider
from risk_assessment.weights_generator import WeightsGenerator

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class RiskAssessmentPlugin(object):
    def __init__(self, iface):
        self.provider = None
        self.iface = iface
        self.actions = list()
        self.project = QgsProject.instance()

    def initGui(self):
        """Init Processing provider for QGIS >= 3.8."""
        try:
            icon_path = os.path.join(
                os.path.dirname(__file__), "icon_riskassessment_weightgenerator.png"
            )
            self.action = QAction(
                QIcon(icon_path), "WeightsGenerator", self.iface.mainWindow()
            )

            self.actions.append(self.action)

            self.iface.pluginToolBar().addAction(self.action)

            self.widget = WeightsGenerator(self.project, self.iface)
            self.widget.setWindowFlags(
                self.widget.windowFlags() | Qt.WindowType.WindowStaysOnTopHint
            )
            self.action.triggered.connect(self.widget_display)

            self.provider = RiskAssessmentProvider()
            QgsApplication.processingRegistry().addProvider(self.provider)
        except Exception as e:
            self.iface.messageBar().pushMessage(
                f"Error initializing plugin: {e}", level=Qgis.Critical
            )

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)

        for a in self.actions:
            self.iface.removeToolBarIcon(a)
            a.deleteLater()
        self.actions = []

    def widget_display(self) -> None:
        """
        shows the widget.
        """
        self.widget.show()
