# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RGBIndexCalculator
                                 A QGIS plugin
 This plugin is used for calculaitng image (raster) index values based on RGB images.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-11
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Emir Memic
        email                : emir_memic@windowslive.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .rgb_index_calculator_dialog import RGBIndexCalculatorDialog
import os.path


#me
from osgeo import gdal
from qgis.core import *
from qgis.utils import *
from qgis.utils import reloadPlugin
import processing
from qgis.analysis import QgsRasterCalculatorEntry, QgsRasterCalculator
from qgis.PyQt.QtWidgets import QMessageBox

class RGBIndexCalculator:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'RGBIndexCalculator_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&RGB Index Calculator')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('RGBIndexCalculator', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/rgb_index_calculator/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'RGB Index Calculator'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&RGB Index Calculator'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = RGBIndexCalculatorDialog()

        # me-start
        reloadPlugin('rgb_index_calculator')
        print ('run rgb_index_calculator plugin')        
        self.dlg.checkBox_5.setChecked(False)        
        self.dlg.listWidget.clear()

        # add available layers into interface
        layers = self.iface.mapCanvas().layers()
        listOfLayers = []

        for layer in layers:
            listOfLayers.append(str(layer.name()))
                
            QCoreApplication.processEvents()
        self.dlg.listWidget.addItems(listOfLayers)    

        self.dlg.pushButton_2.clicked.connect(self.calculate_ndvi_other)
        # me-end

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

         
    def calculate_ndvi_other(self):
                 
        selectedLayer = str(self.dlg.listWidget.currentItem().text())            
        layerUse = QgsProject.instance().mapLayersByName(selectedLayer)[0] 

        print ('layerUse', layerUse)

        nir = int(self.dlg.lineEdit.text()) 
        red = int(self.dlg.lineEdit_2.text())          
        
        mePath = layerUse.dataProvider().dataSourceUri()       
        mePath = os.path.normpath(mePath)
        mePath = os.path.dirname(mePath)
        print ('mePath', mePath)

        try:
            os.mkdir(mePath + '\ProcessedOutputs')
        except:
            print ('dir exist')
        setPathMe = mePath + '\ProcessedOutputs'
        print ('setPathMe input image', setPathMe) 
        
        if self.dlg.checkBox.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/VARI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '("ras2@2" -  "ras1@1") / ("ras1@1" + "ras2@2" - "ras3@3")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _VARI')
            iface.addRasterLayer(output)   

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()

        if self.dlg.checkBox_2.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/GLI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '((2 * "ras2@2") -  "ras1@1" - "ras3@3") / ((2 * "ras2@2") +  "ras1@1" + "ras3@3")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _GLI')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()

        if self.dlg.checkBox_3.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/NGRDI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '("ras2@2" -  "ras1@1") / ("ras2@2" +  "ras1@1")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _NGRDI')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()

        if self.dlg.checkBox_4.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/NGBDI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '("ras2@2" -  "ras3@3") / ("ras2@2" +  "ras3@3")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _NGBDI')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()

        if self.dlg.checkBox_6.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/INT_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '("ras1@1" +  "ras2@2" +  "ras3@3")/3', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _INT')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()

        if self.dlg.checkBox_7.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/IKAW_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '("ras1@1" -  "ras3@3") / ("ras1@1" +  "ras3@3")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _IKAW')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()


        if self.dlg.checkBox_8.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/MGRVI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '(("ras2@2"*"ras2@2") -  ("ras1@1"*"ras1@1")) / (("ras2@2"*"ras2@2") +  ("ras1@1"*"ras1@1"))', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _MGRVI')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()


        if self.dlg.checkBox_9.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/RGBVI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '(("ras2@2"*"ras2@2") -  ("ras3@3" * "ras1@1")) / (("ras2@2"*"ras2@2") +  ("ras3@3" * "ras1@1"))', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _RGBVI')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()


        if self.dlg.checkBox_10.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/RGRI_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '("ras1@1") / ("ras2@2")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _RGRI')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()


        if self.dlg.checkBox_11.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/EXG_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '((2 * "ras2@2") -  "ras1@1" - "ras3@3")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _EXG')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()


        if self.dlg.checkBox_12.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/ExR_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '((1.4 * "ras1@1") - "ras2@2")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _ExR')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()


        if self.dlg.checkBox_13.isChecked():
            
            lyr = layerUse
            entries = []
            #Define red band#
            ras1 = QgsRasterCalculatorEntry()
            ras1.ref = 'ras1@1'
            ras1.raster = lyr
            ras1.bandNumber = 1
            entries.append(ras1)
            #Define green band#
            ras2 = QgsRasterCalculatorEntry()
            ras2.ref = 'ras2@2'
            ras2.raster = lyr
            ras2.bandNumber = 2
            entries.append( ras2 )
            #Define nir band#
            ras3 = QgsRasterCalculatorEntry()
            ras3.ref = 'ras3@3'
            ras3.raster = lyr
            ras3.bandNumber = 3
            entries.append( ras3 )
            
            output = setPathMe + '/ExGR_{}.tif'.format(selectedLayer)
            calc = QgsRasterCalculator( '((3 * "ras2@2") - (2.4 * "ras2@2") - "ras3@3")', output, 'GTiff', lyr.extent(), lyr.width(), lyr.height(), entries )
            calc.processCalculation() 
            print ('finished _ExGR')
            iface.addRasterLayer(output) 

            if self.dlg.checkBox_5.isChecked():
                layer = iface.activeLayer()
                #layer.setOpacity(0.75)
                provider = layer.dataProvider()
                provider.setNoDataValue(1, 0) #first one is referred to band number                 
                layer.triggerRepaint()

