# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ReturnPyQGISAlgorithm
                                 A QGIS plugin
 Returns pyQGIS algorithms based on an algorithm name.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-15
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Angus Hunt
        email                : angusfhunt@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QCompleter, QMessageBox
from qgis.core import QgsApplication, QgsProcessing
import os, fnmatch, sys
from io import StringIO  # Python3
from qgis import processing
try:
    import clipboard as c
except:
    raise Exception("Python library 'clipboard' is not installed. To install it, follow these instructions: https://landscapearchaeology.org/2018/installing-python-packages-in-qgis-3-for-windows/")

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .return_pyqgis_algorithm_dialog import ReturnPyQGISAlgorithmDialog
import os.path


class ReturnPyQGISAlgorithm:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ReturnPyQGISAlgorithm_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Return PyQGIS Algorithm')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ReturnPyQGISAlgorithm', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        self.iface.registerMainWindowAction(action, "Ctrl+Alt+Space")
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/return_pyqgis_algorithm/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Copy PyQGIS Algorithm Code'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Return PyQGIS Algorithm'),
                action)
            self.iface.removeToolBarIcon(action)

    def returnAlg(self):  
        # get params
        returnResultStr = ''
        getOutputStr = ''

        params = {}
        for param in self.alg.parameterDefinitions():
            params[param.name()] = param.defaultValue()

        if self.dlg.virtualLayerCheckBox.isChecked():
            returnResultStr = 'res = '
            getOutputStr = '\noutput = res["OUTPUT"]'
            params["OUTPUT"] = "TEMPORARY_OUTPUT"
    
        paramsStr = str(params)
        paramsStr = paramsStr.replace(", ", ",\\\n\t").replace("{", "{\n\t").replace("}", "\n}")
        if 'native' not in self.alg.id():
            paramsStr = paramsStr.replace("'TEMPORARY_OUTPUT'", 'QgsProcessing.TEMPORARY_OUTPUT')
        function = f'{returnResultStr}processing.run("{self.alg.id()}", {paramsStr}){getOutputStr}'
        
        c.copy(function)
        message_function = function.replace("\t", "    ")
        QMessageBox.information(None, "QGIS Algorithm", "✅ Function copied to clipboard\n\n" + message_function)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = ReturnPyQGISAlgorithmDialog()
            self.keyErrorCount = 0

        # auto complete options       
        labelsToAlgs = {}                                          
        algSelection = []
        for alg in QgsApplication.processingRegistry().algorithms():
            name = alg.displayName()
            # name = alg.displayName()
            provider = alg.provider().name()
            label = f"{name} ({provider})"
            labelsToAlgs[label] = alg
            algSelection.append(label)
        completer = QCompleter(algSelection)

        # create line edit and add auto complete       
        completer.setFilterMode(Qt.MatchContains)                         
        self.dlg.lineEdit.setCompleter(completer)

        # show the dialog
        self.dlg.show()
        self.dlg.lineEdit.setFocus()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            text = self.dlg.lineEdit.text()
            try:
                self.alg = labelsToAlgs[text]
                self.returnAlg()
                self.dlg.lineEdit.setText("")
            except KeyError:
                QMessageBox.critical(None, "Error", f"You must enter an existing algorithm in the text box. You entered: {text}")
                self.dlg.lineEdit.setText("")
                self.keyErrorCount += 1
                if self.keyErrorCount < 5:
                    self.run()
                else:
                    # safegaurding against infinite input bug
                    self.keyErrorCount = 0
            pass