# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ReplaceGeometry
                                 A QGIS plugin
 Replaces a geometry keeping the attributes unchanged
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
 
                              -------------------
        begin                : 2022-04-02
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Valerio Pinna 
        email                : pinnavalerio@yahoo.co.uk
        
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsApplication, QgsMapLayer, QgsMessageLog
from qgis.PyQt.QtWidgets import QAction, QMenu, QToolButton  # Qt5
from PyQt5.QtWidgets import QMessageBox
from qgis.core import (QgsWkbTypes,
                       QgsProject,
                       QgsVectorLayerTools,
                       QgsVectorFileWriter,
                       QgsGeometry,
                       QgsPoint,
                       QgsPointXY,
                       QgsFeatureRequest,
                       QgsVectorLayer,
                       QgsDistanceArea,
                       QgsUnitTypes,
                       QgsEditFormConfig)
                       

from qgis.utils import iface

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .replace_geometry_dialog import ReplaceGeometryDialog
import os.path




class ReplaceGeometry:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ReplaceGeometry_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Replace Geometry')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ReplaceGeometry', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/replace_geometry/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Replace Geometry'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Replace Geometry'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""
        layers_list = QgsProject.instance().mapLayers()
        ext_canvas = QgsGeometry.fromRect(iface.mapCanvas().extent())
        old_ids = [] 
        
        if len(layers_list)!= 0:                            
            layer = iface.activeLayer()
            for f in layer.getFeatures():
                            old_ids.append(f.id())
                   
            if layer is not None:
                if layer.type() != QgsVectorLayer.VectorLayer:
                    return self.dontdonothing()
 
                if layer.type() == QgsVectorLayer.VectorLayer:              
                    # Check, with messages, that only one feature is selected
                    if layer.selectedFeatureCount() == 0:
                        QMessageBox.warning(
                        None,
                        'Replace Geometry Plugin',
                        'There is no selection. Select one feature.')
                    elif layer.selectedFeatureCount() >= 2: 
                         QMessageBox.warning(None,
                       'Replace Geometry Plugin',
                        'The selection contains multiple features. Select only one feature.')
                             
                    else:        
                        for feature in layer.selectedFeatures():
                            if ext_canvas.intersects(feature.geometry()):
                                old_id = [feature.id()]
                                
                            if not feature.geometry().intersects(ext_canvas):
                                reply = QMessageBox.warning(None,  'Replace Geometry Plugin',
                                                    'The selected feature is outside of the current map view. Would you still like to continue?',
                                                    QMessageBox.Yes, QMessageBox.No)
                                if reply == QMessageBox.No: 
                                    return self.dontdonothing()
                                            
                                if reply == QMessageBox.Yes:
               
                                    old_id = [feature.id()]
                                
                        def new_feature_added(self): 
                            iface.actionSelect().trigger()
                            layer.featureAdded.disconnect()
                            new_ids = []
                            for f in layer.getFeatures():
                                new_ids.append(f.id())

                            for e in old_ids:
                                if e in new_ids:
                                    new_ids.remove(e)
                            new_feat_id = new_ids[0]
 
                            layer.selectByIds([new_feat_id])
                            for feature in layer.selectedFeatures():
                                new_WKT = feature.geometry().asWkt()                        
                            
                            layer.startEditing()
                            layer.beginEditCommand("Replace Geometry")
                            layer.selectByIds(old_id)
                            for feature in layer.selectedFeatures():
                                final_id = feature.id()
                                new_geometry = QgsGeometry.fromWkt(new_WKT)
                                layer.changeGeometry(final_id, new_geometry)
                                                    
                            layer.deleteFeature(new_feat_id)
                                                        
                            # Save the changes in the buffer 
                            layer.triggerRepaint()
                            #iface.mapCanvas().refresh()
                            
                            layer.endEditCommand()
                            
                            iface.setActiveLayer(layer)           
                            # Reselect the old feature
                            layer.selectByIds(old_id)
                            QSettings().setValue("/Qgis/digitizing/disable_enter_attribute_values_dialog", popup_status)
  
                        layer.featureAdded.connect(new_feature_added)

                        # Set the layer in edit mode
                        layer.startEditing()
                        ###check the attribute popup status: false is on (appeare), true is off(don't appeare)
                        popup_status = QSettings().value("/Qgis/digitizing/disable_enter_attribute_values_dialog")
                        #####turn temporarly off the attribute form popup
                        if popup_status == False:
                            QSettings().setValue("/Qgis/digitizing/disable_enter_attribute_values_dialog", True)
                            
                            
                        #Activate the QGIS add feature tool
                        iface.actionAddFeature().trigger()    

    def dontdonothing(self):
            pass
